/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.content.entity.metalgolem;

import dev.xkmc.l2serial.serialization.marker.SerialClass;
import dev.xkmc.modulargolems.content.config.GolemMaterial;
import dev.xkmc.modulargolems.content.config.GolemMaterialConfig;
import dev.xkmc.modulargolems.content.entity.common.SweepGolemEntity;
import dev.xkmc.modulargolems.content.entity.dog.DogGolemEntity;
import dev.xkmc.modulargolems.content.entity.humanoid.weapon.GolemWeaponRegistry;
import dev.xkmc.modulargolems.content.entity.metalgolem.MetalGolemPartType;
import dev.xkmc.modulargolems.content.item.equipments.CustomSweepBoxWeapon;
import dev.xkmc.modulargolems.content.item.equipments.ExtraAttackGolemWeapon;
import dev.xkmc.modulargolems.init.advancement.GolemTriggers;
import dev.xkmc.modulargolems.init.data.MGConfig;
import java.util.function.Predicate;
import net.minecraft.advancements.critereon.PlayerTrigger;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Crackiness;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.CommonHooks;

@SerialClass
public class MetalGolemEntity
extends SweepGolemEntity<MetalGolemEntity, MetalGolemPartType> {
    private int attackAnimationTick;

    public MetalGolemEntity(EntityType<MetalGolemEntity> type, Level level) {
        super(GolemWeaponRegistry.LARGE, type, level);
    }

    @Override
    protected AABB getAttackBoundingBox(Entity target, double range) {
        Item item = this.getMainHandItem().getItem();
        if (item instanceof CustomSweepBoxWeapon) {
            CustomSweepBoxWeapon weapon = (CustomSweepBoxWeapon)item;
            return weapon.getAttackBoundingBox(this, target, range, this.getMainHandItem());
        }
        return target.getBoundingBox().inflate(range);
    }

    @Override
    protected boolean performDamageTarget(Entity target, float damage, double kb) {
        Level level = this.level();
        if (!(level instanceof ServerLevel)) {
            return false;
        }
        ServerLevel sl = (ServerLevel)level;
        DamageSource source = this.level().damageSources().mobAttack((LivingEntity)this);
        if (target instanceof LivingEntity) {
            LivingEntity le = (LivingEntity)target;
            le.setLastHurtByPlayer(this.getOwner());
            damage = EnchantmentHelper.modifyDamage((ServerLevel)sl, (ItemStack)this.getWeaponItem(), (Entity)target, (DamageSource)source, (float)damage);
            kb += (double)this.getKnockback(target, source);
        }
        boolean succeed = target.hurt(source, damage);
        Item item = this.getMainHandItem().getItem();
        if (item instanceof ExtraAttackGolemWeapon) {
            ExtraAttackGolemWeapon item2 = (ExtraAttackGolemWeapon)item;
            succeed |= item2.repeatAttack(this, target, damage, succeed);
        }
        if (succeed) {
            double dokb = 0.4 * kb;
            target.setDeltaMovement(target.getDeltaMovement().add(0.0, dokb, 0.0));
            EnchantmentHelper.doPostAttackEffects((ServerLevel)sl, (Entity)target, (DamageSource)source);
        }
        return succeed;
    }

    public ItemStack getProjectile(ItemStack pShootable) {
        ItemStack ans;
        if (pShootable.getItem() instanceof ProjectileWeaponItem) {
            Predicate predicate = ((ProjectileWeaponItem)pShootable.getItem()).getSupportedHeldProjectiles();
            ItemStack stack = ProjectileWeaponItem.getHeldProjectile((LivingEntity)this, (Predicate)predicate);
            ans = CommonHooks.getProjectile((LivingEntity)this, (ItemStack)pShootable, (ItemStack)stack);
        } else {
            ans = CommonHooks.getProjectile((LivingEntity)this, (ItemStack)pShootable, (ItemStack)ItemStack.EMPTY);
        }
        if (this.isHostile()) {
            ans = ans.copy();
        }
        return ans;
    }

    @Override
    public void aiStep() {
        super.aiStep();
        if (this.attackAnimationTick > 0) {
            --this.attackAnimationTick;
        }
        if (this.getDeltaMovement().horizontalDistanceSqr() > 2.500000277905201E-7 && this.random.nextInt(5) == 0) {
            int i = Mth.floor((double)this.getX());
            int j = Mth.floor((double)(this.getY() - (double)0.2f));
            int k = Mth.floor((double)this.getZ());
            BlockPos pos = new BlockPos(i, j, k);
            BlockState blockstate = this.level().getBlockState(pos);
            if (!blockstate.isAir()) {
                this.level().addParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, blockstate).setPos(pos), this.getX() + ((double)this.random.nextFloat() - 0.5) * (double)this.getBbWidth(), this.getY() + 0.1, this.getZ() + ((double)this.random.nextFloat() - 0.5) * (double)this.getBbWidth(), 4.0 * ((double)this.random.nextFloat() - 0.5), 0.5, ((double)this.random.nextFloat() - 0.5) * 4.0);
            }
        }
    }

    @Override
    public boolean doHurtTarget(Entity target) {
        double kb;
        this.attackAnimationTick = 10;
        this.level().broadcastEntityEvent((Entity)this, (byte)4);
        float damage = this.getAttackDamage();
        if (target instanceof LivingEntity) {
            LivingEntity le = (LivingEntity)target;
            kb = le.getAttributeValue(Attributes.KNOCKBACK_RESISTANCE);
        } else {
            kb = 0.0;
        }
        boolean flag = this.performRangedDamage(target, damage, Math.max(0.0, 1.0 - kb));
        this.playSound(SoundEvents.IRON_GOLEM_ATTACK, 1.0f, 1.0f);
        return flag;
    }

    public boolean hurt(DamageSource source, float amount) {
        Crackiness.Level crack = this.getCrackiness();
        boolean flag = super.hurt(source, amount);
        if (flag && this.getCrackiness() != crack) {
            this.playSound(SoundEvents.IRON_GOLEM_DAMAGE, 1.0f, 1.0f);
        }
        return flag;
    }

    public Crackiness.Level getCrackiness() {
        return Crackiness.GOLEM.byFraction(this.getHealth() / this.getMaxHealth());
    }

    @Override
    public void handleEntityEvent(byte event) {
        if (event == 4) {
            this.attackAnimationTick = 10;
            this.playSound(SoundEvents.IRON_GOLEM_ATTACK, 1.0f, 1.0f);
        } else {
            super.handleEntityEvent(event);
        }
    }

    public int getAttackAnimationTick() {
        return this.attackAnimationTick;
    }

    protected SoundEvent getHurtSound(DamageSource p_28872_) {
        return SoundEvents.IRON_GOLEM_HURT;
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.IRON_GOLEM_DEATH;
    }

    protected void playStepSound(BlockPos p_28864_, BlockState p_28865_) {
        this.playSound(SoundEvents.IRON_GOLEM_STEP, 1.0f, 1.0f);
    }

    public boolean checkSpawnObstruction(LevelReader p_28853_) {
        BlockPos blockpos = this.blockPosition();
        BlockPos blockpos1 = blockpos.below();
        BlockState blockstate = p_28853_.getBlockState(blockpos1);
        if (!blockstate.entityCanStandOn((BlockGetter)p_28853_, blockpos1, (Entity)this)) {
            return false;
        }
        for (int i = 1; i < 3; ++i) {
            BlockState blockstate1;
            BlockPos blockpos2 = blockpos.above(i);
            if (NaturalSpawner.isValidEmptySpawnBlock((BlockGetter)p_28853_, (BlockPos)blockpos2, (BlockState)(blockstate1 = p_28853_.getBlockState(blockpos2)), (FluidState)blockstate1.getFluidState(), (EntityType)EntityType.IRON_GOLEM)) continue;
            return false;
        }
        return NaturalSpawner.isValidEmptySpawnBlock((BlockGetter)p_28853_, (BlockPos)blockpos, (BlockState)p_28853_.getBlockState(blockpos), (FluidState)Fluids.EMPTY.defaultFluidState(), (EntityType)EntityType.IRON_GOLEM) && p_28853_.isUnobstructed((Entity)this);
    }

    public Vec3 getLeashOffset() {
        return new Vec3(0.0, (double)(0.875f * this.getEyeHeight()), (double)(this.getBbWidth() * 0.4f));
    }

    @Override
    protected InteractionResult mobInteractImpl(Player player, InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        if (this.getMaterials().size() != MetalGolemPartType.values().length) {
            return super.mobInteractImpl(player, hand);
        }
        GolemMaterial mat = this.getMaterials().get(MetalGolemPartType.BODY.ordinal());
        Ingredient ing = GolemMaterialConfig.get().getRepairIngredient(mat.id());
        if (!ing.test(itemstack)) {
            if (((Boolean)MGConfig.COMMON.strictInteract.get()).booleanValue() && !itemstack.isEmpty()) {
                return InteractionResult.PASS;
            }
            return super.mobInteractImpl(player, hand);
        }
        if (!player.getAbilities().instabuild && this.isHostile()) {
            return InteractionResult.PASS;
        }
        if (this.getHealth() >= this.getMaxHealth() && !this.isReforged()) {
            return InteractionResult.PASS;
        }
        this.repairWithItem();
        float f1 = 1.0f + (this.random.nextFloat() - this.random.nextFloat()) * 0.2f;
        this.playSound(SoundEvents.IRON_GOLEM_REPAIR, 1.0f, f1);
        if (!player.getAbilities().instabuild) {
            itemstack.shrink(1);
        }
        if (!this.level().isClientSide()) {
            ((PlayerTrigger)GolemTriggers.HOT_FIX.get()).trigger((ServerPlayer)player);
        }
        return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
    }

    @Override
    public void checkRide(LivingEntity target) {
        DogGolemEntity dog;
        if (target instanceof DogGolemEntity && (dog = (DogGolemEntity)target).getBbWidth() > this.getBbWidth()) {
            this.startRiding((Entity)target);
        }
    }
}

