/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.content.entity.metalgolem;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import dev.xkmc.modulargolems.content.client.armor.GolemEquipmentModels;
import dev.xkmc.modulargolems.content.client.armor.GolemModelPath;
import dev.xkmc.modulargolems.content.entity.metalgolem.MetalGolemEntity;
import dev.xkmc.modulargolems.content.entity.metalgolem.MetalGolemModel;
import dev.xkmc.modulargolems.content.item.equipments.GolemModelItem;
import dev.xkmc.modulargolems.content.item.equipments.MetalGolemBeaconItem;
import dev.xkmc.modulargolems.events.event.GolemRenderItemInHandEvent;
import dev.xkmc.modulargolems.init.ModularGolems;
import java.util.HashMap;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.ItemInHandRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import org.jetbrains.annotations.NotNull;

public class GolemEquipmentRenderer
extends RenderLayer<MetalGolemEntity, MetalGolemModel> {
    public HashMap<ModelLayerLocation, MetalGolemModel> map = new HashMap();
    private final ItemInHandRenderer itemInHandRenderer;
    final ResourceLocation BEACON_LOCATION = ModularGolems.loc("textures/equipments/beacon.png");
    final ResourceLocation BEAM_LOCATION = ResourceLocation.withDefaultNamespace((String)"textures/entity/beacon_beam.png");

    public GolemEquipmentRenderer(RenderLayerParent<MetalGolemEntity, MetalGolemModel> r, EntityRendererProvider.Context e) {
        super(r);
        this.itemInHandRenderer = e.getItemInHandRenderer();
        for (ModelLayerLocation l : GolemEquipmentModels.LIST) {
            this.map.put(l, new MetalGolemModel(e.bakeLayer(l)));
        }
    }

    public void render(@NotNull PoseStack pose, MultiBufferSource source, int i, @NotNull MetalGolemEntity entity, float f1, float f2, float f3, float f4, float f5, float f6) {
        for (EquipmentSlot e : EquipmentSlot.values()) {
            Item buffer;
            ItemStack stack = entity.getItemBySlot(e);
            Item item = stack.getItem();
            if (item instanceof GolemModelItem) {
                GolemModelItem mgaitem = (GolemModelItem)item;
                buffer = source.getBuffer(RenderType.armorCutoutNoCull((ResourceLocation)mgaitem.getModelTexture()));
                this.renderArmor(mgaitem, pose, (VertexConsumer)buffer, i);
                if (!mgaitem.emissive()) continue;
                buffer = source.getBuffer(RenderType.armorCutoutNoCull((ResourceLocation)mgaitem.getEmissiveModelTexture()));
                this.renderArmor(mgaitem, pose, (VertexConsumer)buffer, 0xF000F0);
                continue;
            }
            buffer = stack.getItem();
            if (buffer instanceof MetalGolemBeaconItem) {
                MetalGolemBeaconItem beacon = (MetalGolemBeaconItem)buffer;
                if (!entity.isAddedToLevel()) {
                    return;
                }
                float[] color = new float[]{1.0f, 1.0f, 1.0f};
                this.renderBeacon(pose, source, i, entity.level().getGameTime(), entity.getBbHeight());
                this.renderBeam(pose, source, i, 1.0f, entity.level().getGameTime(), entity.getBbHeight(), color);
                continue;
            }
            this.renderArmWithItem(entity, stack, e, pose, source, i);
        }
    }

    protected void renderArmor(GolemModelItem mgaitem, PoseStack pose, VertexConsumer buffer, int light) {
        GolemModelPath gmpath = GolemModelPath.get(mgaitem.getModelPath());
        for (List<String> ls : gmpath.paths()) {
            MetalGolemModel model = this.map.get(gmpath.models());
            model.copyFrom((MetalGolemModel)this.getParentModel());
            ModelPart gemr = model.root();
            pose.pushPose();
            for (String s : ls) {
                gemr.translateAndRotate(pose);
                gemr = gemr.getChild(s);
            }
            gemr.render(pose, buffer, light, OverlayTexture.NO_OVERLAY, -1);
            pose.popPose();
        }
    }

    protected void renderArmWithItem(MetalGolemEntity entity, ItemStack stack, EquipmentSlot slot, PoseStack pose, MultiBufferSource source, int light) {
        if (stack.isEmpty()) {
            return;
        }
        ItemDisplayContext ctx = null;
        if (slot == EquipmentSlot.MAINHAND) {
            ctx = ItemDisplayContext.THIRD_PERSON_RIGHT_HAND;
        } else if (slot == EquipmentSlot.OFFHAND) {
            ctx = ItemDisplayContext.THIRD_PERSON_LEFT_HAND;
        }
        if (ctx == null) {
            return;
        }
        HumanoidArm arm = slot == EquipmentSlot.MAINHAND ? entity.getMainArm() : entity.getMainArm().getOpposite();
        pose.pushPose();
        ((MetalGolemModel)this.getParentModel()).transformToHand(slot, pose);
        boolean offhand = slot == EquipmentSlot.OFFHAND;
        pose.translate((float)(offhand ? 1 : -1) * 0.7f, 0.8f, -0.25f);
        pose.mulPose(Axis.XP.rotationDegrees(-90.0f));
        pose.mulPose(Axis.YP.rotationDegrees(180.0f));
        Minecraft.getInstance().getItemRenderer().renderStatic((LivingEntity)entity, stack, ctx, offhand, pose, source, entity.level(), light, OverlayTexture.NO_OVERLAY, entity.getId() + slot.ordinal());
        ItemInHandRenderer r = this.itemInHandRenderer;
        if (!((GolemRenderItemInHandEvent)NeoForge.EVENT_BUS.post((Event)new GolemRenderItemInHandEvent((LivingEntity)entity, stack, ctx, arm, pose, source, light, r))).isCanceled()) {
            r.renderItem((LivingEntity)entity, stack, ctx, offhand, pose, source, light);
        }
        pose.popPose();
    }

    protected void renderBeacon(PoseStack pose, MultiBufferSource source, float pTick, long gameTick, float height) {
        float width = 3.0f;
        pose.pushPose();
        pose.scale(1.0f, -1.0f, 1.0f);
        pose.translate(0.0, (double)(-height / 2.0f), 0.0);
        float accurateTick = (float)Math.floorMod(gameTick, 90) + pTick;
        pose.mulPose(Axis.YP.rotationDegrees(accurateTick - 45.0f));
        VertexConsumer buffer = source.getBuffer(RenderType.armorCutoutNoCull((ResourceLocation)this.BEACON_LOCATION));
        PoseStack.Pose p = pose.last();
        GolemEquipmentRenderer.addVertex(p, buffer, 1.0f, 1.0f, 1.0f, 1.0f, 0, 0.0f, width, 0.0f, 0.0f);
        GolemEquipmentRenderer.addVertex(p, buffer, 1.0f, 1.0f, 1.0f, 1.0f, 0, width, 0.0f, 0.0f, 1.0f);
        GolemEquipmentRenderer.addVertex(p, buffer, 1.0f, 1.0f, 1.0f, 1.0f, 0, 0.0f, -width, 1.0f, 1.0f);
        GolemEquipmentRenderer.addVertex(p, buffer, 1.0f, 1.0f, 1.0f, 1.0f, 0, -width, 0.0f, 1.0f, 0.0f);
        pose.popPose();
    }

    protected void renderBeam(PoseStack pose, MultiBufferSource source, float pTick, float scale, long gameTick, float height, float[] color) {
        float width1 = 0.2f;
        float width2 = 0.25f;
        int length = 1024;
        pose.pushPose();
        pose.scale(1.0f, -1.0f, 1.0f);
        pose.translate(0.0, (double)(height / 2.0f), 0.0);
        float accurateTick = (float)Math.floorMod(gameTick, 40) + pTick;
        float f2 = Mth.frac((float)(accurateTick * 0.2f - (float)Mth.floor((float)(accurateTick * 0.1f))));
        float colorR = color[0];
        float colorG = color[1];
        float colorB = color[2];
        pose.pushPose();
        pose.mulPose(Axis.YP.rotationDegrees(accurateTick * 2.25f - 45.0f));
        float v1 = -1.0f + f2;
        float v2 = (float)length * scale * (0.5f / width1) + v1;
        GolemEquipmentRenderer.renderPart(pose, source.getBuffer(RenderType.beaconBeam((ResourceLocation)this.BEAM_LOCATION, (boolean)false)), colorR, colorG, colorB, 1.0f, 0, length, 0.0f, width1, width1, 0.0f, -width1, 0.0f, 0.0f, -width1, 0.0f, 1.0f, v2, v1);
        pose.popPose();
        v1 = -1.0f + f2;
        v2 = (float)length * scale + v1;
        GolemEquipmentRenderer.renderPart(pose, source.getBuffer(RenderType.beaconBeam((ResourceLocation)this.BEAM_LOCATION, (boolean)true)), colorR, colorG, colorB, 0.125f, 0, length, -width2, -width2, width2, -width2, -width2, width2, width2, width2, 0.0f, 1.0f, v2, v1);
        pose.popPose();
    }

    private static void renderPart(PoseStack pose, VertexConsumer buffer, float r, float g, float b, float a, int start, int end, float p_112164_, float p_112165_, float p_112166_, float p_112167_, float p_112168_, float p_112169_, float p_112170_, float p_112171_, float u1, float u2, float v1, float v2) {
        PoseStack.Pose p = pose.last();
        GolemEquipmentRenderer.renderQuad(p, buffer, r, g, b, a, start, end, p_112164_, p_112165_, p_112166_, p_112167_, u1, u2, v1, v2);
        GolemEquipmentRenderer.renderQuad(p, buffer, r, g, b, a, start, end, p_112170_, p_112171_, p_112168_, p_112169_, u1, u2, v1, v2);
        GolemEquipmentRenderer.renderQuad(p, buffer, r, g, b, a, start, end, p_112166_, p_112167_, p_112170_, p_112171_, u1, u2, v1, v2);
        GolemEquipmentRenderer.renderQuad(p, buffer, r, g, b, a, start, end, p_112168_, p_112169_, p_112164_, p_112165_, u1, u2, v1, v2);
    }

    private static void renderQuad(PoseStack.Pose pose, VertexConsumer buffer, float r, float g, float b, float a, int y1, int y2, float x1, float z1, float x2, float z2, float u1, float u2, float v1, float v2) {
        GolemEquipmentRenderer.addVertex(pose, buffer, r, g, b, a, y2, x1, z1, u2, v1);
        GolemEquipmentRenderer.addVertex(pose, buffer, r, g, b, a, y1, x1, z1, u2, v2);
        GolemEquipmentRenderer.addVertex(pose, buffer, r, g, b, a, y1, x2, z2, u1, v2);
        GolemEquipmentRenderer.addVertex(pose, buffer, r, g, b, a, y2, x2, z2, u1, v1);
    }

    private static void addVertex(PoseStack.Pose pose, VertexConsumer buffer, float r, float g, float b, float a, int y, float x, float z, float u, float v) {
        buffer.addVertex(pose, x, (float)y, z).setColor(r, g, b, a).setUv(u, v).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(pose, 0.0f, 1.0f, 0.0f);
    }
}

