/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.content.entity.humanoid.weapon;

import dev.xkmc.mob_weapon_api.api.ai.ISmartUser;
import dev.xkmc.mob_weapon_api.api.projectile.ProjectileWeaponUseContext;
import dev.xkmc.mob_weapon_api.util.ShootUtils;
import dev.xkmc.modulargolems.content.entity.common.AbstractGolemEntity;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.function.Predicate;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public final class GolemUser
extends Record
implements ISmartUser {
    private final AbstractGolemEntity<?, ?> user;
    @Nullable
    private final LivingEntity target;

    public GolemUser(AbstractGolemEntity<?, ?> user, @Nullable LivingEntity target) {
        this.user = user;
        this.target = target;
    }

    public ItemStack getPreferredProjectile(ItemStack weapon, Predicate<ItemStack> special, Predicate<ItemStack> general) {
        ItemStack ans = this.user.getProjectile(weapon);
        if (!special.test(ans)) {
            return ItemStack.EMPTY;
        }
        return ans;
    }

    public boolean bypassAllConsumption() {
        return this.user.isHostile();
    }

    public boolean hasInfiniteArrow(ItemStack weapon, ItemStack ammo) {
        return ShootUtils.arrowIsInfinite((ItemStack)ammo, (ItemStack)weapon);
    }

    public float getInitialVelocityFactor() {
        return 3.0f;
    }

    public float getInitialInaccuracy() {
        return 0.0f;
    }

    public Vec3 viewVector() {
        assert (this.target != null);
        return ShootUtils.getShootVector((LivingEntity)this.target, (Vec3)this.user.getEyePosition(), (float)1.0f, (float)0.0f, (float)0.0f).vec3();
    }

    public ProjectileWeaponUseContext.AimResult aim(Vec3 arrowOrigin, float velocity, float gravity, float inaccuracy) {
        assert (this.target != null);
        return ShootUtils.getShootVector((LivingEntity)this.target, (Vec3)arrowOrigin, (float)velocity, (float)gravity, (float)inaccuracy);
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{GolemUser.class, "user;target", "user", "target"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{GolemUser.class, "user;target", "user", "target"}, this);
    }

    @Override
    public final boolean equals(Object o) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{GolemUser.class, "user;target", "user", "target"}, this, o);
    }

    public AbstractGolemEntity<?, ?> user() {
        return this.user;
    }

    @Nullable
    public LivingEntity target() {
        return this.target;
    }
}

