/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.content.entity.humanoid.weapon;

import dev.xkmc.mob_weapon_api.api.goals.IMeleeGoal;
import dev.xkmc.mob_weapon_api.api.goals.IRangedWeaponGoal;
import dev.xkmc.modulargolems.content.entity.humanoid.HumanoidGolemEntity;
import dev.xkmc.modulargolems.content.entity.humanoid.weapon.GolemShooterHelper;
import dev.xkmc.modulargolems.events.event.GolemThrowableEvent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;

public class GolemTridentAttackGoal
extends RangedAttackGoal
implements IRangedWeaponGoal<HumanoidGolemEntity> {
    private final HumanoidGolemEntity golem;
    private final IMeleeGoal melee;
    private final float radius;

    public GolemTridentAttackGoal(HumanoidGolemEntity pRangedAttackMob, double pSpeedModifier, int pAttackInterval, float pAttackRadius, IMeleeGoal melee) {
        super((RangedAttackMob)pRangedAttackMob, pSpeedModifier, pAttackInterval, pAttackRadius);
        this.golem = pRangedAttackMob;
        this.melee = melee;
        this.radius = pAttackRadius;
    }

    public double range(ItemStack stack) {
        return this.radius;
    }

    public boolean canUse() {
        LivingEntity target = this.golem.getTarget();
        if (target == null || !super.canUse()) {
            return false;
        }
        if (this.melee.canReachTarget(target)) {
            return false;
        }
        InteractionHand hand = this.golem.getWeaponHand();
        return GolemShooterHelper.isValidThrowableWeapon((LivingEntity)this.golem, this.golem.getItemInHand(hand), hand);
    }

    public void start() {
        super.start();
        this.golem.setAggressive(true);
        this.golem.setInRangeAttack(true);
        this.golem.startUsingItem(this.golem.getWeaponHand());
    }

    public void stop() {
        super.stop();
        this.golem.stopUsingItem();
        this.golem.setAggressive(false);
        this.golem.setInRangeAttack(false);
    }

    public void performRangedAttack(LivingEntity target, float power, ItemStack stack, InteractionHand hand) {
        GolemThrowableEvent throwable = GolemShooterHelper.throwWeapon((LivingEntity)this.golem, stack, hand);
        if (throwable != null && throwable.isThrowable()) {
            Projectile projectile = throwable.createProjectile(this.golem.level());
            GolemShooterHelper.shootAimHelper(target, projectile);
            this.golem.playSound((SoundEvent)SoundEvents.TRIDENT_THROW.value(), 1.0f, 1.0f / (this.golem.getRandom().nextFloat() * 0.4f + 0.8f));
            projectile.getPersistentData().putInt("DespawnFactor", 20);
            this.golem.level().addFreshEntity((Entity)projectile);
            stack.hurtAndBreak(1, (LivingEntity)this.golem, EquipmentSlot.MAINHAND);
        }
    }
}

