/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.content.entity.humanoid.weapon;

import dev.xkmc.mob_weapon_api.util.ShootUtils;
import dev.xkmc.modulargolems.content.entity.humanoid.HumanoidGolemEntity;
import dev.xkmc.modulargolems.events.event.GolemThrowableEvent;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforge.common.NeoForge;
import org.jetbrains.annotations.Nullable;

public class GolemShooterHelper {
    public static boolean isValidThrowableWeapon(LivingEntity user, ItemStack stack, @Nullable InteractionHand hand) {
        if (hand == null) {
            return false;
        }
        GolemThrowableEvent ans = GolemShooterHelper.throwWeapon(user, stack, hand);
        return ans != null && ans.isThrowable();
    }

    @Nullable
    public static GolemThrowableEvent throwWeapon(LivingEntity user, ItemStack stack, InteractionHand hand) {
        Optional loyalty;
        if (!(user instanceof HumanoidGolemEntity)) {
            return null;
        }
        HumanoidGolemEntity golem = (HumanoidGolemEntity)user;
        HolderLookup.RegistryLookup reg = CommonHooks.resolveLookup((ResourceKey)Registries.ENCHANTMENT);
        if (reg != null && (loyalty = reg.get(Enchantments.LOYALTY)).isPresent() && stack.getEnchantmentLevel((Holder)loyalty.get()) > 0) {
            stack = stack.copy();
            ItemEnchantments map = stack.getAllEnchantments(reg);
            ItemEnchantments.Mutable mutable = new ItemEnchantments.Mutable(map);
            mutable.set((Holder)loyalty.get(), 0);
            EnchantmentHelper.setEnchantments((ItemStack)stack, (ItemEnchantments)mutable.toImmutable());
        }
        GolemThrowableEvent event = new GolemThrowableEvent(golem, stack, hand);
        NeoForge.EVENT_BUS.post((Event)event);
        return event;
    }

    public static void shootAimHelper(LivingEntity target, Projectile arrow) {
        ShootUtils.shootAimHelper((LivingEntity)target, (Projectile)arrow, (float)3.0f, (float)0.05f);
    }
}

