/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.content.entity.humanoid.skin;

import com.mojang.authlib.GameProfile;
import dev.xkmc.modulargolems.content.entity.humanoid.skin.SpecialRenderProfile;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.PlayerSkin;
import net.minecraft.client.resources.SkinManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.SkullBlockEntity;

public class ClientProfileManager {
    private static final Map<String, GameProfile> CACHE = new TreeMap<String, GameProfile>();

    @Nullable
    public static SpecialRenderProfile get(String name) {
        GameProfile profile = ClientProfileManager.getProfile(name);
        if (profile == null) {
            return null;
        }
        SkinManager skins = Minecraft.getInstance().getSkinManager();
        PlayerSkin skin = skins.getInsecureSkin(profile);
        PlayerSkin.Model skinModel = skin.model();
        boolean slim = skinModel == PlayerSkin.Model.SLIM;
        ResourceLocation texture = skins.getInsecureSkin(profile).texture();
        if (texture.equals((Object)ResourceLocation.withDefaultNamespace((String)"missingno"))) {
            return null;
        }
        return new SpecialRenderProfile(slim, texture);
    }

    @Nullable
    private static GameProfile getProfile(String name) {
        if (!CACHE.containsKey(name)) {
            CACHE.put(name, null);
            SkullBlockEntity.fetchGameProfile((String)name).thenAccept(x -> x.ifPresent(e -> CACHE.put(name, (GameProfile)e)));
        }
        return CACHE.get(name);
    }
}

