/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.content.entity.humanoid;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import dev.xkmc.modulargolems.compat.curio.ClientCuriosRenderHelper;
import dev.xkmc.modulargolems.content.entity.common.AbstractGolemRenderer;
import dev.xkmc.modulargolems.content.entity.common.GolemBannerLayer;
import dev.xkmc.modulargolems.content.entity.humanoid.HumaniodGolemPartType;
import dev.xkmc.modulargolems.content.entity.humanoid.HumanoidGolemEntity;
import dev.xkmc.modulargolems.content.entity.humanoid.HumanoidGolemModel;
import dev.xkmc.modulargolems.content.entity.humanoid.ItemInGolemHandLayer;
import dev.xkmc.modulargolems.content.entity.humanoid.LayerWrapper;
import dev.xkmc.modulargolems.content.entity.humanoid.skin.ClientSkinDispatch;
import dev.xkmc.modulargolems.content.entity.humanoid.skin.SpecialRenderSkin;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.CustomHeadLayer;
import net.minecraft.client.renderer.entity.layers.ElytraLayer;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemDisplayContext;
import net.neoforged.fml.ModList;
import org.jetbrains.annotations.Nullable;

public class HumanoidGolemRenderer
extends AbstractGolemRenderer<HumanoidGolemEntity, HumaniodGolemPartType, HumanoidGolemModel> {
    public static final ThreadLocal<HumanoidGolemModel> MODEL_DELEGATE = new ThreadLocal();

    protected static void transform(PoseStack stack, ItemDisplayContext transform, @Nullable HumaniodGolemPartType part) {
        float size;
        switch (transform) {
            case GUI: 
            case FIRST_PERSON_LEFT_HAND: 
            case FIRST_PERSON_RIGHT_HAND: {
                break;
            }
            case THIRD_PERSON_LEFT_HAND: 
            case THIRD_PERSON_RIGHT_HAND: {
                stack.translate(0.25, 0.4, 0.5);
                size = 0.625f;
                stack.scale(size, size, size);
                break;
            }
            case GROUND: {
                stack.translate(0.25, 0.0, 0.5);
                size = 0.625f;
                stack.scale(size, size, size);
                break;
            }
            case NONE: 
            case HEAD: 
            case FIXED: {
                stack.translate(0.5, 0.5, 0.5);
                float size2 = 0.5f;
                stack.scale(size2, -size2, size2);
                stack.translate(0.0, -0.5, 0.0);
                return;
            }
            default: {
                stack.translate(0.0, 0.0, 0.5);
            }
        }
        stack.mulPose(Axis.ZP.rotationDegrees(135.0f));
        stack.mulPose(Axis.YP.rotationDegrees(-155.0f));
        if (part == null) {
            size = 0.45f;
            stack.scale(size, size, size);
            stack.translate(0.0f, -2.0f, 0.0f);
        } else if (part == HumaniodGolemPartType.BODY) {
            size = 0.65f;
            stack.scale(size, size, size);
            stack.translate(0.0, -1.2, 0.0);
        } else if (part == HumaniodGolemPartType.LEGS) {
            size = 0.8f;
            stack.scale(size, size, size);
            stack.translate(0.0f, -2.0f, 0.0f);
        } else if (part == HumaniodGolemPartType.ARMS) {
            size = 0.6f;
            stack.scale(size, size, size);
            stack.translate(0.0, -1.5, 0.0);
        }
    }

    public HumanoidGolemRenderer(EntityRendererProvider.Context ctx) {
        this(ctx, false);
    }

    public HumanoidGolemRenderer(EntityRendererProvider.Context ctx, boolean slim) {
        super(ctx, new HumanoidGolemModel(ctx.bakeLayer(slim ? ModelLayers.PLAYER_SLIM : ModelLayers.PLAYER), slim), 0.5f, HumaniodGolemPartType::values);
        this.addLayer((RenderLayer)new HumanoidArmorLayer((RenderLayerParent)this, new HumanoidModel(ctx.bakeLayer(slim ? ModelLayers.PLAYER_SLIM_INNER_ARMOR : ModelLayers.PLAYER_INNER_ARMOR)), new HumanoidModel(ctx.bakeLayer(slim ? ModelLayers.PLAYER_SLIM_OUTER_ARMOR : ModelLayers.PLAYER_OUTER_ARMOR)), ctx.getModelManager()));
        this.addLayer((RenderLayer)new CustomHeadLayer((RenderLayerParent)this, ctx.getModelSet(), 1.0f, 1.0f, 1.0f, ctx.getItemInHandRenderer()));
        this.addLayer((RenderLayer)new ElytraLayer((RenderLayerParent)this, ctx.getModelSet()));
        this.addLayer(new LayerWrapper(this, new ItemInGolemHandLayer(this, ctx.getItemInHandRenderer())));
        this.addLayer(new GolemBannerLayer(this, ctx.getItemInHandRenderer()));
        if (ModList.get().isLoaded("curios")) {
            ClientCuriosRenderHelper.addLayer(this);
        }
    }

    @Override
    public void render(HumanoidGolemEntity entity, float f1, float f2, PoseStack stack, MultiBufferSource source, int i) {
        Entity camera = Minecraft.getInstance().getCameraEntity();
        if (Minecraft.getInstance().options.getCameraType() == CameraType.FIRST_PERSON && camera != null && camera.getVehicle() != null && entity.getVehicle() == camera.getVehicle()) {
            return;
        }
        SpecialRenderSkin profile = ClientSkinDispatch.get(entity);
        if (profile != null) {
            profile.render(entity, f1, f2, stack, source, i);
            return;
        }
        this.renderImpl(entity, f1, f2, stack, source, i);
    }

    public void renderImpl(HumanoidGolemEntity entity, float f1, float f2, PoseStack stack, MultiBufferSource source, int i) {
        super.render(entity, f1, f2, stack, source, i);
    }

    public HumanoidGolemModel getModel() {
        HumanoidGolemModel override = MODEL_DELEGATE.get();
        if (override != null) {
            return override;
        }
        return (HumanoidGolemModel)super.getModel();
    }
}

