/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.content.entity.humanoid;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import dev.xkmc.modulargolems.content.client.armor.GolemEquipmentModels;
import dev.xkmc.modulargolems.content.entity.common.IGolemModel;
import dev.xkmc.modulargolems.content.entity.common.IHeadedModel;
import dev.xkmc.modulargolems.content.entity.humanoid.HumaniodGolemPartType;
import dev.xkmc.modulargolems.content.entity.humanoid.HumanoidGolemEntity;
import dev.xkmc.modulargolems.content.entity.humanoid.weapon.GolemShooterHelper;
import net.minecraft.client.model.AnimationUtils;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.neoforged.neoforge.common.ItemAbilities;

public class HumanoidGolemModel
extends PlayerModel<HumanoidGolemEntity>
implements IGolemModel<HumanoidGolemEntity, HumaniodGolemPartType, HumanoidGolemModel>,
IHeadedModel {
    public HumanoidGolemModel(EntityModelSet set) {
        this(set.bakeLayer(GolemEquipmentModels.HUMANOID), false);
    }

    public HumanoidGolemModel(ModelPart modelPart, boolean slim) {
        super(modelPart, slim);
    }

    @Override
    public void renderToBufferInternal(HumaniodGolemPartType type, PoseStack stack, VertexConsumer consumer, int i, int j, int alpha) {
        if (type == HumaniodGolemPartType.BODY) {
            this.body.render(stack, consumer, i, j, alpha);
            this.head.render(stack, consumer, i, j, alpha);
            this.hat.render(stack, consumer, i, j, alpha);
        } else if (type == HumaniodGolemPartType.ARMS) {
            this.leftArm.render(stack, consumer, i, j, alpha);
            this.rightArm.render(stack, consumer, i, j, alpha);
        } else if (type == HumaniodGolemPartType.LEGS) {
            this.leftLeg.render(stack, consumer, i, j, alpha);
            this.rightLeg.render(stack, consumer, i, j, alpha);
        }
    }

    @Override
    public ResourceLocation getTextureLocationInternal(ResourceLocation rl) {
        return rl.withPath(e -> "textures/entity/humanoid_golem/" + e + ".png");
    }

    public void setupAnim(HumanoidGolemEntity entity, float f1, float f2, float f3, float f4, float f5) {
        super.setupAnim((LivingEntity)entity, f1, f2, f3, f4, f5);
        if (entity.isAggressive() && this.attackTime == 0.0f) {
            if (this.leftArmPose == HumanoidModel.ArmPose.ITEM) {
                this.leftArm.xRot = -1.8f;
            } else if (this.rightArmPose == HumanoidModel.ArmPose.ITEM) {
                this.rightArm.xRot = -1.8f;
            }
        }
        this.leftSleeve.copyFrom(this.leftArm);
        this.rightSleeve.copyFrom(this.rightArm);
    }

    protected void setupAttackAnimation(HumanoidGolemEntity entity, float time) {
        if ((this.leftArmPose == HumanoidModel.ArmPose.ITEM || this.rightArmPose == HumanoidModel.ArmPose.ITEM) && this.attackTime > 0.0f) {
            AnimationUtils.swingWeaponDown((ModelPart)this.rightArm, (ModelPart)this.leftArm, (Mob)entity, (float)this.attackTime, (float)time);
        } else {
            super.setupAttackAnimation((LivingEntity)entity, time);
        }
    }

    public void prepareMobModel(HumanoidGolemEntity entity, float pLimbSwing, float pLimbSwingAmount, float pPartialTick) {
        this.rightArmPose = HumanoidModel.ArmPose.EMPTY;
        this.leftArmPose = HumanoidModel.ArmPose.EMPTY;
        InteractionHand hand = entity.getWeaponHand();
        ItemStack itemstack = entity.getItemInHand(hand);
        HumanoidModel.ArmPose pos = HumanoidModel.ArmPose.EMPTY;
        if (entity.isAggressive() && GolemShooterHelper.isValidThrowableWeapon((LivingEntity)entity, itemstack, hand) && entity.isUsingItem()) {
            pos = HumanoidModel.ArmPose.THROW_SPEAR;
        } else if (entity.isAggressive() && itemstack.getUseAnimation() == UseAnim.BOW) {
            pos = HumanoidModel.ArmPose.BOW_AND_ARROW;
        } else if (itemstack.getUseAnimation() == UseAnim.CROSSBOW) {
            if (entity.isChargingCrossbow()) {
                pos = HumanoidModel.ArmPose.CROSSBOW_CHARGE;
            } else if (entity.isAggressive()) {
                pos = HumanoidModel.ArmPose.CROSSBOW_HOLD;
            }
        } else if (entity.isAggressive()) {
            pos = HumanoidModel.ArmPose.ITEM;
        }
        HumanoidModel.ArmPose anti_pos = HumanoidModel.ArmPose.EMPTY;
        if (hand == InteractionHand.OFF_HAND) {
            anti_pos = pos;
            pos = HumanoidModel.ArmPose.EMPTY;
        }
        if (entity.isBlocking()) {
            if (entity.getMainHandItem().canPerformAction(ItemAbilities.SHIELD_BLOCK)) {
                pos = HumanoidModel.ArmPose.BLOCK;
            } else {
                anti_pos = HumanoidModel.ArmPose.BLOCK;
            }
        }
        if (entity.getMainArm() == HumanoidArm.RIGHT) {
            this.rightArmPose = pos;
            this.leftArmPose = anti_pos;
        } else {
            this.leftArmPose = pos;
            this.rightArmPose = anti_pos;
        }
        super.prepareMobModel((LivingEntity)entity, pLimbSwing, pLimbSwingAmount, pPartialTick);
    }

    @Override
    public void translateToHead(PoseStack pose) {
        pose.translate(0.0f, -0.25f, 0.0f);
        pose.mulPose(Axis.YP.rotationDegrees(180.0f));
        pose.scale(0.625f, -0.625f, -0.625f);
    }
}

