/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.content.entity.humanoid;

import dev.xkmc.l2serial.serialization.marker.SerialClass;
import dev.xkmc.l2serial.serialization.marker.SerialField;
import dev.xkmc.mob_weapon_api.api.ai.ItemWrapper;
import dev.xkmc.modulargolems.content.entity.common.SweepGolemEntity;
import dev.xkmc.modulargolems.content.entity.dog.DogGolemEntity;
import dev.xkmc.modulargolems.content.entity.humanoid.HumaniodGolemPartType;
import dev.xkmc.modulargolems.content.entity.humanoid.weapon.GolemWeaponRegistry;
import dev.xkmc.modulargolems.content.item.golem.GolemHolder;
import dev.xkmc.modulargolems.events.event.GolemDamageShieldEvent;
import dev.xkmc.modulargolems.events.event.GolemDisableShieldEvent;
import dev.xkmc.modulargolems.events.event.GolemEquipEvent;
import dev.xkmc.modulargolems.events.event.GolemSweepEvent;
import dev.xkmc.modulargolems.init.advancement.GolemEquipTrigger;
import dev.xkmc.modulargolems.init.advancement.GolemTriggers;
import dev.xkmc.modulargolems.init.data.MGConfig;
import dev.xkmc.modulargolems.init.data.MGTagGen;
import java.util.Arrays;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.advancements.critereon.PlayerTrigger;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.monster.CrossbowAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.common.NeoForge;

@SerialClass
public class HumanoidGolemEntity
extends SweepGolemEntity<HumanoidGolemEntity, HumaniodGolemPartType>
implements CrossbowAttackMob {
    private static final EntityDataAccessor<Boolean> IS_CHARGING_CROSSBOW = SynchedEntityData.defineId(HumanoidGolemEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    @SerialField
    public int shieldCooldown = 0;
    @SerialField
    private ItemStack backupHand = ItemStack.EMPTY;
    @SerialField
    private ItemStack arrowSlot = ItemStack.EMPTY;
    protected boolean rendering;
    protected boolean render_trigger = false;

    public HumanoidGolemEntity(EntityType<HumanoidGolemEntity> type, Level level) {
        super(GolemWeaponRegistry.HUMANOID, type, level);
        if (!this.level().isClientSide) {
            this.groundNavigation.setCanOpenDoors(true);
        }
    }

    public ItemStack getProjectile(ItemStack pShootable) {
        ItemStack ans;
        if (pShootable.getItem() instanceof ProjectileWeaponItem) {
            Predicate predicate = ((ProjectileWeaponItem)pShootable.getItem()).getSupportedHeldProjectiles(pShootable);
            ItemStack stack = ProjectileWeaponItem.getHeldProjectile((LivingEntity)this, (Predicate)predicate);
            if (stack.isEmpty() && !this.arrowSlot.isEmpty() && predicate.test(this.arrowSlot)) {
                stack = this.arrowSlot;
            }
            ans = CommonHooks.getProjectile((LivingEntity)this, (ItemStack)pShootable, (ItemStack)stack);
        } else {
            ans = CommonHooks.getProjectile((LivingEntity)this, (ItemStack)pShootable, (ItemStack)ItemStack.EMPTY);
        }
        if (this.isHostile()) {
            ans = ans.copy();
        }
        return ans;
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(IS_CHARGING_CROSSBOW, (Object)false);
    }

    public boolean isChargingCrossbow() {
        return (Boolean)this.entityData.get(IS_CHARGING_CROSSBOW);
    }

    public void setChargingCrossbow(boolean pIsCharging) {
        this.entityData.set(IS_CHARGING_CROSSBOW, (Object)pIsCharging);
    }

    public void onCrossbowAttackPerformed() {
        this.noActionTime = 0;
    }

    public void performCrossbowAttack(LivingEntity pUser, float pVelocity) {
        InteractionHand interactionhand = ProjectileUtil.getWeaponHoldingHand((LivingEntity)pUser, item -> item instanceof CrossbowItem);
        ItemStack itemstack = pUser.getItemInHand(interactionhand);
        Item item2 = itemstack.getItem();
        if (item2 instanceof CrossbowItem) {
            CrossbowItem cross = (CrossbowItem)item2;
            cross.performShooting(pUser.level(), pUser, interactionhand, itemstack, pVelocity, 0.0f, this.getTarget());
        }
        this.onCrossbowAttackPerformed();
    }

    @Override
    public InteractionHand getWeaponHand() {
        ItemStack stack = this.getMainHandItem();
        InteractionHand hand = InteractionHand.MAIN_HAND;
        if (stack.canPerformAction(ItemAbilities.SHIELD_BLOCK)) {
            hand = InteractionHand.OFF_HAND;
        }
        return hand;
    }

    public boolean isBlocking() {
        boolean ans;
        boolean bl = ans = this.shieldCooldown == 0 && this.isAggressive() && this.shieldSlot() != null;
        if (ans && this.rendering) {
            this.render_trigger = true;
        }
        return ans;
    }

    public ItemStack getUseItem() {
        ItemStack ans = super.getUseItem();
        if (this.rendering && this.render_trigger) {
            this.render_trigger = false;
            InteractionHand hand = this.shieldSlot();
            if (hand != null) {
                return this.getItemInHand(hand);
            }
        }
        return ans;
    }

    public void onEquippedItemBroken(Item item, EquipmentSlot slot) {
        Player player = this.getOwner();
        if (player != null) {
            ((PlayerTrigger)GolemTriggers.BREAK.get()).trigger((ServerPlayer)player);
        }
    }

    @Override
    public boolean doHurtTarget(Entity target) {
        boolean can_sweep = this.getMainHandItem().canPerformAction(ItemAbilities.SWORD_SWEEP);
        if (!can_sweep) {
            if (super.doHurtTarget(target)) {
                ItemStack stack = this.getItemBySlot(EquipmentSlot.MAINHAND);
                stack.hurtAndBreak(1, (LivingEntity)this, EquipmentSlot.MAINHAND);
                return true;
            }
        } else if (this.performRangedDamage(target, 0.0f, 0.0)) {
            ItemStack stack = this.getItemBySlot(EquipmentSlot.MAINHAND);
            stack.hurtAndBreak(1, (LivingEntity)this, EquipmentSlot.MAINHAND);
            return true;
        }
        return false;
    }

    @Override
    protected AABB getAttackBoundingBox(Entity target, double range) {
        GolemSweepEvent event = new GolemSweepEvent(this, this.getMainHandItem(), target, range);
        NeoForge.EVENT_BUS.post((Event)event);
        return event.getBox();
    }

    @Override
    protected boolean performDamageTarget(Entity target, float damage, double kb) {
        return super.doHurtTarget(target);
    }

    @Override
    protected InteractionResult mobInteractImpl(Player player, InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        if (((Boolean)MGConfig.COMMON.strictInteract.get()).booleanValue() && !itemstack.isEmpty()) {
            return InteractionResult.PASS;
        }
        if (player.isShiftKeyDown()) {
            if (this.canModify(player)) {
                for (EquipmentSlot slot : EquipmentSlot.values()) {
                    this.dropSlot(slot, false);
                }
            }
            if (itemstack.isEmpty()) {
                super.mobInteractImpl(player, hand);
            }
            return InteractionResult.SUCCESS;
        }
        if (itemstack.isEmpty()) {
            return super.mobInteractImpl(player, hand);
        }
        if (itemstack.getItem() instanceof GolemHolder || !itemstack.getItem().canFitInsideContainerItems() || !this.canModify(player)) {
            return InteractionResult.FAIL;
        }
        GolemEquipEvent event = new GolemEquipEvent(this, itemstack);
        NeoForge.EVENT_BUS.post((Event)event);
        if (event.canEquip()) {
            if (this.level().isClientSide()) {
                return InteractionResult.SUCCESS;
            }
            if (this.hasItemInSlot(event.getSlot())) {
                this.dropSlot(event.getSlot(), false);
            }
            if (this.hasItemInSlot(event.getSlot())) {
                return InteractionResult.FAIL;
            }
            this.setItemSlot(event.getSlot(), itemstack.split(event.getAmount()));
            int count = (int)Arrays.stream(EquipmentSlot.values()).filter(e -> !this.getItemBySlot((EquipmentSlot)e).isEmpty()).count();
            ((GolemEquipTrigger)((Object)GolemTriggers.EQUIP.get())).trigger((ServerPlayer)player, count);
            return InteractionResult.CONSUME;
        }
        return InteractionResult.FAIL;
    }

    protected void hurtArmor(DamageSource source, float damage) {
        if (damage <= 0.0f) {
            return;
        }
        if ((damage /= 4.0f) < 1.0f) {
            damage = 1.0f;
        }
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            if (slot.getType() != EquipmentSlot.Type.HUMANOID_ARMOR) continue;
            ItemStack itemstack = this.getItemBySlot(slot);
            if (source.is(DamageTypeTags.IS_FIRE) && itemstack.getItem().canBeHurtBy(itemstack, source) || !(itemstack.getItem() instanceof ArmorItem)) continue;
            itemstack.hurtAndBreak((int)damage, (LivingEntity)this, slot);
        }
    }

    @Nullable
    public InteractionHand shieldSlot() {
        return this.getItemBySlot(EquipmentSlot.MAINHAND).canPerformAction(ItemAbilities.SHIELD_BLOCK) ? InteractionHand.MAIN_HAND : (this.getItemBySlot(EquipmentSlot.OFFHAND).canPerformAction(ItemAbilities.SHIELD_BLOCK) ? InteractionHand.OFF_HAND : null);
    }

    protected void hurtCurrentlyUsedShield(float damage) {
        InteractionHand hand = this.shieldSlot();
        if (hand == null) {
            return;
        }
        ItemStack stack = this.getItemInHand(hand);
        int i = damage < 3.0f ? 0 : 1 + Mth.floor((float)damage);
        GolemDamageShieldEvent event = new GolemDamageShieldEvent(this, stack, hand, damage, i);
        NeoForge.EVENT_BUS.post((Event)event);
        i = event.getCost();
        if (i > 0) {
            stack.hurtAndBreak(i, (LivingEntity)this, LivingEntity.getSlotForHand((InteractionHand)hand));
        }
        if (stack.isEmpty()) {
            this.setItemInHand(hand, ItemStack.EMPTY);
            this.playSound(SoundEvents.SHIELD_BREAK, 0.8f, 0.8f + this.level().random.nextFloat() * 0.4f);
        } else {
            this.playSound(SoundEvents.SHIELD_BLOCK, 0.8f, 0.8f + this.level().random.nextFloat() * 0.4f);
        }
    }

    protected void blockUsingShield(LivingEntity source) {
        super.blockUsingShield(source);
        InteractionHand hand = this.shieldSlot();
        if (hand == null) {
            return;
        }
        ItemStack stack = this.getItemInHand(hand);
        boolean canDisable = source.canDisableShield() || source.getMainHandItem().canDisableShield(stack, (LivingEntity)this, source);
        int cd = 100;
        if (source.getType().is(MGTagGen.SHIELD_BREAKER)) {
            canDisable = true;
            cd *= 2;
        }
        GolemDisableShieldEvent event = new GolemDisableShieldEvent(this, stack, hand, source, canDisable);
        NeoForge.EVENT_BUS.post((Event)event);
        if (event.shouldDisable()) {
            this.shieldCooldown = cd;
            this.level().broadcastEntityEvent((Entity)this, (byte)30);
        }
    }

    @Override
    public void handleEntityEvent(byte event) {
        if (event == 30) {
            this.shieldCooldown = 100;
        }
        super.handleEntityEvent(event);
    }

    @Override
    public void tick() {
        super.tick();
        this.shieldCooldown = Mth.clamp((int)(this.shieldCooldown - 1), (int)0, (int)100);
    }

    @Override
    protected ItemWrapper getAltWeaponHand() {
        return !this.backupHand.isEmpty() ? this.getBackupHand() : this.getWrapperOfHand(EquipmentSlot.OFFHAND);
    }

    public ItemWrapper getBackupHand() {
        return ItemWrapper.simple(() -> this.backupHand, e -> {
            this.backupHand = e;
        });
    }

    public ItemWrapper getArrowSlot() {
        return ItemWrapper.simple(() -> this.arrowSlot, e -> {
            this.arrowSlot = e;
        });
    }

    @Override
    public void checkRide(LivingEntity target) {
        if (target instanceof DogGolemEntity || target instanceof AbstractHorse) {
            this.startRiding((Entity)target);
        }
    }

    @Override
    protected void dropCustomDeathLoot(ServerLevel level, DamageSource source, boolean player) {
        super.dropCustomDeathLoot(level, source, player);
        if (!this.arrowSlot.isEmpty()) {
            this.spawnAtLocation(this.arrowSlot);
        }
        if (!this.backupHand.isEmpty()) {
            this.spawnAtLocation(this.backupHand);
        }
    }
}

