/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.content.entity.goals;

import dev.xkmc.modulargolems.content.entity.common.AbstractGolemEntity;
import dev.xkmc.modulargolems.content.entity.common.GolemFlags;
import dev.xkmc.modulargolems.init.data.MGConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import net.minecraft.world.phys.Vec3;

public class TeleportToOwnerGoal
extends Goal {
    private final AbstractGolemEntity<?, ?> golem;
    private final LevelReader level;
    private final PathNavigation navigation;
    private final boolean canFly;

    public TeleportToOwnerGoal(AbstractGolemEntity<?, ?> golem) {
        this(golem, false);
    }

    private TeleportToOwnerGoal(AbstractGolemEntity<?, ?> golem, boolean fly) {
        this.golem = golem;
        this.level = golem.level();
        this.navigation = golem.getNavigation();
        this.canFly = fly;
    }

    public boolean canUse() {
        if (this.golem.isInSittingPose() || !this.golem.getMode().isMovable()) {
            return false;
        }
        if (this.golem.isLeashed()) {
            return false;
        }
        if (this.golem.getControllingPassenger() instanceof Player) {
            return false;
        }
        Vec3 target = this.golem.getTargetPos();
        double maxDist = (Double)MGConfig.COMMON.maxWanderRadius.get();
        return this.golem.distanceToSqr(target) >= maxDist * maxDist;
    }

    public boolean canContinueToUse() {
        return false;
    }

    public void start() {
        this.teleportToOwner();
    }

    public void stop() {
        this.navigation.stop();
    }

    private void teleportToOwner() {
        BlockPos blockpos = BlockPos.containing((Position)this.golem.getTargetPos());
        for (int i = 0; i < 10; ++i) {
            int j = this.randomIntInclusive(-3, 3);
            int k = this.randomIntInclusive(-1, 1);
            int l = this.randomIntInclusive(-3, 3);
            boolean flag = this.maybeTeleportTo(blockpos.getX() + j, blockpos.getY() + k, blockpos.getZ() + l);
            if (!flag) continue;
            this.golem.setTarget(null);
            return;
        }
    }

    private boolean maybeTeleportTo(int pX, int pY, int pZ) {
        Entity entity;
        Vec3 target = this.golem.getTargetPos();
        if (Math.abs((double)pX - target.x()) < 2.0 && Math.abs((double)pZ - target.z()) < 2.0) {
            return false;
        }
        if (!this.canTeleportTo(new BlockPos(pX, pY, pZ))) {
            return false;
        }
        LivingEntity e = this.golem;
        while ((entity = e.getControlledVehicle()) instanceof LivingEntity) {
            LivingEntity le;
            e = le = (LivingEntity)entity;
        }
        e.moveTo((double)pX + 0.5, (double)pY, (double)pZ + 0.5, this.golem.getYRot(), this.golem.getXRot());
        this.navigation.stop();
        return true;
    }

    private boolean canTeleportTo(BlockPos pPos) {
        boolean allow;
        PathType blockpathtypes = WalkNodeEvaluator.getPathTypeStatic(this.golem, (BlockPos)pPos.mutable());
        boolean bl = allow = blockpathtypes == PathType.WALKABLE;
        if (this.golem.hasFlag(GolemFlags.FLOAT) || this.golem.hasFlag(GolemFlags.SWIM)) {
            allow |= blockpathtypes == PathType.WATER;
            allow |= blockpathtypes == PathType.WATER_BORDER;
        }
        if (!allow) {
            return false;
        }
        BlockState blockstate = this.level.getBlockState(pPos.below());
        if (!this.canFly && blockstate.getBlock() instanceof LeavesBlock) {
            return false;
        }
        BlockPos blockpos = pPos.subtract((Vec3i)this.golem.blockPosition());
        return this.level.noCollision(this.golem, this.golem.getBoundingBox().move(blockpos));
    }

    private int randomIntInclusive(int pMin, int pMax) {
        return this.golem.getRandom().nextInt(pMax - pMin + 1) + pMin;
    }
}

