/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.content.entity.goals;

import dev.xkmc.modulargolems.content.entity.common.AbstractGolemEntity;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;

public class GolemSwimMoveControl
extends MoveControl {
    private final AbstractGolemEntity<?, ?> golem;

    public GolemSwimMoveControl(AbstractGolemEntity<?, ?> pDrowned) {
        super(pDrowned);
        this.golem = pDrowned;
    }

    public void tick() {
        LivingEntity livingentity = this.golem.getTarget();
        if (this.golem.isInWater()) {
            if (livingentity != null && livingentity.getY() > this.golem.getY()) {
                this.golem.setDeltaMovement(this.golem.getDeltaMovement().add(0.0, 0.002, 0.0));
            }
            if (this.operation != MoveControl.Operation.MOVE_TO || this.golem.getNavigation().isDone()) {
                this.golem.setSpeed(0.0f);
                return;
            }
            double d0 = this.wantedX - this.golem.getX();
            double d1 = this.wantedY - this.golem.getY();
            double d2 = this.wantedZ - this.golem.getZ();
            double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
            d1 /= d3;
            float f = (float)(Mth.atan2((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
            this.golem.setYRot(this.rotlerp(this.golem.getYRot(), f, 90.0f));
            this.golem.yBodyRot = this.golem.getYRot();
            float f1 = (float)(this.speedModifier * this.golem.getAttributeValue(Attributes.MOVEMENT_SPEED));
            float f2 = Mth.lerp((float)0.125f, (float)this.golem.getSpeed(), (float)f1);
            this.golem.setSpeed(f2);
            this.golem.setDeltaMovement(this.golem.getDeltaMovement().add((double)f2 * d0 * 0.005, (double)f2 * d1 * 0.1, (double)f2 * d2 * 0.005));
        } else {
            if (!this.golem.onGround()) {
                this.golem.setDeltaMovement(this.golem.getDeltaMovement().add(0.0, -0.008, 0.0));
            }
            super.tick();
        }
    }
}

