/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.content.entity.goals;

import dev.xkmc.modulargolems.content.entity.common.AbstractGolemEntity;
import dev.xkmc.modulargolems.content.entity.common.GolemFlags;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.phys.Vec3;

public class GolemRandomStrollGoal
extends RandomStrollGoal {
    private final AbstractGolemEntity<?, ?> golem;

    public GolemRandomStrollGoal(AbstractGolemEntity<?, ?> golem) {
        super(golem, 0.7, 60);
        this.golem = golem;
    }

    public boolean canUse() {
        return this.golem.getMode().couldRandomStroll() && super.canUse();
    }

    public boolean canContinueToUse() {
        return this.golem.getMode().couldRandomStroll() && super.canContinueToUse();
    }

    protected Vec3 getPosition() {
        if (this.mob.isInWaterOrBubble()) {
            if (this.golem.hasFlag(GolemFlags.SWIM)) {
                return BehaviorUtils.getRandomSwimmablePos((PathfinderMob)this.mob, (int)10, (int)7);
            }
            Vec3 vec3 = LandRandomPos.getPos((PathfinderMob)this.mob, (int)15, (int)7);
            return vec3 == null ? super.getPosition() : vec3;
        }
        return LandRandomPos.getPos((PathfinderMob)this.mob, (int)10, (int)7);
    }
}

