/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.content.entity.goals;

import dev.xkmc.mob_weapon_api.api.goals.IMeleeGoal;
import dev.xkmc.modulargolems.content.entity.common.AbstractGolemEntity;
import dev.xkmc.modulargolems.content.entity.common.GolemFlags;
import dev.xkmc.modulargolems.content.modifier.special.EarthquakeHelper;
import dev.xkmc.modulargolems.init.data.MGConfig;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class GolemMeleeGoal
extends MeleeAttackGoal
implements IMeleeGoal {
    private final AbstractGolemEntity<?, ?> golem;
    private double lastDist;
    private double timeNoMovement;
    private boolean earthQuake = false;
    private boolean hammerJump = false;

    private static double getDistance(double a0, double a1, double b0, double b1) {
        if (a1 < b0) {
            return b0 - a1;
        }
        if (b1 < a0) {
            return a0 - b1;
        }
        return 0.0;
    }

    public static double calculateDistSqr(AbstractGolemEntity<?, ?> golem, LivingEntity target) {
        AABB aabb0 = golem.getBoundingBox();
        AABB aabb1 = target.getBoundingBox();
        double x = GolemMeleeGoal.getDistance(aabb0.minX, aabb0.maxX, aabb1.minX, aabb1.maxX);
        double y = GolemMeleeGoal.getDistance(aabb0.minY, aabb0.maxY, aabb1.minY, aabb1.maxY);
        double z = GolemMeleeGoal.getDistance(aabb0.minZ, aabb0.maxZ, aabb1.minZ, aabb1.maxZ);
        return x * x + y * y + z * z;
    }

    public static int getTargetResetTime() {
        return (Integer)MGConfig.COMMON.targetResetTime.get();
    }

    public static double getTargetDistanceDelta() {
        return (Double)MGConfig.COMMON.targetResetNoMovementRange.get();
    }

    public GolemMeleeGoal(AbstractGolemEntity<?, ?> entity) {
        super(entity, 1.0, true);
        this.golem = entity;
    }

    protected int adjustedTickDelay(int tick) {
        double speed = this.mob.getAttributeValue(Attributes.ATTACK_SPEED);
        return (int)Math.ceil((double)super.adjustedTickDelay(tick) / Math.min(1.0, speed));
    }

    public int getMeleeInterval() {
        return this.adjustedTickDelay(20);
    }

    public double getAttackReachSqr(LivingEntity pAttackTarget) {
        double val = this.mob.getAttributeValue(Attributes.ENTITY_INTERACTION_RANGE);
        return val * val;
    }

    public boolean canReachTarget(LivingEntity le) {
        return this.getAttackReachSqr(le) >= this.golem.getPerceivedTargetDistanceSquareForMeleeAttack(le);
    }

    public boolean canReachTarget(LivingEntity le, double distSqr) {
        return this.getAttackReachSqr(le) >= distSqr;
    }

    public void tick() {
        if (this.isTimeToAttack() && this.golem.getTarget() != null) {
            this.timeNoMovement += 1.0;
        }
        super.tick();
        if (this.hammerJump) {
            if (this.golem.onGround()) {
                this.hammerJump = false;
            } else {
                LivingEntity target = this.golem.getTarget();
                if (target != null) {
                    Vec3 v = this.golem.getDeltaMovement();
                    Vec3 diff = target.position().subtract(this.golem.position()).multiply(1.0, 0.0, 1.0);
                    if (v.multiply(1.0, 0.0, 1.0).length() < 0.3 && diff.length() > 1.0) {
                        this.golem.addDeltaMovement(diff.normalize().scale(0.01));
                    }
                }
            }
        }
    }

    protected void checkAndPerformAttack(LivingEntity target) {
        double distSqr = this.golem.getPerceivedTargetDistanceSquareForMeleeAttack(target);
        if (!this.isTimeToAttack()) {
            this.lastDist = 1000.0;
            this.timeNoMovement = 0.0;
        } else {
            double dist = Math.sqrt(distSqr);
            if (dist < this.lastDist - GolemMeleeGoal.getTargetDistanceDelta()) {
                this.lastDist = dist;
                this.timeNoMovement = 0.0;
            }
            this.doRealAttack(target, distSqr);
            if (this.timeNoMovement > (double)GolemMeleeGoal.getTargetResetTime()) {
                this.golem.resetTarget(null);
                this.lastDist = 1000.0;
                this.timeNoMovement = 0.0;
            }
        }
    }

    protected void doRealAttack(LivingEntity target, double distSqr) {
        if (this.golem.hasFlag(GolemFlags.EARTH_QUAKE) && !this.golem.isInWater() && this.golem.onGround()) {
            if (this.earthQuake) {
                this.earthQuake = false;
                this.resetAttackCooldown();
                EarthquakeHelper.performEarthQuake(this.golem);
                return;
            }
            double d0 = this.getAttackReachSqr(target);
            if (d0 < distSqr && distSqr <= d0 + EarthquakeHelper.getExtraRange(this.golem, target)) {
                this.golem.addDeltaMovement(new Vec3(0.0, 1.0, 0.0));
                this.golem.hasImpulse = true;
                this.earthQuake = true;
                return;
            }
        }
        if (this.earthQuake && !this.golem.onGround()) {
            return;
        }
        if (this.mob.hasLineOfSight((Entity)target)) {
            boolean jump;
            if (this.canReachTarget(target, distSqr)) {
                this.resetAttackCooldown();
                this.mob.swing(InteractionHand.MAIN_HAND);
                this.mob.doHurtTarget((Entity)target);
                if (this.golem.getDeltaMovement().length() > 2.0) {
                    this.golem.setDeltaMovement(this.golem.getDeltaMovement().normalize().scale(2.0));
                }
                jump = this.golem.getMainHandItem().is(ItemTags.MACE_ENCHANTABLE);
            } else {
                Vec3 diff = target.position().subtract(this.golem.position());
                boolean bl = jump = diff.horizontalDistanceSqr() < this.getAttackReachSqr(target) / 2.0 && diff.y > 0.0 && diff.y < (double)(3.0f + this.golem.getBbHeight());
            }
            if (!this.golem.hasFlag(GolemFlags.EARTH_QUAKE) && jump && !this.golem.isInWater() && this.golem.onGround()) {
                this.hammerJump = true;
                Vec3 v = this.golem.getDeltaMovement();
                this.golem.setDeltaMovement(new Vec3(v.x, Math.max(v.y, 0.0) + 1.0, v.z));
                this.golem.hasImpulse = true;
            }
        }
    }
}

