/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.content.entity.goals;

import dev.xkmc.modulargolems.content.entity.common.AbstractGolemEntity;
import dev.xkmc.modulargolems.content.entity.common.GolemFlags;
import dev.xkmc.modulargolems.init.registrate.GolemModifiers;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.FloatGoal;

public class GolemFloatGoal
extends FloatGoal {
    private final AbstractGolemEntity<?, ?> golem;

    public GolemFloatGoal(AbstractGolemEntity<?, ?> golem) {
        super(golem);
        this.golem = golem;
    }

    public boolean canUse() {
        boolean canSwim = this.golem.getModifiers().getOrDefault(GolemModifiers.SWIM.get(), 0) > 0;
        boolean canFloat = this.golem.getModifiers().getOrDefault(GolemModifiers.FLOAT.get(), 0) > 0;
        boolean fireImmune = this.golem.hasFlag(GolemFlags.FIRE_IMMUNE);
        if (this.golem.isInWater() && canSwim) {
            LivingEntity target = this.golem.getTarget();
            if (target != null && target.isInWater()) {
                return false;
            }
            if (target == null && this.golem.getOwner() != null && this.golem.getOwner().getY() < this.golem.getY() + 2.0) {
                return false;
            }
            if (this.golem.getDeltaMovement().y() > 0.01) {
                return false;
            }
        }
        return (canSwim || canFloat || this.golem.isInLava() && fireImmune) && super.canUse();
    }
}

