/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.content.entity.goals;

import dev.xkmc.modulargolems.content.entity.common.AbstractGolemEntity;
import java.util.EnumSet;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3;

public class FollowOwnerGoal
extends Goal {
    private final AbstractGolemEntity<?, ?> golem;
    private final double speedModifier;
    private int timeToRecalcPath;
    private float oldWaterCost;

    public FollowOwnerGoal(AbstractGolemEntity<?, ?> golem) {
        this(golem, 1.0);
    }

    private FollowOwnerGoal(AbstractGolemEntity<?, ?> golem, double speed) {
        this.golem = golem;
        this.speedModifier = speed;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        if (this.golem.isInSittingPose() || !this.golem.getMode().isMovable()) {
            return false;
        }
        if (this.golem.getControllingPassenger() instanceof Player) {
            return false;
        }
        Vec3 target = this.golem.getTargetPos();
        double startDistance = this.golem.getMode().getStartFollowDistance(this.golem);
        return this.golem.distanceToSqr(target) > startDistance * startDistance;
    }

    public boolean canContinueToUse() {
        if (this.golem.getNavigation().isDone()) {
            this.golem.getMode().tick(this.golem);
            if (this.golem.getNavigation().isDone()) {
                return false;
            }
        }
        if (this.golem.isInSittingPose() || !this.golem.getMode().isMovable()) {
            return false;
        }
        Vec3 target = this.golem.getTargetPos();
        double stop = this.golem.getMode().getStopDistance();
        return !(this.golem.distanceToSqr(target) <= stop * stop);
    }

    public void start() {
        this.timeToRecalcPath = 0;
        this.oldWaterCost = this.golem.getPathfindingMalus(PathType.WATER);
        this.golem.setPathfindingMalus(PathType.WATER, 0.0f);
    }

    public void stop() {
        this.golem.getNavigation().stop();
        this.golem.setPathfindingMalus(PathType.WATER, this.oldWaterCost);
    }

    public void tick() {
        Vec3 target = this.golem.getTargetPos();
        Player owner = this.golem.getOwner();
        if (owner != null) {
            this.golem.getLookControl().setLookAt((Entity)owner, 10.0f, (float)this.golem.getMaxHeadXRot());
        }
        if (--this.timeToRecalcPath <= 0) {
            this.timeToRecalcPath = this.adjustedTickDelay(10);
            if (!this.golem.isLeashed()) {
                this.golem.getNavigation().moveTo(target.x(), target.y(), target.z(), this.speedModifier);
                return;
            }
        }
        this.golem.getMode().tick(this.golem);
    }
}

