/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.content.entity.dog;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import dev.xkmc.modulargolems.content.client.armor.GolemEquipmentModels;
import dev.xkmc.modulargolems.content.entity.common.AbstractGolemRenderer;
import dev.xkmc.modulargolems.content.entity.common.GolemBannerLayer;
import dev.xkmc.modulargolems.content.entity.dog.DogArmorLayer;
import dev.xkmc.modulargolems.content.entity.dog.DogGolemEntity;
import dev.xkmc.modulargolems.content.entity.dog.DogGolemModel;
import dev.xkmc.modulargolems.content.entity.dog.DogGolemPartType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.world.item.ItemDisplayContext;
import org.jetbrains.annotations.Nullable;

public class DogGolemRenderer
extends AbstractGolemRenderer<DogGolemEntity, DogGolemPartType, DogGolemModel> {
    protected static void transform(PoseStack stack, ItemDisplayContext transform, @Nullable DogGolemPartType part) {
        float size;
        switch (transform) {
            case GUI: 
            case FIRST_PERSON_LEFT_HAND: 
            case FIRST_PERSON_RIGHT_HAND: {
                break;
            }
            case THIRD_PERSON_LEFT_HAND: 
            case THIRD_PERSON_RIGHT_HAND: {
                stack.translate(0.25, 0.4, 0.5);
                size = 0.5f;
                stack.scale(size, size, size);
                break;
            }
            case GROUND: {
                stack.translate(0.25, 0.0, 0.5);
                size = 0.5f;
                stack.scale(size, size, size);
                break;
            }
            case NONE: 
            case HEAD: 
            case FIXED: {
                stack.translate(0.5, 0.5, 0.5);
                float size2 = 1.0f;
                stack.scale(size2, -size2, size2);
                stack.translate(0.0, -0.5, 0.0);
                return;
            }
            default: {
                stack.translate(0.1, 0.0, 0.5);
                size = 0.75f;
                stack.scale(size, size, size);
            }
        }
        stack.mulPose(Axis.ZP.rotationDegrees(135.0f));
        stack.mulPose(Axis.YP.rotationDegrees(-155.0f));
        if (part == null) {
            size = 0.8f;
            stack.scale(size, size, size);
            stack.translate(0.0, -1.9, 0.0);
        } else if (part == DogGolemPartType.BODY) {
            size = 0.9f;
            stack.scale(size, size, size);
            stack.translate(0.0, -1.6, 0.0);
        } else if (part == DogGolemPartType.LEGS) {
            size = 1.0f;
            stack.scale(size, size, size);
            stack.translate(0.0, -1.9, 0.0);
        }
    }

    public DogGolemRenderer(EntityRendererProvider.Context ctx) {
        super(ctx, new DogGolemModel(ctx.bakeLayer(GolemEquipmentModels.DOGGOLEM)), 1.0f, DogGolemPartType::values);
        this.addLayer(new DogArmorLayer((RenderLayerParent<DogGolemEntity, DogGolemModel>)this, ctx.getModelSet()));
        this.addLayer(new GolemBannerLayer(this, ctx.getItemInHandRenderer()));
    }

    protected float getBob(DogGolemEntity dog, float pPartialTicks) {
        return dog.getTailAngle();
    }
}

