/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.content.entity.dog;

import dev.xkmc.l2serial.serialization.marker.SerialClass;
import dev.xkmc.modulargolems.content.entity.common.AbstractGolemEntity;
import dev.xkmc.modulargolems.content.entity.dog.DogGolemPartType;
import dev.xkmc.modulargolems.content.entity.goals.GolemMeleeGoal;
import dev.xkmc.modulargolems.init.data.MGConfig;
import dev.xkmc.modulargolems.init.data.MGTagGen;
import dev.xkmc.modulargolems.init.registrate.GolemTypes;
import dev.xkmc.more_wolf_armors.content.WolfArmorItem;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Crackiness;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AnimalArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.common.CommonHooks;
import org.jetbrains.annotations.Nullable;

@SerialClass
public class DogGolemEntity
extends AbstractGolemEntity<DogGolemEntity, DogGolemPartType> {
    protected static final EntityDataAccessor<Byte> DATA_FLAGS_ID = SynchedEntityData.defineId(DogGolemEntity.class, (EntityDataSerializer)EntityDataSerializers.BYTE);

    public float getJumpStrength() {
        float ans = (float)this.getAttributeValue(GolemTypes.GOLEM_JUMP.holder());
        ans *= this.getScale();
        MobEffectInstance ins = this.getEffect(MobEffects.JUMP);
        if (ins != null) {
            int lv = ins.getAmplifier() + 1;
            ans *= 1.0f + (float)lv * 0.625f;
        }
        return ans;
    }

    public DogGolemEntity(EntityType<DogGolemEntity> type, Level level) {
        super(type, level);
    }

    public float getTailAngle() {
        if (this.isAngry()) {
            return 1.5393804f;
        }
        float percentage = 1.0f - this.getHealth() / this.getMaxHealth();
        return (0.55f - percentage * 0.16f) * (float)Math.PI;
    }

    protected void tickRidden(Player player, Vec3 vec3) {
        super.tickRidden(player, vec3);
        Vec2 vec2 = this.getRiddenRotation((LivingEntity)player);
        this.setRot(vec2.y, vec2.x);
        this.yBodyRot = this.yHeadRot = this.getYRot();
        this.yRotO = this.yHeadRot;
        if (this.isControlledByLocalInstance() && (this.onGround() || this.isInWaterOrBubble()) && player.jumping) {
            this.executeRidersJump(vec3);
        }
    }

    protected Vec2 getRiddenRotation(LivingEntity rider) {
        return new Vec2(rider.getXRot() * 0.5f, rider.getYRot());
    }

    protected Vec3 getRiddenInput(Player player, Vec3 input) {
        float f = player.xxa * 0.5f;
        float f1 = player.zza;
        if (f1 <= 0.0f) {
            f1 *= 0.25f;
        }
        Vec3 ans = new Vec3((double)f, 0.0, (double)f1);
        if (player.isShiftKeyDown()) {
            ans = ans.add(0.0, -1.0, 0.0);
        }
        return ans;
    }

    public LivingEntity getControllingPassenger() {
        Entity entity = this.getFirstPassenger();
        if (entity instanceof Player) {
            Player pl = (Player)entity;
            return pl;
        }
        if (entity instanceof AbstractGolemEntity) {
            AbstractGolemEntity pl = (AbstractGolemEntity)entity;
            return pl;
        }
        return null;
    }

    protected float getRiddenSpeed(Player rider) {
        return (float)(this.getAttributeValue(Attributes.MOVEMENT_SPEED) * (Double)MGConfig.COMMON.riddenSpeedFactor.get());
    }

    protected void executeRidersJump(Vec3 action) {
        Vec3 vec3 = this.getDeltaMovement();
        float jump = this.getJumpStrength();
        this.setDeltaMovement(vec3.x, jump, vec3.z);
        this.hasImpulse = true;
        CommonHooks.onLivingJump((LivingEntity)this);
        if (action.z > 0.0) {
            float x0 = Mth.sin((float)(this.getYRot() * ((float)Math.PI / 180)));
            float z0 = Mth.cos((float)(this.getYRot() * ((float)Math.PI / 180)));
            this.setDeltaMovement(this.getDeltaMovement().add((double)(-0.4f * x0 * jump), 0.0, (double)(0.4f * z0 * jump)));
        }
    }

    protected void positionRider(Entity rider, Entity.MoveFunction setPos) {
        int index = this.getPassengers().indexOf(rider);
        int total = this.getPassengers().size();
        if (index < 0) {
            return;
        }
        float width = this.getBbWidth();
        float offset = index == 0 ? 0.7f : (float)index + (this.getControllingPassenger() instanceof Player ? 1.7f : 1.2f);
        float pos = width / 2.0f - width / (float)total * offset;
        Vec3 off = new Vec3(0.0, 0.0, (double)pos).yRot(-this.yBodyRot * ((float)Math.PI / 180));
        Vec3 vec3 = this.getPassengerRidingPosition(rider).add(off);
        Vec3 vec31 = rider.getVehicleAttachmentPoint((Entity)this);
        setPos.accept(rider, vec3.x - vec31.x, vec3.y - vec31.y, vec3.z - vec31.z);
        if (index > 0) {
            this.clampRotation(rider);
        }
    }

    public void onPassengerTurned(Entity rider) {
        if (this.getControllingPassenger() != rider) {
            this.clampRotation(rider);
        }
    }

    private void clampRotation(Entity rider) {
        rider.setYBodyRot(this.getYRot());
        float yr0 = rider.getYRot();
        float dyr = Mth.wrapDegrees((float)(yr0 - this.getYRot()));
        float yr1 = Mth.clamp((float)dyr, (float)-160.0f, (float)160.0f);
        rider.yRotO += yr1 - dyr;
        float yr2 = yr0 + yr1 - dyr;
        rider.setYRot(yr2);
        rider.setYHeadRot(yr2);
    }

    protected boolean canAddPassenger(Entity entity) {
        float total = 0.0f;
        int count = 0;
        ArrayList<Entity> list = new ArrayList<Entity>(this.getPassengers());
        list.add(entity);
        for (Entity e : list) {
            ++count;
            total += e.getBbWidth();
        }
        double size = this.getAttributeValue((Holder)GolemTypes.GOLEM_SIZE);
        return (double)count <= Math.min(size * 2.0 - 1.0, 3.0) && (double)total <= (double)this.getBbWidth() + 0.001;
    }

    protected void addPassenger(Entity rider) {
        this.setInSittingPose(false);
        super.addPassenger(rider);
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_FLAGS_ID, (Object)0);
    }

    @Override
    public void addAdditionalSaveData(CompoundTag p_21819_) {
        super.addAdditionalSaveData(p_21819_);
        p_21819_.putBoolean("Sitting", this.isInSittingPose());
    }

    @Override
    public void readAdditionalSaveData(CompoundTag p_21815_) {
        super.readAdditionalSaveData(p_21815_);
        this.setInSittingPose(p_21815_.getBoolean("Sitting"));
    }

    @Override
    public boolean isInSittingPose() {
        return ((Byte)this.entityData.get(DATA_FLAGS_ID) & 1) != 0;
    }

    public void setInSittingPose(boolean sit) {
        byte b0 = (Byte)this.entityData.get(DATA_FLAGS_ID);
        this.getNavigation().stop();
        this.setTarget(null);
        if (sit) {
            this.entityData.set(DATA_FLAGS_ID, (Object)((byte)(b0 | 1)));
        } else {
            this.entityData.set(DATA_FLAGS_ID, (Object)((byte)(b0 & 0xFFFFFFFE)));
        }
    }

    @Override
    protected void registerGoals() {
        this.goalSelector.addGoal(2, (Goal)new GolemMeleeGoal(this));
        super.registerGoals();
    }

    @Override
    public boolean canAttackType(EntityType<?> type) {
        return super.canAttackType(type) && !this.isInSittingPose();
    }

    public boolean hurt(DamageSource source, float amount) {
        if (!this.level().isClientSide) {
            this.setInSittingPose(false);
        }
        return super.hurt(source, amount);
    }

    protected SoundEvent getHurtSound(DamageSource p_28872_) {
        return SoundEvents.WOLF_HURT;
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.WOLF_DEATH;
    }

    protected void playStepSound(BlockPos p_28864_, BlockState p_28865_) {
        this.playSound(SoundEvents.WOLF_STEP, 1.0f, 1.0f);
    }

    public Vec3 getLeashOffset() {
        return new Vec3(0.0, (double)(0.6f * this.getEyeHeight()), (double)(this.getBbWidth() * 0.4f));
    }

    @Override
    protected InteractionResult mobInteractImpl(Player player, InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        if (((Boolean)MGConfig.COMMON.strictInteract.get()).booleanValue() && !itemstack.isEmpty()) {
            return InteractionResult.PASS;
        }
        if (!player.isShiftKeyDown() && itemstack.isEmpty()) {
            return super.mobInteractImpl(player, hand);
        }
        if (!this.level().isClientSide()) {
            AnimalArmorItem ani;
            Item item;
            ItemStack armor = this.getBodyArmorItem();
            if (!armor.isEmpty() && (item = armor.getItem()) instanceof AnimalArmorItem && ((Ingredient)((ArmorMaterial)(ani = (AnimalArmorItem)item).getMaterial().value()).repairIngredient().get()).test(itemstack) && armor.isDamaged()) {
                itemstack.shrink(1);
                this.playSound(SoundEvents.WOLF_ARMOR_REPAIR);
                int i = (int)((float)armor.getMaxDamage() * 0.125f);
                armor.setDamageValue(Math.max(0, armor.getDamageValue() - i));
                return InteractionResult.SUCCESS;
            }
            if (this.canModify(player) && itemstack.is(MGTagGen.C_WOLF_ARMORS) && this.getItemBySlot(EquipmentSlot.BODY).isEmpty()) {
                if (!this.level().isClientSide()) {
                    this.setItemSlot(EquipmentSlot.BODY, itemstack.split(1));
                }
                return InteractionResult.CONSUME;
            }
            this.setInSittingPose(!this.isInSittingPose());
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    public void setTarget(@Nullable LivingEntity target) {
        if (target != null && this.isInSittingPose()) {
            return;
        }
        super.setTarget(target);
    }

    @Override
    protected void actuallyHurt(DamageSource source, float amount) {
        if (!this.canArmorAbsorb(source)) {
            super.actuallyHurt(source, amount);
        } else {
            ItemStack stack = this.getBodyArmorItem();
            int i = stack.getDamageValue();
            int j = stack.getMaxDamage();
            stack.hurtAndBreak(Mth.ceil((float)amount), (LivingEntity)this, EquipmentSlot.BODY);
            if (Crackiness.WOLF_ARMOR.byDamage(i, j) != Crackiness.WOLF_ARMOR.byDamage(this.getBodyArmorItem())) {
                this.playSound(SoundEvents.WOLF_ARMOR_CRACK);
                Level level = this.level();
                if (level instanceof ServerLevel) {
                    Item item;
                    ServerLevel serverlevel = (ServerLevel)level;
                    ItemStack item2 = Items.ARMADILLO_SCUTE.getDefaultInstance();
                    if (ModList.get().isLoaded("more_wolf_armors") && (item = stack.getItem()) instanceof WolfArmorItem) {
                        WolfArmorItem armor = (WolfArmorItem)item;
                        item2 = armor.getBreakParticleItem(stack);
                    }
                    serverlevel.sendParticles((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, item2), this.getX(), this.getY() + 1.0, this.getZ(), 20, 0.2, 0.1, 0.2, 0.1);
                }
            }
        }
    }

    private boolean canArmorAbsorb(DamageSource source) {
        if (source.is(DamageTypeTags.BYPASSES_WOLF_ARMOR) || source.is(DamageTypeTags.BYPASSES_ARMOR)) {
            return false;
        }
        return this.hasArmor();
    }

    protected void hurtArmor(DamageSource source, float amount) {
        this.doHurtEquipment(source, amount, new EquipmentSlot[]{EquipmentSlot.BODY});
    }

    public boolean hasArmor() {
        return this.getBodyArmorItem().is(MGTagGen.C_WOLF_ARMORS);
    }

    @Override
    public boolean isInRangedMode() {
        return super.isInRangedMode() || this.isInSittingPose();
    }
}

