/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.content.entity.common;

import dev.xkmc.l2serial.serialization.marker.SerialClass;
import dev.xkmc.mob_weapon_api.api.ai.ISmartUser;
import dev.xkmc.mob_weapon_api.api.ai.IWeaponHolder;
import dev.xkmc.mob_weapon_api.api.ai.ItemWrapper;
import dev.xkmc.modulargolems.content.core.IGolemPart;
import dev.xkmc.modulargolems.content.entity.common.AbstractGolemEntity;
import dev.xkmc.modulargolems.content.entity.humanoid.weapon.GolemUser;
import dev.xkmc.modulargolems.content.entity.humanoid.weapon.GolemWeaponManager;
import dev.xkmc.modulargolems.content.entity.humanoid.weapon.GolemWeaponRegistry;
import dev.xkmc.modulargolems.init.registrate.GolemTypes;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;

@SerialClass
public abstract class SweepGolemEntity<T extends SweepGolemEntity<T, P>, P extends IGolemPart<P>>
extends AbstractGolemEntity<T, P>
implements RangedAttackMob,
IWeaponHolder {
    private final GolemWeaponManager<T> weaponManager;
    private boolean doReassessGoal = false;

    protected SweepGolemEntity(GolemWeaponRegistry<T> reg, EntityType<T> type, Level level) {
        super(type, level);
        this.weaponManager = new GolemWeaponManager<SweepGolemEntity>(reg, (SweepGolemEntity)((Object)this.getThis()));
        if (!this.level().isClientSide) {
            this.weaponManager.reassessWeaponGoal();
        }
    }

    protected boolean performRangedDamage(Entity target, float damage, double kb) {
        boolean flag = this.performDamageTarget(target, damage, kb);
        double range = this.getAttributeValue(GolemTypes.GOLEM_SWEEP.holder());
        if (range > 0.0 && this.canSweep()) {
            List list = this.level().getEntities(target, this.getAttackBoundingBox(target, range), e -> {
                LivingEntity le;
                return e instanceof LivingEntity && this.predicateTarget(le = (LivingEntity)e) && this.canAttack(le);
            });
            for (Entity t : list) {
                flag |= this.performDamageTarget(t, damage, kb);
            }
        }
        return flag;
    }

    protected boolean canSweep() {
        return true;
    }

    protected AABB getAttackBoundingBox(Entity target, double range) {
        return target.getBoundingBox().inflate(range);
    }

    protected abstract boolean performDamageTarget(Entity var1, float var2, double var3);

    @Override
    public void readAdditionalSaveData(CompoundTag pCompound) {
        super.readAdditionalSaveData(pCompound);
        this.weaponManager.reassessWeaponGoal();
    }

    public void setItemSlot(EquipmentSlot pSlot, ItemStack pStack) {
        super.setItemSlot(pSlot, pStack);
        if (!this.level().isClientSide) {
            this.doReassessGoal = true;
        }
    }

    public InteractionHand getWeaponHand() {
        return InteractionHand.MAIN_HAND;
    }

    public boolean canFireProjectileWeapon(ProjectileWeaponItem pProjectileWeapon) {
        return true;
    }

    public void performRangedAttack(LivingEntity pTarget, float dist) {
        this.weaponManager.performRangedAttack(pTarget, dist);
    }

    @Override
    public void aiStep() {
        if (this.doReassessGoal || this.tickCount % 100 == 0) {
            this.weaponManager.reassessWeaponGoal();
            this.doReassessGoal = false;
        }
        super.aiStep();
        this.attackStep();
    }

    public void triggerReassess() {
        this.doReassessGoal = true;
    }

    public ISmartUser toUser() {
        return new GolemUser(this, this.getTarget());
    }

    public void attackStep() {
        if (this.level().isClientSide()) {
            return;
        }
        if (this.inventoryTick > 0) {
            return;
        }
        this.inventoryTick = 4;
        this.switchWeapon(this.getWrapperOfHand(EquipmentSlot.MAINHAND), this.getAltWeaponHand());
    }

    protected ItemWrapper getAltWeaponHand() {
        return this.getWrapperOfHand(EquipmentSlot.OFFHAND);
    }

    private void switchWeapon(ItemWrapper mainhand, ItemWrapper offhand) {
        LivingEntity target = this.getTarget();
        ItemStack main = mainhand.getItem();
        ItemStack off = offhand.getItem();
        if (this.weaponManager.checkSwitch(target, mainhand, offhand)) {
            mainhand.setItem(off);
            offhand.setItem(main);
            this.doReassessGoal = true;
            this.inventoryTick = 10;
        }
    }
}

