/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.content.entity.common;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.xkmc.modulargolems.content.capability.GolemConfigEntry;
import dev.xkmc.modulargolems.content.entity.common.AbstractGolemEntity;
import dev.xkmc.modulargolems.content.entity.common.IHeadedModel;
import dev.xkmc.modulargolems.content.entity.hostile.HostileFaction;
import dev.xkmc.modulargolems.content.entity.hostile.HostileGolemRegistry;
import dev.xkmc.modulargolems.content.entity.humanoid.HumanoidGolemEntity;
import dev.xkmc.modulargolems.content.entity.metalgolem.MetalGolemEntity;
import dev.xkmc.modulargolems.init.data.MGLangData;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.renderer.ItemInHandRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.BannerItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;

public class GolemBannerLayer<T extends AbstractGolemEntity<?, ?>, M extends EntityModel<T>>
extends RenderLayer<T, M> {
    private final float scaleX;
    private final float scaleY;
    private final float scaleZ;
    private final ItemInHandRenderer itemInHandRenderer;

    public GolemBannerLayer(RenderLayerParent<T, M> parent, ItemInHandRenderer iihr) {
        this(parent, 1.0f, 1.0f, 1.0f, iihr);
    }

    public GolemBannerLayer(RenderLayerParent<T, M> parent, float sx, float sy, float sz, ItemInHandRenderer iihr) {
        super(parent);
        this.scaleX = sx;
        this.scaleY = sy;
        this.scaleZ = sz;
        this.itemInHandRenderer = iihr;
    }

    public void render(PoseStack pose, MultiBufferSource buffer, int light, T entity, float f1, float f2, float f3, float f4, float f5, float f6) {
        Minecraft mc = Minecraft.getInstance();
        Entity cam = mc.getCameraEntity();
        if (cam != null && entity.isPassengerOfSameVehicle(cam)) {
            return;
        }
        ItemStack stack = this.getBanner(entity);
        if (!this.renders(stack)) {
            return;
        }
        pose.pushPose();
        pose.scale(this.scaleX, this.scaleY, this.scaleZ);
        ((HeadedModel)this.getParentModel()).getHead().translateAndRotate(pose);
        ((IHeadedModel)this.getParentModel()).translateToHead(pose);
        this.itemInHandRenderer.renderItem(entity, stack, ItemDisplayContext.HEAD, false, pose, buffer, light);
        pose.popPose();
    }

    public ItemStack getBanner(T entity) {
        ItemStack stack = entity.getItemBySlot(EquipmentSlot.HEAD);
        if (entity instanceof HumanoidGolemEntity && this.renders(stack)) {
            return ItemStack.EMPTY;
        }
        Optional<HostileFaction> selfFact = HostileGolemRegistry.tryGetFaction(entity);
        if (selfFact.isPresent()) {
            if (entity.hasPassenger(e -> e instanceof AbstractGolemEntity)) {
                return ItemStack.EMPTY;
            }
            return selfFact.get().getBanner((AbstractGolemEntity<?, ?>)((Object)entity), ((AbstractGolemEntity)((Object)entity)).getConfigColor());
        }
        if (entity instanceof MetalGolemEntity && !this.renders(stack)) {
            stack = entity.getItemBySlot(EquipmentSlot.FEET);
        }
        if (this.renders(stack)) {
            return stack;
        }
        GolemConfigEntry entry = ((AbstractGolemEntity)((Object)entity)).getConfigEntry((Component)MGLangData.LOADING.get(new Object[0]));
        if (entry != null) {
            boolean showFlag;
            entry.clientTick(entity.level(), false);
            UUID captainId = entry.squadConfig.getCaptainId();
            boolean bl = showFlag = captainId != null && entity.getUUID().equals(captainId);
            if (showFlag) {
                String color = DyeColor.values()[entry.getColor()].getName();
                Item item = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.withDefaultNamespace((String)(color + "_banner")));
                return item.getDefaultInstance();
            }
        }
        return ItemStack.EMPTY;
    }

    public boolean renders(ItemStack stack) {
        return stack.getItem() instanceof BannerItem;
    }
}

