/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.content.entity.common;

import dev.xkmc.l2core.base.entity.SyncedData;
import dev.xkmc.l2serial.network.SimplePacketBase;
import dev.xkmc.l2serial.serialization.codec.PacketCodec;
import dev.xkmc.l2serial.serialization.codec.TagCodec;
import dev.xkmc.l2serial.serialization.marker.SerialClass;
import dev.xkmc.l2serial.serialization.marker.SerialField;
import dev.xkmc.l2serial.util.Wrappers;
import dev.xkmc.mob_weapon_api.api.ai.ItemWrapper;
import dev.xkmc.modulargolems.content.capability.GolemConfigEntry;
import dev.xkmc.modulargolems.content.capability.GolemConfigStorage;
import dev.xkmc.modulargolems.content.capability.GolemTracker;
import dev.xkmc.modulargolems.content.capability.PathConfig;
import dev.xkmc.modulargolems.content.config.GolemMaterial;
import dev.xkmc.modulargolems.content.config.GolemMaterialConfig;
import dev.xkmc.modulargolems.content.core.GolemType;
import dev.xkmc.modulargolems.content.core.IGolemPart;
import dev.xkmc.modulargolems.content.entity.common.GolemFlags;
import dev.xkmc.modulargolems.content.entity.common.ReforgeUpdatePacket;
import dev.xkmc.modulargolems.content.entity.goals.FollowOwnerGoal;
import dev.xkmc.modulargolems.content.entity.goals.GolemFloatGoal;
import dev.xkmc.modulargolems.content.entity.goals.GolemMeleeGoal;
import dev.xkmc.modulargolems.content.entity.goals.GolemRandomStrollGoal;
import dev.xkmc.modulargolems.content.entity.goals.GolemSwimMoveControl;
import dev.xkmc.modulargolems.content.entity.goals.TeleportToOwnerGoal;
import dev.xkmc.modulargolems.content.entity.hostile.HostileFaction;
import dev.xkmc.modulargolems.content.entity.hostile.HostileGolemRegistry;
import dev.xkmc.modulargolems.content.entity.metalgolem.MetalGolemEntity;
import dev.xkmc.modulargolems.content.entity.mode.GolemMode;
import dev.xkmc.modulargolems.content.entity.mode.GolemModes;
import dev.xkmc.modulargolems.content.entity.targeting.Golem3DTargetGoal;
import dev.xkmc.modulargolems.content.entity.targeting.TargetManager;
import dev.xkmc.modulargolems.content.item.card.PathRecordCard;
import dev.xkmc.modulargolems.content.item.data.GolemUpgrade;
import dev.xkmc.modulargolems.content.item.equipments.CustomDropGolemWeapon;
import dev.xkmc.modulargolems.content.item.equipments.GolemEquipmentItem;
import dev.xkmc.modulargolems.content.item.equipments.TickEquipmentItem;
import dev.xkmc.modulargolems.content.item.golem.GolemHolder;
import dev.xkmc.modulargolems.content.modifier.base.GolemModifier;
import dev.xkmc.modulargolems.events.event.GolemToOwnerEvent;
import dev.xkmc.modulargolems.init.ModularGolems;
import dev.xkmc.modulargolems.init.advancement.GolemKillTrigger;
import dev.xkmc.modulargolems.init.advancement.GolemTriggers;
import dev.xkmc.modulargolems.init.data.MGConfig;
import dev.xkmc.modulargolems.init.data.MGLangData;
import dev.xkmc.modulargolems.init.data.MGTagGen;
import dev.xkmc.modulargolems.init.registrate.GolemTypes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Position;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.PowerableMob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.attributes.DefaultAttributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import net.minecraft.world.entity.ai.navigation.AmphibiousPathNavigation;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.AbstractGolem;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.portal.DimensionTransition;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.PlayerTeam;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.util.FakePlayer;
import net.neoforged.neoforge.entity.IEntityWithComplexSpawn;

@SerialClass
public class AbstractGolemEntity<T extends AbstractGolemEntity<T, P>, P extends IGolemPart<P>>
extends AbstractGolem
implements IEntityWithComplexSpawn,
NeutralMob,
OwnableEntity,
PowerableMob {
    private static final SyncedData GOLEM_DATA = new SyncedData(AbstractGolemEntity::defineId);
    private static final EntityDataAccessor<Optional<UUID>> OWNER_ID = GOLEM_DATA.define(SyncedData.UUID, Optional.empty(), null);
    @SerialField
    private ArrayList<GolemMaterial> materials = new ArrayList();
    @SerialField
    private GolemUpgrade upgrades = new GolemUpgrade(0, new ArrayList<Item>());
    @SerialField
    @Nullable
    private UUID owner;
    @SerialField
    @Nullable
    private UUID leader;
    @SerialField
    private HashMap<GolemModifier, Integer> modifiers = new LinkedHashMap<GolemModifier, Integer>();
    @SerialField
    private final HashSet<GolemFlags> golemFlags = new HashSet();
    @SerialField(toClient=false)
    private Vec3 recordedPosition = Vec3.ZERO;
    @SerialField(toClient=false)
    private BlockPos recordedGuardPos = BlockPos.ZERO;
    public int inventoryTick = 0;
    public int specialAttackCoolDown = 0;
    protected final PathNavigation waterNavigation;
    protected final GroundPathNavigation groundNavigation;
    public final Set<MobEffect> effectImmunity = new HashSet<MobEffect>();
    private double lastSize = 0.0;
    private boolean sizeDirty = false;
    public static final ResourceLocation REFORGE_ID = ModularGolems.loc("golem_reforge");
    private static final EntityDataAccessor<Integer> DATA_MODE = GOLEM_DATA.define(SyncedData.INT, (Object)0, "follow_mode");
    private static final EntityDataAccessor<BlockPos> GUARD_POS = GOLEM_DATA.define(SyncedData.BLOCK_POS, (Object)BlockPos.ZERO, "guard_pos");
    private static final EntityDataAccessor<Optional<UUID>> CONFIG_ID = GOLEM_DATA.define(SyncedData.UUID, Optional.empty(), "config_owner");
    private static final EntityDataAccessor<Integer> CONFIG_COLOR = GOLEM_DATA.define(SyncedData.INT, (Object)0, "config_color");
    private static final EntityDataAccessor<Integer> PATROL_STAGE = GOLEM_DATA.define(SyncedData.INT, (Object)0, "patrol_stage");
    private static final UniformInt PERSISTENT_ANGER_TIME = TimeUtil.rangeOfSeconds((int)20, (int)39);
    private static final EntityDataAccessor<Integer> DATA_REMAINING_ANGER_TIME = GOLEM_DATA.define(SyncedData.INT, (Object)0, null);
    private static final EntityDataAccessor<Boolean> IS_IN_RANGE_ATTACK = SynchedEntityData.defineId(AbstractGolemEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    @Nullable
    private UUID persistentAngerTarget;

    private static <T> EntityDataAccessor<T> defineId(EntityDataSerializer<T> ser) {
        return SynchedEntityData.defineId(AbstractGolemEntity.class, ser);
    }

    protected AbstractGolemEntity(EntityType<T> type, Level level) {
        super(type, level);
        this.waterNavigation = new AmphibiousPathNavigation((Mob)this, level);
        this.groundNavigation = new GroundPathNavigation((Mob)this, level);
    }

    public void onCreate(ArrayList<GolemMaterial> materials, GolemUpgrade upgrades, @Nullable UUID owner) {
        this.updateAttributes(materials, upgrades, owner);
        this.setHealth(this.getMaxHealth());
    }

    public void updateAttributes(ArrayList<GolemMaterial> materials, GolemUpgrade upgrades, @Nullable UUID owner) {
        this.materials = materials;
        this.upgrades = upgrades;
        this.setOwnerUUID(owner);
        this.modifiers = GolemMaterial.collectModifiers(materials, upgrades);
        this.golemFlags.clear();
        this.getModifiers().forEach((m, i) -> m.onRegisterFlag(this.golemFlags::add));
        if (this.canSwim()) {
            this.moveControl = new GolemSwimMoveControl(this);
            this.navigation = this.waterNavigation;
            this.setPathfindingMalus(PathType.WATER, 0.0f);
            this.setPathfindingMalus(PathType.WATER_BORDER, 0.0f);
        }
        if (!this.level().isClientSide()) {
            this.getModifiers().forEach((m, i) -> m.onRegisterGoals(this, (int)i, (arg_0, arg_1) -> ((GoalSelector)this.goalSelector).addGoal(arg_0, arg_1)));
        }
        GolemMaterial.addAttributes(materials, upgrades, this.getThis());
        this.refreshDimensions();
    }

    public EntityType<T> getType() {
        return (EntityType)Wrappers.cast((Object)super.getType());
    }

    public ArrayList<GolemMaterial> getMaterials() {
        return this.materials;
    }

    public GolemUpgrade getUpgrades() {
        return this.upgrades;
    }

    public HashMap<GolemModifier, Integer> getModifiers() {
        return this.modifiers;
    }

    public boolean hasFlag(GolemFlags flag) {
        if (this.golemFlags == null) {
            return false;
        }
        return this.golemFlags.contains((Object)flag);
    }

    protected final InteractionResult mobInteract(Player player, InteractionHand hand) {
        if (player.getItemInHand(hand).is(MGTagGen.GOLEM_INTERACT)) {
            return InteractionResult.PASS;
        }
        for (Map.Entry<GolemModifier, Integer> ent : this.modifiers.entrySet()) {
            InteractionResult result = ent.getKey().interact(player, this, hand, ent.getValue());
            if (result == InteractionResult.PASS) continue;
            return result;
        }
        return this.mobInteractImpl(player, hand);
    }

    protected InteractionResult mobInteractImpl(Player player, InteractionHand hand) {
        GolemEquipmentItem item;
        if (!((Boolean)MGConfig.COMMON.barehandRetrieve.get()).booleanValue() || !this.canModify(player)) {
            return InteractionResult.FAIL;
        }
        if (player.getMainHandItem().isEmpty()) {
            if (!this.level().isClientSide()) {
                this.unRide();
                player.setItemSlot(EquipmentSlot.MAINHAND, this.toItem((LivingEntity)player));
            }
            return InteractionResult.SUCCESS;
        }
        ItemStack stack = player.getItemInHand(hand);
        Item item2 = stack.getItem();
        if (item2 instanceof GolemEquipmentItem && (item = (GolemEquipmentItem)item2).isFor(this.getType()) && this.getItemBySlot(item.getSlot()).isEmpty()) {
            if (!this.level().isClientSide()) {
                this.setItemSlot(item.getSlot(), stack.split(1));
            }
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    public void untrack(GolemTracker.Status type, @Nullable Entity cause) {
        UUID id = this.getOwnerUUID();
        if (id == null || id.equals(Util.NIL_UUID) || this.isHostile()) {
            return;
        }
        if (this.getOwner() instanceof FakePlayer) {
            return;
        }
        GolemTracker tracker = GolemConfigStorage.get(this.level()).getTracker(id);
        tracker.untrack(this, type, cause);
    }

    public ItemStack toItem(LivingEntity player) {
        this.recordedPosition = this.position();
        this.recordedGuardPos = this.getGuardPos();
        this.leader = null;
        this.untrack(player == this.getOwner() ? GolemTracker.Status.RETRIEVED : GolemTracker.Status.OTHER_RETRIEVED, (Entity)player);
        ItemStack ans = GolemHolder.setEntity(this.getThis());
        this.level().broadcastEntityEvent((Entity)this, (byte)60);
        this.discard();
        return ans;
    }

    public ItemStack asItemForDisplay() {
        return GolemHolder.setEntity(this.getThis());
    }

    public boolean fireImmune() {
        return this.hasFlag(GolemFlags.FIRE_IMMUNE);
    }

    protected void actuallyHurt(DamageSource source, float damage) {
        if (source.is(DamageTypeTags.BYPASSES_INVULNERABILITY)) {
            damage *= 1000.0f;
        }
        super.actuallyHurt(source, damage);
        if (this.getHealth() <= 0.0f && this.hasFlag(GolemFlags.RECYCLE)) {
            this.unRide();
            this.untrack(GolemTracker.Status.DEATH_RECYCLE, source.getEntity());
            this.returnToInventory();
            this.level().broadcastEntityEvent((Entity)this, (byte)60);
            this.discard();
        }
    }

    protected void dropCustomDeathLoot(ServerLevel level, DamageSource source, boolean player) {
        MetalGolemEntity golem;
        boolean skip = false;
        Entity entity = source.getDirectEntity();
        if (entity instanceof MetalGolemEntity && (entity = (golem = (MetalGolemEntity)entity).getMainHandItem().getItem()) instanceof CustomDropGolemWeapon) {
            CustomDropGolemWeapon item = (CustomDropGolemWeapon)entity;
            skip = item.dropCustomDeathLoot(this, golem, golem.getMainHandItem(), source);
        }
        if (!skip) {
            HashMap<Item, Integer> drop = new HashMap<Item, Integer>();
            for (GolemMaterial mat : this.getMaterials()) {
                Item item = GolemMaterialConfig.get().getCraftIngredient(mat.id()).getItems()[0].getItem();
                drop.compute(item, (e, old) -> (old == null ? 0 : old) + 1);
            }
            drop.forEach((k, v) -> this.spawnAtLocation(new ItemStack((ItemLike)k, v.intValue())));
        }
        if (!this.isHostile()) {
            for (EquipmentSlot slot : EquipmentSlot.values()) {
                this.dropSlot(slot, true);
            }
        }
        super.dropCustomDeathLoot(level, source, player);
    }

    protected void dropSlot(EquipmentSlot slot, boolean isDeath) {
        ItemStack itemstack = this.getItemBySlot(slot);
        if (itemstack.isEmpty()) {
            return;
        }
        DataComponentType bind = EnchantmentEffectComponents.PREVENT_ARMOR_CHANGE;
        DataComponentType vanish = EnchantmentEffectComponents.PREVENT_EQUIPMENT_DROP;
        if (!isDeath && EnchantmentHelper.has((ItemStack)itemstack, (DataComponentType)bind)) {
            return;
        }
        if (isDeath && EnchantmentHelper.has((ItemStack)itemstack, (DataComponentType)vanish)) {
            return;
        }
        this.spawnAtLocation(itemstack);
        this.setItemSlot(slot, ItemStack.EMPTY);
    }

    private double getScaleImpl() {
        int reforge = this.getReforgeBase();
        double rate = Math.pow(1.0 * (double)(reforge - this.getReforgeCount()) / (double)reforge, 0.3333333333333333);
        return this.getAttributeValue((Holder)GolemTypes.GOLEM_SIZE) * rate;
    }

    public void checkSize() {
        if (!this.sizeDirty && this.tickCount > 5 && this.tickCount % 10 != 0) {
            return;
        }
        this.sizeDirty = false;
        double cur = this.getScaleImpl();
        if (this.lastSize != cur) {
            this.refreshDimensions();
        }
    }

    public void refreshDimensions() {
        this.lastSize = this.getScaleImpl();
        super.refreshDimensions();
    }

    public float maxUpStep() {
        return super.maxUpStep() * this.getScale();
    }

    public float getScale() {
        if (this.materials == null || this.materials.isEmpty() || this.level().isClientSide() && !this.isAddedToLevel() || this.getTags().contains("ClientOnly")) {
            return 1.0f;
        }
        double def = DefaultAttributes.getSupplier(this.getType()).getValue(GolemTypes.GOLEM_SIZE);
        return (float)(this.getScaleImpl() / def);
    }

    public void calculateEntityAnimation(boolean hasY) {
        float f = (float)Mth.length((double)(this.getX() - this.xo), (double)(hasY ? this.getY() - this.yo : 0.0), (double)(this.getZ() - this.zo));
        this.updateWalkAnimation(f / this.getScale());
    }

    public boolean canSwim() {
        return this.hasFlag(GolemFlags.SWIM);
    }

    public void travel(Vec3 pTravelVector) {
        if (!this.getMode().isMovable()) {
            pTravelVector = Vec3.ZERO;
        }
        if ((this.isControlledByLocalInstance() || this.isEffectiveAi()) && this.isInWater() && this.canSwim()) {
            this.moveRelative(0.08f, pTravelVector);
            this.move(MoverType.SELF, this.getDeltaMovement());
            this.setDeltaMovement(this.getDeltaMovement().scale(0.9));
            if (this.isControlledByLocalInstance()) {
                super.travel(pTravelVector);
            }
        } else {
            super.travel(pTravelVector);
        }
    }

    public void updateSwimming() {
        if (!this.level().isClientSide) {
            this.setSwimming(this.isEffectiveAi() && this.isInWater() && this.canSwim());
        }
    }

    public boolean isPushable() {
        return this.getMode().isMovable();
    }

    public boolean isPushedByFluid() {
        return !this.isSwimming() && this.getMode().isMovable();
    }

    public void setOwnerUUID(@Nullable UUID id) {
        this.owner = id;
        this.entityData.set(OWNER_ID, Optional.ofNullable(this.owner));
    }

    @Nullable
    public final UUID getOwnerUUID() {
        if (this.level().isClientSide()) {
            return ((Optional)this.entityData.get(OWNER_ID)).orElse(null);
        }
        return this.owner;
    }

    @Nullable
    public Player getOwner() {
        try {
            UUID uuid = this.getOwnerUUID();
            return uuid == null ? null : this.level().getPlayerByUUID(uuid);
        }
        catch (IllegalArgumentException illegalargumentexception) {
            return null;
        }
    }

    @Nullable
    public LivingEntity getLeader() {
        try {
            UUID uuid = this.getLeaderUUID();
            if (uuid == null) {
                return null;
            }
            Level level = this.level();
            if (!(level instanceof ServerLevel)) {
                return null;
            }
            ServerLevel sl = (ServerLevel)level;
            Entity e = sl.getEntity(uuid);
            if (!(e instanceof LivingEntity)) {
                return null;
            }
            LivingEntity le = (LivingEntity)e;
            return le;
        }
        catch (IllegalArgumentException ignored) {
            return null;
        }
    }

    @Nullable
    public UUID getLeaderUUID() {
        return this.leader;
    }

    public void setLeader(LivingEntity le) {
        this.leader = le.getUUID();
    }

    public final boolean isHostile() {
        return HostileGolemRegistry.isHostile(this.getOwnerUUID());
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        this.addPersistentAngerSaveData(tag);
        RegistryAccess pvd = this.level().registryAccess();
        tag.put("auto-serial", (Tag)Objects.requireNonNull(new TagCodec((HolderLookup.Provider)pvd).toTag(new CompoundTag(), (Object)this)));
        GOLEM_DATA.write(pvd, tag, this.entityData);
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.readPersistentAngerSaveData(this.level(), tag);
        RegistryAccess pvd = this.level().registryAccess();
        if (tag.contains("auto-serial")) {
            Wrappers.run(() -> new TagCodec((HolderLookup.Provider)pvd).fromTag(tag.getCompound("auto-serial"), ((Object)((Object)this)).getClass(), (Object)this));
        }
        this.updateAttributes(this.materials, (GolemUpgrade)Wrappers.cast((Object)this.getUpgrades()), this.owner);
        GOLEM_DATA.read(pvd, tag, this.entityData);
    }

    public void writeSpawnData(RegistryFriendlyByteBuf buffer) {
        PacketCodec.to((RegistryFriendlyByteBuf)buffer, (Object)((Object)this));
        buffer.writeInt(this.getReforgeCount());
    }

    public void readSpawnData(RegistryFriendlyByteBuf data) {
        PacketCodec.from((RegistryFriendlyByteBuf)data, (Class)((Class)Wrappers.cast(((Object)((Object)this)).getClass())), this.getThis());
        this.updateAttributes(this.materials, (GolemUpgrade)Wrappers.cast((Object)this.upgrades), this.owner);
        int reforge = data.readInt();
        if (reforge > 0) {
            this.updateReforge(reforge);
        }
    }

    public T getThis() {
        return (T)((Object)((AbstractGolemEntity)((Object)Wrappers.cast((Object)((Object)this)))));
    }

    public boolean hasLineOfSight(Entity target) {
        if (target.level() == this.level() && this.hasFlag(GolemFlags.SEE_THROUGH)) {
            Vec3 self = new Vec3(this.getX(), this.getEyeY(), this.getZ());
            Vec3 tarp = new Vec3(target.getX(), target.getEyeY(), target.getZ());
            double dist = tarp.distanceTo(self);
            if (dist <= 128.0) {
                if (target.level().canSeeSky(target.blockPosition())) {
                    return true;
                }
                if (dist < 5.0) {
                    return true;
                }
                if (self.y() < tarp.y()) {
                    return true;
                }
            }
        }
        return super.hasLineOfSight(target);
    }

    public boolean canFreeze() {
        return !this.hasFlag(GolemFlags.FREEZE_IMMUNE);
    }

    public boolean canBeSeenAsEnemy() {
        return !this.hasFlag(GolemFlags.PASSIVE) && super.canBeSeenAsEnemy();
    }

    public void setTarget(@Nullable LivingEntity target) {
        if (target != null && !this.canAttack(target)) {
            return;
        }
        super.setTarget(target);
        if (target != null) {
            TargetManager.get(this).onSetTarget(this, target);
        }
        if (target instanceof Mob) {
            Mob mob = (Mob)target;
            if (mob.getTarget() == null && mob.canAttack((LivingEntity)this)) {
                mob.setTarget((LivingEntity)this);
            }
            for (Map.Entry<GolemModifier, Integer> entry : this.getModifiers().entrySet()) {
                entry.getKey().onSetTarget(this, mob, entry.getValue());
            }
        }
    }

    public boolean canAttackType(EntityType<?> type) {
        return !this.hasFlag(GolemFlags.PASSIVE);
    }

    public boolean canAttack(LivingEntity target) {
        Optional<HostileFaction> faction;
        OwnableEntity own;
        LivingEntity parent;
        Player owner = this.getOwner();
        LivingEntity leader = this.getLeader();
        if (target == owner || target == leader) {
            return false;
        }
        if (target instanceof OwnableEntity && (parent = (own = (OwnableEntity)target).getOwner()) != null && (owner == parent || leader == parent)) {
            return false;
        }
        if (!target.canBeSeenAsEnemy()) {
            return false;
        }
        if (!target.isAlive()) {
            return false;
        }
        if (target instanceof AbstractGolemEntity) {
            AbstractGolemEntity other = (AbstractGolemEntity)target;
            if (this.isHostile() != other.isHostile()) {
                return true;
            }
            if (this.isHostile() && other.isHostile() && this.getOwnerUUID() == other.getOwnerUUID()) {
                return false;
            }
        }
        if ((faction = HostileGolemRegistry.tryGetFaction(this)).isPresent() && faction.get().hostileGolemAttacks(this, target)) {
            return true;
        }
        GolemConfigEntry config = this.getConfigEntry(null);
        if (config == null ? target.getType().is(MGTagGen.GOLEM_FRIENDLY) : config.targetFilter.friendlyToward(target)) {
            return false;
        }
        return !this.isAlliedTo((Entity)target) && this.canAttackType(target.getType()) && super.canAttack(target);
    }

    protected float getAttackDamage() {
        return (float)this.getAttributeValue(Attributes.ATTACK_DAMAGE);
    }

    public void tick() {
        super.tick();
        if (this.inventoryTick > 0) {
            --this.inventoryTick;
        }
        if (this.specialAttackCoolDown > 0) {
            --this.specialAttackCoolDown;
        }
        this.checkSize();
        if (this.level().isClientSide) {
            for (Map.Entry entry : this.getModifiers().entrySet()) {
                ((GolemModifier)((Object)entry.getKey())).onClientTick(this, (Integer)entry.getValue());
            }
        }
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            ItemStack stack = this.getItemBySlot(slot);
            Item item = stack.getItem();
            if (!(item instanceof TickEquipmentItem)) continue;
            TickEquipmentItem tickItem = (TickEquipmentItem)item;
            tickItem.tick(stack, this.level(), (Entity)this);
        }
        UUID id = this.getOwnerUUID();
        if (this.getOwner() instanceof FakePlayer) {
            return;
        }
        if (id == null || id.equals(Util.NIL_UUID) || this.isHostile()) {
            return;
        }
        GolemTracker golemTracker = GolemConfigStorage.get(this.level()).getTracker(id);
        golemTracker.track(this);
    }

    public void repair(float amount) {
        this.setHealth(Math.min(this.getMaxHealth(), this.getHealth() + amount));
    }

    protected int getMaxReforge() {
        return GolemType.getGolemType(this.getType()).getBodyPart().toItem().count - 1;
    }

    protected int getReforgeBase() {
        int total = 0;
        for (IGolemPart e : GolemType.getGolemType(this.getType()).values()) {
            total += e.toItem().count;
        }
        return total;
    }

    public void updateReforge(int reforge) {
        this.getPersistentData().putInt("GolemReforge", reforge);
        if (!this.level().isClientSide()) {
            AttributeInstance ins = this.getAttribute(Attributes.MAX_HEALTH);
            assert (ins != null);
            ins.removeModifier(REFORGE_ID);
            ins.addPermanentModifier(new AttributeModifier(REFORGE_ID, -1.0 * (double)reforge / (double)this.getReforgeBase(), AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
        }
        this.sizeDirty = true;
        this.checkSize();
        if (!this.level().isClientSide()) {
            ModularGolems.HANDLER.toTrackingPlayers((SimplePacketBase)ReforgeUpdatePacket.of(this, reforge), (Entity)this);
        }
    }

    public void checkReforge() {
        int reforge;
        if (this.getHealth() <= this.getMaxHealth() / 2.0f && (reforge = this.getPersistentData().getInt("GolemReforge")) < this.getMaxReforge()) {
            this.updateReforge(++reforge);
            this.repair(this.getMaxHealth() / 4.0f);
        }
    }

    public boolean isReforged() {
        return this.getPersistentData().getInt("GolemReforge") > 0;
    }

    public int getReforgeCount() {
        return this.getPersistentData().getInt("GolemReforge");
    }

    public void repairWithItem() {
        int reforge = this.getPersistentData().getInt("GolemReforge");
        if ((double)this.getHealth() > 0.75 * (double)this.getMaxHealth() && reforge > 0) {
            this.updateReforge(reforge - 1);
        } else {
            this.repair(this.getMaxHealth() / 4.0f);
        }
    }

    public void aiStep() {
        this.updateSwingTime();
        super.aiStep();
        if (!this.level().isClientSide) {
            if (this.tickCount % 20 == 0) {
                double heal = this.getAttributeValue(GolemTypes.GOLEM_REGEN.holder());
                for (Map.Entry<GolemModifier, Integer> entry : this.getModifiers().entrySet()) {
                    heal = entry.getKey().onHealTick(heal, this, entry.getValue());
                }
                if (heal > 0.0) {
                    this.heal((float)heal);
                }
                if (this.hasFlag(GolemFlags.REFORGE)) {
                    this.checkReforge();
                }
            }
            for (Map.Entry<GolemModifier, Integer> entry : this.getModifiers().entrySet()) {
                entry.getKey().onAiStep(this, entry.getValue());
            }
            this.updatePersistentAnger((ServerLevel)this.level(), true);
            LivingEntity target = this.getTarget();
            if (target != null && target.isAlive()) {
                TargetManager.get(this).tickTarget(this, target);
            }
        }
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            ItemStack stack = this.getItemBySlot(slot);
            if (stack.isEmpty()) continue;
            try {
                stack.inventoryTick(this.level(), (Entity)this, slot.ordinal(), slot == EquipmentSlot.MAINHAND);
            }
            catch (Exception e) {
                ModularGolems.LOGGER.warn("Golem cannot use item " + String.valueOf(stack), (Throwable)e);
                this.spawnAtLocation(stack);
                this.setItemSlot(slot, ItemStack.EMPTY);
            }
        }
    }

    protected int decreaseAirSupply(int air) {
        return air;
    }

    public boolean killedEntity(ServerLevel level, LivingEntity target) {
        Player player = this.getOwner();
        if (player != null) {
            ((GolemKillTrigger)((Object)GolemTriggers.KILL.get())).trigger((ServerPlayer)player, (Entity)target);
        }
        return super.killedEntity(level, target);
    }

    public void handleEntityEvent(byte event) {
        for (Map.Entry<GolemModifier, Integer> e : this.modifiers.entrySet()) {
            e.getKey().handleEvent(this, e.getValue(), event);
        }
        super.handleEntityEvent(event);
    }

    public GolemMode getMode() {
        return GolemModes.get((Integer)this.entityData.get(DATA_MODE));
    }

    public BlockPos getGuardPos() {
        return (BlockPos)this.entityData.get(GUARD_POS);
    }

    public void setMode(int mode, BlockPos pos) {
        this.entityData.set(DATA_MODE, (Object)mode);
        this.entityData.set(GUARD_POS, (Object)pos);
    }

    public boolean initMode(@Nullable Player player) {
        boolean succeed;
        GolemConfigEntry config = this.getConfigEntry(null);
        int mode = config == null ? 0 : config.defaultMode;
        boolean far = config != null && config.summonToPosition && mode != 0 && this.recordedPosition.lengthSqr() > 0.0;
        BlockPos guard = far && !this.recordedGuardPos.equals((Object)BlockPos.ZERO) ? this.recordedGuardPos : this.blockPosition();
        Vec3 pos = far ? this.recordedPosition : this.position();
        boolean bl = succeed = this.level().isLoaded(BlockPos.containing((Position)pos)) && pos.distanceTo(this.position()) < (double)((Integer)MGConfig.COMMON.summonDistance.get()).intValue();
        if (!succeed) {
            if (player instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)player;
                sp.sendSystemMessage((Component)MGLangData.SUMMON_FAILED.get(this.getDisplayName()));
            }
            return false;
        }
        if (far && player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            sp.sendSystemMessage((Component)MGLangData.SUMMON_FAR.get(this.getDisplayName(), (int)pos.x(), (int)pos.y(), (int)pos.z()));
        }
        this.setMode(mode, mode == 0 ? BlockPos.ZERO : guard);
        this.moveTo(pos);
        this.setTarget(null);
        this.setPersistentAngerTarget(null);
        return true;
    }

    public boolean canChangeDimensions(Level from, Level to) {
        return this.getMode().canChangeDimensions() && super.canChangeDimensions(from, to);
    }

    public int getConfigColor() {
        return (Integer)this.entityData.get(CONFIG_COLOR);
    }

    @Nullable
    public GolemConfigEntry getConfigEntry(@Nullable Component dummy) {
        int configColor = this.getConfigColor();
        Optional<HostileFaction> opt = HostileGolemRegistry.tryGetFaction(this);
        if (opt.isPresent()) {
            return opt.get().getConfig(this, configColor);
        }
        UUID configOwner = ((Optional)this.entityData.get(CONFIG_ID)).orElse(null);
        if (configColor < 0 || configOwner == null) {
            return null;
        }
        GolemConfigStorage storage = GolemConfigStorage.get(this.level());
        if (dummy == null) {
            return storage.getStorage(configOwner, configColor);
        }
        return storage.getOrCreateStorage(configOwner, configColor, dummy);
    }

    public void setConfigCard(@Nullable UUID owner, int color) {
        this.entityData.set(CONFIG_ID, Optional.ofNullable(owner));
        this.entityData.set(CONFIG_COLOR, (Object)color);
    }

    public void setPatrolStage(int stage) {
        this.entityData.set(PATROL_STAGE, (Object)stage);
    }

    public int getPatrolStage() {
        return (Integer)this.entityData.get(PATROL_STAGE);
    }

    public void advancePatrolStage() {
        PathRecordCard.Pos list = PathConfig.getPath(this);
        if (list == null || !list.match(this.level())) {
            return;
        }
        int stage = this.getPatrolStage();
        if (++stage >= list.pos().size()) {
            stage = 0;
        }
        this.setPatrolStage(stage);
    }

    public List<BlockPos> getPatrolList() {
        PathRecordCard.Pos list = PathConfig.getPath(this);
        if (list == null || !list.match(this.level())) {
            return List.of();
        }
        int stage = this.getPatrolStage();
        if (stage > 0 && stage < list.pos().size()) {
            List<BlockPos> first = list.pos().subList(stage, list.pos().size());
            List<BlockPos> second = list.pos().subList(0, stage);
            ArrayList<BlockPos> ans = new ArrayList<BlockPos>(first);
            ans.addAll(second);
            return ans;
        }
        return list.pos();
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        GOLEM_DATA.register(builder);
        builder.define(IS_IN_RANGE_ATTACK, (Object)false);
    }

    public void startPersistentAngerTimer() {
        this.setRemainingPersistentAngerTime(PERSISTENT_ANGER_TIME.sample(this.random));
    }

    public int getRemainingPersistentAngerTime() {
        return (Integer)this.entityData.get(DATA_REMAINING_ANGER_TIME);
    }

    public void setRemainingPersistentAngerTime(int pTime) {
        this.entityData.set(DATA_REMAINING_ANGER_TIME, (Object)pTime);
    }

    public void setPersistentAngerTarget(@Nullable UUID target) {
        this.persistentAngerTarget = target;
    }

    @Nullable
    public UUID getPersistentAngerTarget() {
        return this.persistentAngerTarget;
    }

    public PlayerTeam getTeam() {
        Player owner = this.getOwner();
        if (owner != null) {
            return owner.getTeam();
        }
        return super.getTeam();
    }

    public boolean canModify(Player player) {
        GolemConfigEntry entry = this.getConfigEntry(null);
        if (entry != null && entry.locked) {
            return false;
        }
        Player owner = this.getOwner();
        if (player == owner) {
            return true;
        }
        if (player.getAbilities().instabuild || this.getOwnerUUID() == null && !this.predicateTarget((LivingEntity)player)) {
            return true;
        }
        if (((Boolean)MGConfig.COMMON.ownerPickupOnly.get()).booleanValue()) {
            return false;
        }
        return this.isAlliedTo((Entity)player);
    }

    public boolean isAlliedTo(Entity other) {
        if (other == this) {
            return true;
        }
        Player owner = this.getOwner();
        if (other == owner) {
            return true;
        }
        if (owner != null) {
            return owner.isAlliedTo(other) || other.isAlliedTo((Entity)owner);
        }
        Optional<HostileFaction> opt = HostileGolemRegistry.tryGetFaction(this);
        if (opt.isPresent() && opt.get().isAlliedTo(this, other)) {
            return true;
        }
        return super.isAlliedTo(other);
    }

    public boolean doHurtTarget(Entity target) {
        if (target instanceof LivingEntity) {
            LivingEntity le = (LivingEntity)target;
            le.setLastHurtByPlayer(this.getOwner());
        }
        return super.doHurtTarget(target);
    }

    public int aiHurtTarget(Entity target) {
        boolean ans = this.doHurtTarget(target);
        return ans ? -1 : 0;
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new GolemFloatGoal(this));
        this.goalSelector.addGoal(1, (Goal)new TeleportToOwnerGoal(this));
        this.goalSelector.addGoal(4, (Goal)new FollowOwnerGoal(this));
        this.goalSelector.addGoal(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.goalSelector.addGoal(8, (Goal)new GolemRandomStrollGoal(this));
        this.goalSelector.addGoal(9, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(3, (Goal)new Golem3DTargetGoal(this, 5));
        this.targetSelector.addGoal(6, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, false));
    }

    public boolean predicateTarget(LivingEntity e) {
        return TargetManager.predicateTarget(this, e) != null;
    }

    public boolean isInSittingPose() {
        return false;
    }

    @Nullable
    public LivingEntity getFollowTarget() {
        if (this.getMode() == GolemModes.SQUAD) {
            return this.getCaptain();
        }
        LivingEntity leader = this.getLeader();
        if (leader != null) {
            return leader;
        }
        return this.getOwner();
    }

    @Nullable
    public LivingEntity getCaptain() {
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel sl = (ServerLevel)level;
            GolemConfigEntry config = this.getConfigEntry(null);
            if (config == null) {
                return null;
            }
            UUID uuid = config.squadConfig.getCaptainId();
            if (uuid == null) {
                return null;
            }
            Entity captain = sl.getEntity(uuid);
            if (captain == null) {
                return null;
            }
            if (!captain.isAlive() || captain.level() != sl) {
                return null;
            }
            if (captain instanceof LivingEntity) {
                LivingEntity le = (LivingEntity)captain;
                return le;
            }
            return null;
        }
        return null;
    }

    public Vec3 getTargetPos() {
        if (this.getMode() == GolemModes.ROUTE) {
            PathRecordCard.Pos list = PathConfig.getPath(this);
            if (list != null && list.match(this.level())) {
                int target = this.getPatrolStage();
                if (!list.pos().isEmpty()) {
                    return Vec3.atCenterOf((Vec3i)((Vec3i)list.pos().get(Math.min(target, list.pos().size() - 1))));
                }
            }
            return this.position();
        }
        if (this.getMode().hasPos()) {
            BlockPos pos = this.getGuardPos();
            return new Vec3((double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5);
        }
        LivingEntity owner = this.getFollowTarget();
        if (owner == null) {
            return this.getPosition(1.0f);
        }
        return owner.getPosition(1.0f);
    }

    public boolean isPowered() {
        return true;
    }

    public boolean isInvulnerable() {
        return this.hasFlag(GolemFlags.IMMUNITY);
    }

    public void die(DamageSource source) {
        this.untrack(GolemTracker.Status.DEATH, source.getEntity());
        if (!this.isHostile()) {
            ModularGolems.LOGGER.info("Golem {} died, message: '{}'", (Object)this, (Object)source.getLocalizedDeathMessage((LivingEntity)this).getString());
            Player owner = this.getOwner();
            if (owner != null && !this.level().isClientSide) {
                owner.sendSystemMessage(source.getLocalizedDeathMessage((LivingEntity)this));
            }
        }
        super.die(source);
    }

    public double getPerceivedTargetDistanceSquareForMeleeAttack(LivingEntity target) {
        return GolemMeleeGoal.calculateDistSqr(this, target);
    }

    public void checkRide(LivingEntity target) {
    }

    public void resetTarget(@Nullable LivingEntity le) {
        for (WrappedGoal e : this.targetSelector.getAvailableGoals()) {
            Goal goal = e.getGoal();
            if (!(goal instanceof TargetGoal)) continue;
            TargetGoal t = (TargetGoal)goal;
            t.stop();
        }
        if (le != null) {
            this.setLastHurtByMob(le);
        }
    }

    public ItemWrapper getWrapperOfHand(EquipmentSlot slot) {
        return ItemWrapper.simple(() -> this.getItemBySlot(slot), e -> super.setItemSlot(slot, e));
    }

    @Nullable
    public Entity changeDimension(DimensionTransition dim) {
        if (!((Boolean)MGConfig.COMMON.allowDimensionChange.get()).booleanValue()) {
            return null;
        }
        return super.changeDimension(dim);
    }

    public boolean isInRangedMode() {
        return this.getMode() == GolemModes.STAND || (Boolean)this.getEntityData().get(IS_IN_RANGE_ATTACK) != false;
    }

    public void setInRangeAttack(boolean flag) {
        this.getEntityData().set(IS_IN_RANGE_ATTACK, (Object)flag);
    }

    public boolean canBeAffected(MobEffectInstance ins) {
        if (this.effectImmunity.contains(ins.getEffect())) {
            return false;
        }
        return super.canBeAffected(ins);
    }

    public void makeStuckInBlock(BlockState state, Vec3 vec) {
        if (this.hasFlag(GolemFlags.FREE_MOVE)) {
            return;
        }
        super.makeStuckInBlock(state, vec);
    }

    public void setPosRaw(double x, double y, double z) {
        this.trackPos(x, y, z);
        super.setPosRaw(x, y, z);
    }

    public void trackPos(double x, double y, double z) {
        if (this.level().isClientSide() || !this.isAddedToLevel()) {
            return;
        }
        UUID id = this.getOwnerUUID();
        if (id == null || id.equals(Util.NIL_UUID) || this.isHostile()) {
            return;
        }
        if (this.getOwner() instanceof FakePlayer) {
            return;
        }
        GolemTracker tracker = GolemConfigStorage.get(this.level()).getTracker(id);
        tracker.trackPos(this.getUUID(), x, y, z);
    }

    public void returnToInventory() {
        LivingEntity leader = this.getLeader();
        ItemStack stack = GolemHolder.setEntity(this.getThis());
        if (leader != null && leader.isAlive() && ((GolemToOwnerEvent)NeoForge.EVENT_BUS.post((Event)new GolemToOwnerEvent(leader, stack))).isCanceled()) {
            return;
        }
        Player player = this.getOwner();
        if (player != null && player.isAlive()) {
            if (((GolemToOwnerEvent)NeoForge.EVENT_BUS.post((Event)new GolemToOwnerEvent((LivingEntity)player, stack))).isCanceled()) {
                return;
            }
            player.getInventory().placeItemBackInInventory(stack);
        } else {
            this.spawnAtLocation(stack);
        }
    }
}

