/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.content.core;

import com.tterrag.registrate.util.entry.EntityEntry;
import dev.xkmc.l2core.init.reg.registrate.NamedEntry;
import dev.xkmc.l2serial.util.Wrappers;
import dev.xkmc.modulargolems.content.core.IGolemPart;
import dev.xkmc.modulargolems.content.core.ModelProvider;
import dev.xkmc.modulargolems.content.entity.common.AbstractGolemEntity;
import dev.xkmc.modulargolems.content.item.golem.GolemHolder;
import dev.xkmc.modulargolems.init.registrate.GolemTypes;
import java.util.HashMap;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class GolemType<T extends AbstractGolemEntity<T, P>, P extends IGolemPart<P>>
extends NamedEntry<GolemType<?, ?>> {
    private static final HashMap<ResourceLocation, GolemType<?, ?>> ENTITY_TYPE_TO_GOLEM_TYPE = new HashMap();
    public static final HashMap<ResourceLocation, GolemHolder<?, ?>> GOLEM_TYPE_TO_ITEM = new HashMap();
    public static final HashMap<ResourceLocation, Supplier<ModelProvider<?, ?>>> GOLEM_TYPE_TO_MODEL = new HashMap();
    private final EntityEntry<T> type;
    private final Supplier<P[]> list;
    private final P body;

    public static <T extends AbstractGolemEntity<T, P>, P extends IGolemPart<P>> GolemType<T, P> getGolemType(EntityType<T> type) {
        return (GolemType)((Object)Wrappers.cast(ENTITY_TYPE_TO_GOLEM_TYPE.get(BuiltInRegistries.ENTITY_TYPE.getKey(type))));
    }

    public static <T extends AbstractGolemEntity<T, P>, P extends IGolemPart<P>> GolemHolder<T, P> getGolemHolder(GolemType<T, ?> type) {
        return (GolemHolder)((Object)Wrappers.cast(GOLEM_TYPE_TO_ITEM.get(type.getRegistryName())));
    }

    public static <T extends AbstractGolemEntity<T, P>, P extends IGolemPart<P>> GolemHolder<T, P> getGolemHolder(EntityType<T> type) {
        return GolemType.getGolemHolder(GolemType.getGolemType(type));
    }

    public GolemType(EntityEntry<T> type, Supplier<P[]> list, P body, Supplier<ModelProvider<T, P>> model) {
        super(GolemTypes.TYPES);
        this.type = type;
        this.list = list;
        this.body = body;
        ENTITY_TYPE_TO_GOLEM_TYPE.put(type.getId(), this);
        GOLEM_TYPE_TO_MODEL.put(type.getId(), (Supplier)Wrappers.cast(model));
    }

    public T create(Level level) {
        return (T)((Object)Objects.requireNonNull((AbstractGolemEntity)((EntityType)this.type.get()).create(level)));
    }

    public T create(ServerLevel level, CompoundTag tag) {
        return (T)((Object)((AbstractGolemEntity)((Object)Wrappers.cast((Object)((Entity)EntityType.create((CompoundTag)tag, (Level)level).get())))));
    }

    @Nullable
    public T createForDisplay(Level level, CompoundTag tag) {
        Entity ans = EntityType.create((CompoundTag)tag, (Level)level).orElse(null);
        if (ans == null) {
            return null;
        }
        AbstractGolemEntity golem = (AbstractGolemEntity)((Object)Wrappers.cast((Object)ans));
        golem.addTag("ClientOnly");
        if (tag.contains("attributes", 9)) {
            golem.getAttributes().load(tag.getList("attributes", 10));
        }
        if (tag.contains("Health", 5)) {
            golem.setHealth(tag.getFloat("Health"));
        }
        golem.yHeadRot = 0.0f;
        golem.yHeadRotO = 0.0f;
        golem.yBodyRot = 0.0f;
        golem.yBodyRotO = 0.0f;
        golem.xRotO = 0.0f;
        golem.setXRot(0.0f);
        return (T)((Object)golem);
    }

    public EntityType<?> type() {
        return (EntityType)this.type.get();
    }

    public P[] values() {
        return (IGolemPart[])this.list.get();
    }

    public P getBodyPart() {
        return this.body;
    }
}

