/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.content.core;

import dev.xkmc.l2core.init.reg.registrate.NamedEntry;
import dev.xkmc.modulargolems.content.core.StatFilterType;
import dev.xkmc.modulargolems.init.registrate.GolemTypes;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.item.component.ItemAttributeModifiers;

public class GolemStatType
extends NamedEntry<GolemStatType> {
    private final Supplier<Holder<Attribute>> attribute;
    public final Kind kind;
    public final StatFilterType type;
    private Set<GolemStatType> conflicting;

    public GolemStatType(Supplier<Holder<Attribute>> attribute, Kind kind, StatFilterType type) {
        super(GolemTypes.STAT_TYPES);
        this.attribute = attribute;
        this.kind = kind;
        this.type = type;
    }

    public Holder<Attribute> getAttribute() {
        return this.attribute.get();
    }

    public MutableComponent getAdderTooltip(double val) {
        if (this.kind == Kind.PERCENT) {
            val *= 100.0;
        }
        String key = "attribute.modifier." + (val < 0.0 ? "take." : "plus.") + (this.kind == Kind.PERCENT ? 1 : 0);
        return Component.translatable((String)key, (Object[])new Object[]{ItemAttributeModifiers.ATTRIBUTE_MODIFIER_FORMAT.format(Math.abs(val)), Component.translatable((String)((Attribute)this.attribute.get().value()).getDescriptionId())}).withStyle(ChatFormatting.BLUE);
    }

    public MutableComponent getTotalTooltip(double val) {
        if (this.kind == Kind.PERCENT) {
            val *= 100.0;
        }
        String key = "attribute.modifier." + (val < 0.0 ? "take." : (this.kind == Kind.BASE ? "equals." : "plus.")) + (this.kind == Kind.PERCENT ? 1 : 0);
        return Component.translatable((String)key, (Object[])new Object[]{ItemAttributeModifiers.ATTRIBUTE_MODIFIER_FORMAT.format(Math.abs(val)), Component.translatable((String)((Attribute)this.attribute.get().value()).getDescriptionId())}).withStyle(ChatFormatting.BLUE);
    }

    public void applyToEntity(LivingEntity e, double v) {
        AttributeInstance ins = e.getAttribute(this.attribute.get());
        if (ins == null) {
            return;
        }
        switch (this.kind.ordinal()) {
            case 0: {
                ins.setBaseValue(v);
                break;
            }
            case 1: {
                ins.setBaseValue(ins.getValue() + v);
                break;
            }
            case 2: {
                ins.setBaseValue(ins.getValue() * (1.0 + v));
            }
        }
    }

    public Set<GolemStatType> hasConflict() {
        if (this.kind == Kind.BASE) {
            return Set.of();
        }
        if (this.conflicting == null) {
            this.conflicting = new LinkedHashSet<GolemStatType>();
            for (GolemStatType e : GolemTypes.STAT_TYPES.get()) {
                if (e == this || e.attribute.get() != this.attribute.get()) continue;
                if (e.kind == Kind.BASE) {
                    this.conflicting.clear();
                    return Set.of();
                }
                if (e.kind == this.kind) continue;
                this.conflicting.add(e);
            }
        }
        return this.conflicting;
    }

    public static enum Kind {
        BASE,
        ADD,
        PERCENT;

    }
}

