/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.content.config;

import com.mojang.datafixers.util.Pair;
import dev.xkmc.l2serial.util.Wrappers;
import dev.xkmc.modulargolems.content.config.GolemMaterialConfig;
import dev.xkmc.modulargolems.content.core.GolemStatType;
import dev.xkmc.modulargolems.content.core.IGolemPart;
import dev.xkmc.modulargolems.content.entity.common.AbstractGolemEntity;
import dev.xkmc.modulargolems.content.item.data.GolemUpgrade;
import dev.xkmc.modulargolems.content.item.golem.GolemPart;
import dev.xkmc.modulargolems.content.item.upgrade.IUpgradeItem;
import dev.xkmc.modulargolems.content.modifier.base.AttributeGolemModifier;
import dev.xkmc.modulargolems.content.modifier.base.GolemModifier;
import dev.xkmc.modulargolems.content.modifier.base.ModifierInstance;
import dev.xkmc.modulargolems.init.ModularGolems;
import dev.xkmc.modulargolems.init.registrate.GolemTypes;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.DefaultAttributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;

public record GolemMaterial(HashMap<GolemStatType, Double> stats, HashMap<GolemModifier, Integer> modifiers, ResourceLocation id, Item part) {
    public static final ResourceLocation EMPTY = ModularGolems.loc("empty");

    public static Map<Holder<Attribute>, Pair<GolemStatType, Double>> collectAttributes(List<GolemMaterial> list, GolemUpgrade upgrades) {
        LinkedHashMap<Holder<Attribute>, Map<GolemStatType, Double>> values = new LinkedHashMap<Holder<Attribute>, Map<GolemStatType, Double>>();
        for (Map.Entry entry : GolemTypes.STAT_TYPES.get().entrySet()) {
            GolemMaterial.appendStat(values, (GolemStatType)((Object)entry.getValue()), 0.0);
        }
        for (GolemMaterial golemMaterial : list) {
            golemMaterial.stats.forEach((k, v) -> GolemMaterial.appendStat(values, k, v));
        }
        for (Map.Entry entry : GolemMaterial.collectModifiers(list, upgrades).entrySet()) {
            Object k2 = entry.getKey();
            if (!(k2 instanceof AttributeGolemModifier)) continue;
            AttributeGolemModifier attr = (AttributeGolemModifier)((Object)k2);
            for (AttributeGolemModifier.AttrEntry attrEntry : attr.entries) {
                GolemMaterial.appendStat(values, attrEntry.type().get(), attrEntry.getValue((Integer)entry.getValue()));
            }
        }
        LinkedHashMap<Holder<Attribute>, Pair<GolemStatType, Double>> ans = new LinkedHashMap<Holder<Attribute>, Pair<GolemStatType, Double>>();
        for (Map.Entry ent : ((HashMap)values).entrySet()) {
            LinkedHashMap<GolemStatType.Kind, Pair> linkedHashMap = new LinkedHashMap<GolemStatType.Kind, Pair>();
            for (Map.Entry entry : ((Map)ent.getValue()).entrySet()) {
                linkedHashMap.compute(((GolemStatType)((Object)entry.getKey())).kind, (k, old) -> Pair.of((Object)((Object)((GolemStatType)((Object)((Object)((Object)entry.getKey()))))), (Object)((old == null ? 0.0 : (Double)old.getSecond()) + (Double)entry.getValue())));
            }
            if (linkedHashMap.isEmpty()) continue;
            if (linkedHashMap.size() == 1) {
                ans.put((Holder<Attribute>)((Holder)ent.getKey()), (Pair<GolemStatType, Double>)((Pair)((HashMap)linkedHashMap).values().stream().findFirst().get()));
                continue;
            }
            if (!linkedHashMap.containsKey((Object)GolemStatType.Kind.BASE)) {
                double val;
                Pair pair;
                double val2;
                if (linkedHashMap.containsKey((Object)GolemStatType.Kind.ADD) && (val2 = ((Double)(pair = (Pair)((HashMap)linkedHashMap).get((Object)GolemStatType.Kind.ADD)).getSecond()).doubleValue()) != 0.0) {
                    ans.put((Holder<Attribute>)((Holder)ent.getKey()), (Pair<GolemStatType, Double>)pair);
                    continue;
                }
                if (!linkedHashMap.containsKey((Object)GolemStatType.Kind.PERCENT) || (val = ((Double)(pair = (Pair)((HashMap)linkedHashMap).get((Object)GolemStatType.Kind.PERCENT)).getSecond()).doubleValue()) == 0.0) continue;
                ans.put((Holder<Attribute>)((Holder)ent.getKey()), (Pair<GolemStatType, Double>)pair);
                continue;
            }
            Pair candidate = (Pair)((HashMap)linkedHashMap).get((Object)GolemStatType.Kind.BASE);
            GolemStatType type = (GolemStatType)((Object)candidate.getFirst());
            double d = (Double)candidate.getSecond();
            if (linkedHashMap.containsKey((Object)GolemStatType.Kind.ADD)) {
                d += ((Double)((Pair)((HashMap)linkedHashMap).get((Object)GolemStatType.Kind.ADD)).getSecond()).doubleValue();
            }
            if (linkedHashMap.containsKey((Object)GolemStatType.Kind.PERCENT)) {
                d *= 1.0 + (Double)((Pair)((HashMap)linkedHashMap).get((Object)GolemStatType.Kind.PERCENT)).getSecond();
            }
            ans.put((Holder<Attribute>)((Holder)ent.getKey()), (Pair<GolemStatType, Double>)Pair.of((Object)((Object)type), (Object)d));
        }
        return ans;
    }

    private static void appendStat(Map<Holder<Attribute>, Map<GolemStatType, Double>> values, GolemStatType k, double v) {
        values.computeIfAbsent(k.getAttribute(), e -> new LinkedHashMap()).compute(k, (e, old) -> (old == null ? 0.0 : old) + v);
    }

    public static HashMap<GolemModifier, Integer> collectModifiers(Collection<GolemMaterial> list, GolemUpgrade upgrades) {
        LinkedHashMap<GolemModifier, Integer> values = new LinkedHashMap<GolemModifier, Integer>();
        for (GolemMaterial stats : list) {
            stats.modifiers.forEach((k, v) -> values.compute((GolemModifier)((Object)k), (a, old) -> Math.min(a.maxLevel, (old == null ? 0 : old) + v)));
        }
        for (IUpgradeItem e : upgrades.upgradeItems()) {
            for (ModifierInstance m : e.get()) {
                values.compute(m.mod(), (a, old) -> Math.min(a.maxLevel, (old == null ? 0 : old) + m.level()));
            }
        }
        return values;
    }

    public static <T extends AbstractGolemEntity<T, P>, P extends IGolemPart<P>> void addAttributes(List<GolemMaterial> list, GolemUpgrade upgrades, T entity) {
        AttributeSupplier map = DefaultAttributes.getSupplier((EntityType)((EntityType)Wrappers.cast(entity.getType())));
        Map<Holder<Attribute>, Pair<GolemStatType, Double>> attrs = GolemMaterial.collectAttributes(list, upgrades);
        attrs.keySet().forEach(e -> {
            AttributeInstance attr = entity.getAttribute((Holder)e);
            if (attr != null) {
                attr.setBaseValue(map.getBaseValue(e));
            }
        });
        attrs.forEach((k, v) -> ((GolemStatType)((Object)((Object)v.getFirst()))).applyToEntity((LivingEntity)entity, (Double)v.getSecond()));
    }

    public static Optional<ResourceLocation> getMaterial(ItemStack stack) {
        for (Map.Entry<ResourceLocation, Ingredient> ent : GolemMaterialConfig.get().ingredients.entrySet()) {
            if (!ent.getValue().test(stack)) continue;
            return Optional.of(ent.getKey());
        }
        return Optional.empty();
    }

    public static Optional<ResourceLocation> getRepairMaterial(ItemStack stack) {
        for (Map.Entry<ResourceLocation, Ingredient> ent : GolemMaterialConfig.get().repairIngredients.entrySet()) {
            if (!ent.getValue().test(stack)) continue;
            return Optional.of(ent.getKey());
        }
        return Optional.empty();
    }

    public MutableComponent getDesc() {
        return Component.translatable((String)("golem_material." + this.id.getNamespace() + "." + this.id.getPath())).withStyle(ChatFormatting.GOLD);
    }

    public GolemPart<?, ?> getPart() {
        return (GolemPart)Wrappers.cast((Object)this.part());
    }
}

