/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.content.client.tracker;

import dev.xkmc.modulargolems.content.capability.GolemTracker;
import dev.xkmc.modulargolems.content.core.IGolemPart;
import dev.xkmc.modulargolems.init.data.MGLangData;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;

public class TrackerInfo {
    public static Component getDesc(GolemTracker.TrackedData data) {
        float f = Mth.clamp((float)(data.hp / data.mhp), (float)0.0f, (float)1.0f);
        int color = Mth.hsvToRgb((float)(f / 3.0f), (float)1.0f, (float)0.5f);
        MutableComponent hc = Component.literal((String)("" + Math.round(data.hp))).setStyle(Style.EMPTY.withColor(color));
        MutableComponent hpText = hc.append((Component)Component.literal((String)("/" + Math.round(data.mhp))).withStyle(data.hp <= 0.0f ? ChatFormatting.DARK_RED : ChatFormatting.DARK_AQUA));
        return data.name == null ? hpText : data.name.copy().append(": ").append((Component)hpText);
    }

    public static List<Component> getDetail(GolemTracker.TrackedData data, Player player, long time) {
        ArrayList<Component> ans = new ArrayList<Component>();
        if (data.name != null) {
            ans.add(data.name);
        }
        float f = Mth.clamp((float)(data.hp / data.mhp), (float)0.0f, (float)1.0f);
        int color = Mth.hsvToRgb((float)(f / 3.0f), (float)1.0f, (float)0.5f);
        MutableComponent hc = Component.literal((String)("" + Math.round(data.hp))).setStyle(Style.EMPTY.withColor(color));
        ans.add((Component)MGLangData.HEALTH.get(hc, Math.round(data.mhp)).withStyle(data.hp <= 0.0f ? ChatFormatting.DARK_RED : ChatFormatting.DARK_AQUA));
        if (data.hp > 0.0f) {
            long diff = (time - data.timestamp) / 20L;
            ans.add((Component)(diff < 2L ? MGLangData.TRACKER_PRESENT.get(new Object[0]).withStyle(ChatFormatting.DARK_GREEN) : MGLangData.TRACKER_TIME.get(new Object[0]).withStyle(ChatFormatting.RED)));
        }
        boolean diffDim = !data.lastDim.equals((Object)player.level().dimension().location());
        BlockPos p = data.lastPos;
        boolean tooFar = diffDim || p.distSqr((Vec3i)player.blockPosition()) > 16384.0;
        ans.add((Component)MGLangData.TRACKER_DIM.get(data.lastDim.toString()).withStyle(diffDim ? ChatFormatting.RED : ChatFormatting.GRAY));
        ans.add((Component)MGLangData.TRACKER_POS.get(p.getX(), p.getY(), p.getZ()).withStyle(tooFar ? ChatFormatting.RED : ChatFormatting.GRAY));
        ans.add((Component)TrackerInfo.getStatusDesc(data));
        if (data.golemType != null) {
            IGolemPart[] parts = data.golemType.values();
            if (data.materials.size() == parts.length) {
                for (int i = 0; i < parts.length; ++i) {
                    ResourceLocation id = data.materials.get(i);
                    ans.add((Component)parts[i].getDesc(Component.translatable((String)("golem_material." + id.getNamespace() + "." + id.getPath())).withStyle(ChatFormatting.GOLD)));
                }
            }
        }
        return ans;
    }

    private static MutableComponent getStatusDesc(GolemTracker.TrackedData data) {
        return switch (data.status) {
            default -> throw new MatchException(null, null);
            case GolemTracker.Status.ALIVE -> MGLangData.TRACKER_ALIVE.get(new Object[0]).withStyle(ChatFormatting.GRAY);
            case GolemTracker.Status.RETRIEVED -> MGLangData.TRACKER_RETRIEVED.get(new Object[0]).withStyle(ChatFormatting.GRAY);
            case GolemTracker.Status.OTHER_RETRIEVED -> {
                if (data.cause == null) {
                    yield MGLangData.TRACKER_RETRIEVED.get(new Object[0]).withStyle(ChatFormatting.GRAY);
                }
                yield MGLangData.TRACKER_RETRIEVED_OTHER.get(data.cause).withStyle(ChatFormatting.GRAY);
            }
            case GolemTracker.Status.DEATH -> {
                if (data.cause == null) {
                    yield MGLangData.TRACKER_DIED.get(new Object[0]).withStyle(ChatFormatting.RED);
                }
                yield MGLangData.TRACKER_KILLED.get(data.cause).withStyle(ChatFormatting.RED);
            }
            case GolemTracker.Status.DEATH_RECYCLE -> data.cause == null ? MGLangData.TRACKER_RECYCLE_DIED.get(new Object[0]).withStyle(ChatFormatting.RED) : MGLangData.TRACKER_RECYCLE_KILLED.get(data.cause).withStyle(ChatFormatting.RED);
        };
    }
}

