/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.content.client.tracker;

import com.mojang.datafixers.util.Pair;
import dev.xkmc.l2serial.network.SimplePacketBase;
import dev.xkmc.l2tabs.tabs.contents.BaseTextScreen;
import dev.xkmc.l2tabs.tabs.core.ITabScreen;
import dev.xkmc.l2tabs.tabs.core.TabGroupData;
import dev.xkmc.l2tabs.tabs.core.TabManager;
import dev.xkmc.l2tabs.tabs.core.TabToken;
import dev.xkmc.l2tabs.tabs.inventory.InvTabData;
import dev.xkmc.modulargolems.content.capability.GolemConfigStorage;
import dev.xkmc.modulargolems.content.capability.GolemTracker;
import dev.xkmc.modulargolems.content.capability.TrackerDeleteToServer;
import dev.xkmc.modulargolems.content.capability.TrackerHeartBeatToServer;
import dev.xkmc.modulargolems.content.client.tracker.TrackerInfo;
import dev.xkmc.modulargolems.content.menu.registry.GolemTabRegistry;
import dev.xkmc.modulargolems.init.ModularGolems;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public abstract class GolemInfoScreen
extends BaseTextScreen
implements ITabScreen {
    private int page = 0;
    private int size = 0;
    private Button left;
    private Button right;
    private boolean leftAdded;
    private boolean rightAdded;
    private UUID delId = null;

    private static int linePerPage() {
        return 14;
    }

    protected GolemInfoScreen(Component title) {
        super(title, ResourceLocation.parse((String)"l2tabs:textures/gui/empty.png"));
    }

    public List<Pair<UUID, GolemTracker.TrackedData>> getData(Predicate<GolemTracker.TrackedData> status) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return List.of();
        }
        GolemTracker tracker = GolemConfigStorage.get(player.level()).getTracker(player.getUUID());
        ArrayList<Pair<UUID, GolemTracker.TrackedData>> ans = new ArrayList<Pair<UUID, GolemTracker.TrackedData>>();
        for (Map.Entry<UUID, GolemTracker.TrackedData> e2 : tracker.data.entrySet()) {
            if (!status.test(e2.getValue())) continue;
            ans.add((Pair<UUID, GolemTracker.TrackedData>)Pair.of((Object)e2.getKey(), (Object)e2.getValue()));
        }
        ans.sort(Comparator.comparingLong(e -> -((GolemTracker.TrackedData)e.getSecond()).timestamp));
        return ans;
    }

    public abstract List<Pair<UUID, GolemTracker.TrackedData>> getData();

    public void init() {
        super.init();
        int x = (this.width + this.imageWidth) / 2 - 16;
        int y = (this.height - this.imageHeight) / 2 + 4;
        int w = 10;
        int h = 11;
        this.left = Button.builder((Component)Component.literal((String)"<"), e -> this.click(-1)).pos(x - w - 1, y).size(w, h).build();
        this.right = Button.builder((Component)Component.literal((String)">"), e -> this.click(1)).pos(x, y).size(w, h).build();
        new TabManager((ITabScreen)this, (TabGroupData)new InvTabData()).init(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
        }, (TabToken)GolemTabRegistry.TRACKER.get());
    }

    private void click(int offset) {
        this.page += offset;
        if (this.page < 0) {
            this.page = 0;
        }
        if (this.page >= (this.size - 1) / GolemInfoScreen.linePerPage() + 1) {
            --this.page;
        }
    }

    public void render(GuiGraphics g, int mx, int my, float ptick) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        long time = player.level().getGameTime();
        List<Pair<UUID, GolemTracker.TrackedData>> data = this.getData();
        this.size = data.size();
        this.updateButtons();
        super.render(g, mx, my, ptick);
        int start = this.page * GolemInfoScreen.linePerPage();
        int max = Math.min((this.page + 1) * GolemInfoScreen.linePerPage(), this.size);
        int x = this.leftPos + 8;
        int y = this.topPos + 6;
        g.drawString(this.font, this.title, x, y, 0, false);
        y += 15;
        GolemTracker.TrackedData focus = null;
        int delLine = -1;
        this.delId = null;
        for (int i = 0; i < max - start; ++i) {
            Pair<UUID, GolemTracker.TrackedData> ent = data.get(start + i);
            Component comp = TrackerInfo.getDesc((GolemTracker.TrackedData)ent.getSecond());
            g.drawString(this.font, comp, x, y, 0, false);
            int w = Math.min(this.font.width((FormattedText)comp), this.imageWidth - 30);
            if (my > y && my < y + 10) {
                if (mx > x && mx < x + w) {
                    focus = (GolemTracker.TrackedData)ent.getSecond();
                } else if (mx > x + this.imageWidth - 20 && mx < x + this.imageWidth - 8) {
                    delLine = start + i;
                    this.delId = (UUID)ent.getFirst();
                }
            }
            MutableComponent del = Component.literal((String)"X").withStyle(delLine == start + i ? ChatFormatting.RED : ChatFormatting.BLACK);
            g.drawString(this.font, (Component)del, x + this.imageWidth - 20, y, 0, false);
            y += 10;
        }
        if (focus != null) {
            g.renderComponentTooltip(this.font, TrackerInfo.getDetail(focus, (Player)player, time), mx, my);
        }
    }

    public void tick() {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        if (player.level().getGameTime() % 10L == 0L) {
            ModularGolems.HANDLER.toServer((SimplePacketBase)new TrackerHeartBeatToServer(player.getUUID()));
        }
    }

    public boolean mouseClicked(double x, double y, int btn) {
        if (super.mouseClicked(x, y, btn)) {
            return true;
        }
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return false;
        }
        if (this.delId != null && btn == 0) {
            ModularGolems.HANDLER.toServer((SimplePacketBase)new TrackerDeleteToServer(player.getUUID(), this.delId));
            return true;
        }
        return false;
    }

    private void updateButtons() {
        int pageNum = (this.size - 1) / GolemInfoScreen.linePerPage() + 1;
        if (this.page > 0 && !this.leftAdded) {
            this.leftAdded = true;
            this.addRenderableWidget((GuiEventListener)this.left);
        }
        if (this.page <= 0 && this.leftAdded) {
            this.leftAdded = false;
            this.removeWidget((GuiEventListener)this.left);
        }
        if (this.page < pageNum - 1 && !this.rightAdded) {
            this.rightAdded = true;
            this.addRenderableWidget((GuiEventListener)this.right);
        }
        if (this.page >= pageNum - 1 && this.rightAdded) {
            this.rightAdded = false;
            this.removeWidget((GuiEventListener)this.right);
        }
    }

    public int getGuiLeft() {
        return this.leftPos;
    }

    public int getGuiTop() {
        return this.topPos;
    }

    public int screenWidth() {
        return this.width;
    }

    public int screenHeight() {
        return this.height;
    }

    public int getXSize() {
        return this.imageWidth;
    }

    public int getYSize() {
        return this.imageHeight;
    }
}

