/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.content.client.overlay;

import dev.xkmc.l2itemselector.overlay.OverlayUtil;
import dev.xkmc.l2itemselector.select.item.ItemSelectionOverlay;
import dev.xkmc.l2library.content.raytrace.IGlowingTarget;
import dev.xkmc.l2library.content.raytrace.RayTraceUtil;
import dev.xkmc.modulargolems.content.capability.GolemConfigEntry;
import dev.xkmc.modulargolems.content.entity.common.AbstractGolemEntity;
import dev.xkmc.modulargolems.content.entity.common.GolemFlags;
import dev.xkmc.modulargolems.content.entity.dog.DogGolemEntity;
import dev.xkmc.modulargolems.content.entity.humanoid.HumanoidGolemEntity;
import dev.xkmc.modulargolems.content.item.data.GolemUpgrade;
import dev.xkmc.modulargolems.content.item.wand.GolemInteractItem;
import dev.xkmc.modulargolems.content.modifier.base.GolemModifier;
import dev.xkmc.modulargolems.init.data.MGLangData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;

public class GolemStatusOverlay
implements LayeredDraw.Layer {
    public void render(GuiGraphics g, DeltaTracker delta) {
        HashMap<GolemModifier, Integer> modifiers;
        LivingEntity target;
        if (Minecraft.getInstance().screen != null) {
            return;
        }
        boolean offset = ItemSelectionOverlay.INSTANCE.isRendering();
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        Item item = player.getMainHandItem().getItem();
        if (!(item instanceof GolemInteractItem)) {
            return;
        }
        GolemInteractItem wand = (GolemInteractItem)item;
        if (wand instanceof IGlowingTarget) {
            target = RayTraceUtil.serverGetTarget((Player)player);
        } else {
            HitResult hit = Minecraft.getInstance().hitResult;
            if (!(hit instanceof EntityHitResult)) {
                return;
            }
            EntityHitResult entityHit = (EntityHitResult)hit;
            target = entityHit.getEntity();
        }
        if (!(target instanceof AbstractGolemEntity)) {
            return;
        }
        AbstractGolemEntity golem = (AbstractGolemEntity)target;
        if (golem.isHostile()) {
            return;
        }
        Font font = Minecraft.getInstance().font;
        int screenWidth = g.guiWidth();
        ArrayList<Object> text = new ArrayList<Object>();
        text.add(golem.getName());
        float health = golem.getHealth();
        float max = golem.getMaxHealth();
        float f = Mth.clamp((float)(health / max), (float)0.0f, (float)1.0f);
        int color = Mth.hsvToRgb((float)(f / 3.0f), (float)1.0f, (float)1.0f);
        MutableComponent hc = Component.literal((String)("" + Math.round(health))).setStyle(Style.EMPTY.withColor(color));
        text.add(MGLangData.HEALTH.get(hc, Math.round(max)).withStyle(health <= 0.0f ? ChatFormatting.RED : ChatFormatting.AQUA));
        if (golem.hasFlag(GolemFlags.BOTANIA)) {
            // empty if block
        }
        text.add(golem.getMode().getDesc(golem));
        GolemConfigEntry config = golem.getConfigEntry((Component)MGLangData.LOADING.get(new Object[0]));
        if (config != null) {
            config.clientTick(player.level(), false);
            text.add(config.getDisplayName());
            if (config.locked) {
                text.add(MGLangData.CONFIG_LOCK.get(new Object[0]).withStyle(ChatFormatting.RED));
            }
        }
        if ((modifiers = golem.getModifiers()).size() > 8) {
            GolemUpgrade upgrades = golem.getUpgrades();
            text.add(MGLangData.UPGRADE_COUNT.get(modifiers.size(), upgrades.size()));
        } else {
            modifiers.forEach((k, v) -> text.add(k.getTooltip((int)v)));
        }
        int textPos = offset ? Math.round((float)(screenWidth * 3) / 4.0f) : Math.round((float)screenWidth / 8.0f);
        new OverlayUtil(g, textPos, -1, -1).renderLongText(font, text);
        OverlayUtil util = new OverlayUtil(g, (int)((double)screenWidth * 0.6), -1, -1);
        util.bg = -3750202;
        List<GolemEquipmentTooltip> list = List.of(new GolemEquipmentTooltip(golem));
        util.renderTooltipInternal(font, list);
    }

    private record GolemEquipmentTooltip(AbstractGolemEntity<?, ?> golem) implements ClientTooltipComponent
    {
        public static final ResourceLocation TEXTURE_LOCATION = ResourceLocation.withDefaultNamespace((String)"container/bundle/slot");

        public int getHeight() {
            if (this.golem instanceof DogGolemEntity) {
                return 36;
            }
            return 72;
        }

        public int getWidth(Font pFont) {
            if (this.golem instanceof DogGolemEntity) {
                return 18;
            }
            return 36;
        }

        public void renderImage(Font font, int mx, int my, GuiGraphics g) {
            if (this.golem instanceof DogGolemEntity) {
                this.renderSlot(font, mx, my, g, this.golem.getItemBySlot(EquipmentSlot.HEAD), InventoryMenu.EMPTY_ARMOR_SLOT_HELMET);
                this.renderSlot(font, mx, my + 18, g, this.golem.getItemBySlot(EquipmentSlot.BODY), InventoryMenu.EMPTY_ARMOR_SLOT_CHESTPLATE);
                return;
            }
            this.renderSlot(font, mx + 18, my, g, this.golem.getItemBySlot(EquipmentSlot.HEAD), InventoryMenu.EMPTY_ARMOR_SLOT_HELMET);
            this.renderSlot(font, mx + 18, my + 18, g, this.golem.getItemBySlot(EquipmentSlot.CHEST), InventoryMenu.EMPTY_ARMOR_SLOT_CHESTPLATE);
            this.renderSlot(font, mx + 18, my + 36, g, this.golem.getItemBySlot(EquipmentSlot.LEGS), InventoryMenu.EMPTY_ARMOR_SLOT_LEGGINGS);
            this.renderSlot(font, mx + 18, my + 54, g, this.golem.getItemBySlot(EquipmentSlot.FEET), InventoryMenu.EMPTY_ARMOR_SLOT_BOOTS);
            AbstractGolemEntity<?, ?> abstractGolemEntity = this.golem;
            if (abstractGolemEntity instanceof HumanoidGolemEntity) {
                HumanoidGolemEntity h = (HumanoidGolemEntity)abstractGolemEntity;
                this.renderSlot(font, mx, my, g, this.golem.getItemBySlot(EquipmentSlot.MAINHAND), null);
                this.renderSlot(font, mx, my + 18, g, this.golem.getItemBySlot(EquipmentSlot.OFFHAND), InventoryMenu.EMPTY_ARMOR_SLOT_SHIELD);
                this.renderSlot(font, mx, my + 36, g, h.getBackupHand().getItem(), null);
                this.renderSlot(font, mx, my + 54, g, h.getArrowSlot().getItem(), null);
            } else {
                this.renderSlot(font, mx, my + 18, g, this.golem.getItemBySlot(EquipmentSlot.MAINHAND), null);
                this.renderSlot(font, mx, my + 36, g, this.golem.getItemBySlot(EquipmentSlot.OFFHAND), InventoryMenu.EMPTY_ARMOR_SLOT_SHIELD);
            }
        }

        private void renderSlot(Font font, int x, int y, GuiGraphics g, ItemStack stack, @Nullable ResourceLocation atlasID) {
            this.blit(g, x, y);
            if (stack.isEmpty()) {
                if (atlasID != null) {
                    TextureAtlasSprite atlas = (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(atlasID);
                    g.blit(x + 1, y + 1, 0, 16, 16, atlas);
                }
                return;
            }
            g.renderItem(stack, x + 1, y + 1, 0);
            g.renderItemDecorations(font, stack, x + 1, y + 1);
        }

        private void blit(GuiGraphics g, int x, int y) {
            g.blitSprite(TEXTURE_LOCATION, x, y, 18, 20);
        }
    }
}

