/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.content.client.outline;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;

public class BlockOutliner {
    private static Level world;
    private static int time;
    private static List<BlockPos> selection;

    public static void drawOutlines(Player player, List<BlockPos> list) {
        ClientLevel level = Minecraft.getInstance().level;
        if (level == null) {
            return;
        }
        if (Minecraft.getInstance().player != player) {
            return;
        }
        time = player.tickCount;
        selection = list;
        world = level;
    }

    public static void renderOutline(PoseStack pose, Vec3 camera) {
        ClientLevel level = Minecraft.getInstance().level;
        LocalPlayer player = Minecraft.getInstance().player;
        if (selection == null || level == null || player == null || level != world || time + 3 < player.tickCount) {
            selection = null;
            return;
        }
        MultiBufferSource.BufferSource buffer = Minecraft.getInstance().renderBuffers().bufferSource();
        VertexConsumer vc = buffer.getBuffer(RenderType.lines());
        BlockPos pre = null;
        BlockPos first = null;
        float time = ((float)level.getGameTime() + Minecraft.getInstance().getTimer().getRealtimeDeltaTicks()) / 40.0f % 1.0f;
        for (BlockPos pos : selection) {
            BlockOutliner.renderBox(pose, vc, pos, camera.toVector3f(), pre == null ? -8388737 : -8401440);
            if (pre != null) {
                BlockOutliner.line(pose, vc, pre, pos, camera.toVector3f(), time);
            } else {
                first = pos;
            }
            pre = pos;
        }
        if (pre != null) {
            BlockOutliner.line(pose, vc, pre, first, camera.toVector3f(), time);
        }
    }

    private static void line(PoseStack pose, VertexConsumer vc, BlockPos a, BlockPos b, Vector3f pos, float time) {
        Vec3 c0 = a.getCenter();
        Vec3 c1 = b.getCenter();
        int color = a.distSqr((Vec3i)b) < 256.0 ? -8401440 : -49345;
        Vec3 v1 = c0.lerp(c1, (double)time);
        Vec3 v0 = c0;
        if ((double)time >= 0.5) {
            v0 = c0.lerp(c1, (double)time - 0.5);
        }
        Vector3f p0 = v0.toVector3f();
        Vector3f p1 = v1.toVector3f();
        BlockOutliner.renderLine(pose, vc, p0.x, p0.y, p0.z, p1.x, p1.y, p1.z, pos, color);
        if ((double)time < 0.5) {
            v1 = c1;
            v0 = c0.lerp(c1, (double)time + 0.5);
            p0 = v0.toVector3f();
            p1 = v1.toVector3f();
            BlockOutliner.renderLine(pose, vc, p0.x, p0.y, p0.z, p1.x, p1.y, p1.z, pos, color);
        }
    }

    private static void renderBox(PoseStack pose, VertexConsumer vc, BlockPos box, Vector3f pos, int color) {
        float offset = 0.03125f;
        BlockOutliner.renderCube(pose, vc, (float)box.getX() + offset, (float)box.getY() + offset, (float)box.getZ() + offset, (float)(box.getX() + 1) - offset, (float)(box.getY() + 1) - offset, (float)(box.getZ() + 1) - offset, pos, color);
    }

    public static void renderCube(PoseStack pose, VertexConsumer vc, float x0, float y0, float z0, float x1, float y1, float z1, Vector3f pos, int color) {
        BlockOutliner.renderLine(pose, vc, x0, y0, z0, x1, y0, z0, pos, color);
        BlockOutliner.renderLine(pose, vc, x0, y0, z0, x0, y1, z0, pos, color);
        BlockOutliner.renderLine(pose, vc, x0, y0, z0, x0, y0, z1, pos, color);
        BlockOutliner.renderLine(pose, vc, x1, y0, z0, x1, y1, z0, pos, color);
        BlockOutliner.renderLine(pose, vc, x1, y0, z0, x1, y0, z1, pos, color);
        BlockOutliner.renderLine(pose, vc, x0, y1, z0, x1, y1, z0, pos, color);
        BlockOutliner.renderLine(pose, vc, x0, y1, z0, x0, y1, z1, pos, color);
        BlockOutliner.renderLine(pose, vc, x0, y0, z1, x1, y0, z1, pos, color);
        BlockOutliner.renderLine(pose, vc, x0, y0, z1, x0, y1, z1, pos, color);
        BlockOutliner.renderLine(pose, vc, x1, y1, z0, x1, y1, z1, pos, color);
        BlockOutliner.renderLine(pose, vc, x1, y0, z1, x1, y1, z1, pos, color);
        BlockOutliner.renderLine(pose, vc, x0, y1, z1, x1, y1, z1, pos, color);
    }

    private static void renderLine(PoseStack pose, VertexConsumer vc, float x0, float y0, float z0, float x1, float y1, float z1, Vector3f pos, int color) {
        PoseStack.Pose mat = pose.last();
        float rx = x1 - x0;
        float ry = y1 - y0;
        float rz = z1 - z0;
        float len = Mth.sqrt((float)(rx * rx + ry * ry + rz * rz));
        vc.addVertex(mat, x0 - pos.x, y0 - pos.y, z0 - pos.z).setColor(color).setNormal(mat, rx /= len, ry /= len, rz /= len);
        vc.addVertex(mat, x1 - pos.x, y1 - pos.y, z1 - pos.z).setColor(color).setNormal(mat, rx, ry, rz);
    }

    static {
        time = 0;
    }
}

