/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.content.client.armor;

import dev.xkmc.modulargolems.content.client.armor.GolemBoots;
import dev.xkmc.modulargolems.content.client.armor.HarbingerArmors;
import dev.xkmc.modulargolems.content.client.armor.MonstrosityArmors;
import dev.xkmc.modulargolems.init.ModularGolems;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;

public class GolemEquipmentModels {
    public static final List<ModelLayerLocation> LIST = new ArrayList<ModelLayerLocation>();
    public static final ModelLayerLocation HELMET_LAYER = new ModelLayerLocation(ModularGolems.loc("golem_helmet"), "main");
    public static final ModelLayerLocation CHESTPLATE_LAYER = new ModelLayerLocation(ModularGolems.loc("golem_chestplate"), "main");
    public static final ModelLayerLocation SHINGUARD_LAYER = new ModelLayerLocation(ModularGolems.loc("golem_shinguard"), "main");
    public static final ModelLayerLocation METALGOLEM = new ModelLayerLocation(ModularGolems.loc("metalgolem"), "model");
    public static final ModelLayerLocation HUMANOID = new ModelLayerLocation(ModularGolems.loc("humanoid"), "model");
    public static final ModelLayerLocation DOGGOLEM = new ModelLayerLocation(ModularGolems.loc("dog"), "model");

    public static MeshDefinition buildGolemBaseLayers() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition partdefinition = mesh.getRoot();
        partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -12.0f, -5.5f, 8.0f, 10.0f, 8.0f).texOffs(24, 0).addBox(-1.0f, -5.0f, -7.5f, 2.0f, 4.0f, 2.0f), PartPose.offset((float)0.0f, (float)-7.0f, (float)-2.0f));
        partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 40).addBox(-9.0f, -2.0f, -6.0f, 18.0f, 12.0f, 11.0f).texOffs(0, 70).addBox(-4.5f, 10.0f, -3.0f, 9.0f, 5.0f, 6.0f, new CubeDeformation(0.5f)), PartPose.offset((float)0.0f, (float)-7.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(60, 21).addBox(-13.0f, -2.5f, -3.0f, 4.0f, 14.0f, 6.0f), PartPose.offset((float)0.0f, (float)-7.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("left_arm", CubeListBuilder.create().texOffs(60, 58).addBox(9.0f, -2.5f, -3.0f, 4.0f, 14.0f, 6.0f), PartPose.offset((float)0.0f, (float)-7.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(37, 0).addBox(-3.5f, -3.0f, -3.0f, 6.0f, 16.0f, 5.0f), PartPose.offset((float)-4.0f, (float)11.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(60, 0).mirror().addBox(-3.5f, -3.0f, -3.0f, 6.0f, 16.0f, 5.0f), PartPose.offset((float)5.0f, (float)11.0f, (float)0.0f));
        PartDefinition root1 = mesh.getRoot().getChild("right_arm");
        root1.addOrReplaceChild("right_forearm", CubeListBuilder.create().texOffs(60, 35).addBox(-12.99f, 0.0f, -6.0f, 4.0f, 16.0f, 6.0f), PartPose.offsetAndRotation((float)0.0f, (float)11.5f, (float)3.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition root2 = mesh.getRoot().getChild("left_arm");
        root2.addOrReplaceChild("left_forearm", CubeListBuilder.create().texOffs(60, 72).addBox(8.99f, 0.0f, -6.0f, 4.0f, 16.0f, 6.0f), PartPose.offsetAndRotation((float)0.0f, (float)11.5f, (float)3.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        return mesh;
    }

    public static LayerDefinition createHelmetLayer() {
        MeshDefinition mesh = GolemEquipmentModels.buildGolemBaseLayers();
        PartDefinition root = mesh.getRoot().getChild("head");
        root.addOrReplaceChild("helmet3", CubeListBuilder.create().texOffs(0, 48).addBox(-4.0f, -44.0f, -8.0f, 9.0f, 12.0f, 9.0f, new CubeDeformation(0.0f)).texOffs(76, 39).addBox(-4.5f, -37.0f, -6.25f, 10.0f, 5.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-0.5f, (float)31.0f, (float)2.0f));
        root.addOrReplaceChild("helmet17", CubeListBuilder.create().texOffs(48, 105).addBox(-5.5f, 28.0f, 0.0f, 9.0f, 12.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-5.5f, (float)-43.0f, (float)-1.5f, (float)0.0f, (float)0.8727f, (float)0.0f));
        root.addOrReplaceChild("helmet16", CubeListBuilder.create().texOffs(108, 52).addBox(-3.5f, 28.0f, 0.0f, 9.0f, 12.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)5.5f, (float)-43.0f, (float)-1.5f, (float)0.0f, (float)-0.8727f, (float)0.0f));
        root.addOrReplaceChild("helmet15", CubeListBuilder.create(), PartPose.offsetAndRotation((float)0.5f, (float)-36.0f, (float)-5.25f, (float)0.4363f, (float)0.0f, (float)0.0f));
        root.addOrReplaceChild("helmet8", CubeListBuilder.create(), PartPose.offsetAndRotation((float)1.0f, (float)0.0f, (float)-2.0f, (float)0.0f, (float)0.3491f, (float)0.0f));
        root.addOrReplaceChild("helmet9", CubeListBuilder.create().texOffs(50, 0).addBox(2.0f, 28.0f, -2.0f, 6.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-4.5f, (float)-40.5f, (float)-3.5f, (float)0.0f, (float)0.0f, (float)0.2182f));
        root.addOrReplaceChild("helmet10", CubeListBuilder.create().texOffs(70, 39).addBox(13.0f, 24.5f, 0.5f, 4.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-7.8669f, (float)-41.8411f, (float)-3.5f, (float)0.0f, (float)0.1309f, (float)0.5672f));
        root.addOrReplaceChild("helmet11", CubeListBuilder.create().texOffs(0, 0).addBox(-17.0f, -4.5f, -5.5f, 4.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.384f, (float)-0.549f, (float)0.0f, (float)0.0f, (float)0.0873f, (float)0.7418f));
        root.addOrReplaceChild("helmet4", CubeListBuilder.create(), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)-2.0f, (float)0.0f, (float)-0.3491f, (float)0.0f));
        root.addOrReplaceChild("helmet6", CubeListBuilder.create().texOffs(105, 14).addBox(-8.0f, 28.0f, -2.0f, 6.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)4.5f, (float)-40.5f, (float)-3.5f, (float)0.0f, (float)0.0f, (float)-0.2182f));
        root.addOrReplaceChild("helmet5", CubeListBuilder.create().texOffs(73, 18).addBox(-16.0f, 24.5f, 0.5f, 4.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)7.8669f, (float)-41.8411f, (float)-3.5f, (float)0.0f, (float)-0.1309f, (float)-0.5672f));
        root.addOrReplaceChild("helmet7", CubeListBuilder.create().texOffs(0, 5).addBox(14.0f, -4.5f, -5.5f, 4.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)2.384f, (float)-0.549f, (float)0.0f, (float)0.0f, (float)-0.0873f, (float)-0.7418f));
        root.addOrReplaceChild("helmet", CubeListBuilder.create().texOffs(58, 12).addBox(-1.0f, -49.0f, -6.0f, 1.0f, 14.0f, 13.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)31.0f, (float)2.0f));
        return LayerDefinition.create((MeshDefinition)mesh, (int)128, (int)128);
    }

    public static LayerDefinition createChestplateLayer() {
        MeshDefinition mesh = GolemEquipmentModels.buildGolemBaseLayers();
        PartDefinition root = mesh.getRoot().getChild("body");
        root.addOrReplaceChild("main_body", CubeListBuilder.create().texOffs(0, 0).addBox(-9.5f, 4.5f, -6.6f, 19.0f, 13.0f, 12.0f, new CubeDeformation(0.0f)).texOffs(19, 110).addBox(5.5f, 3.5f, -7.75f, 2.0f, 8.0f, 7.0f, new CubeDeformation(0.0f)).texOffs(105, 28).addBox(-7.5f, 3.5f, -7.75f, 2.0f, 8.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-7.0f, (float)0.0f));
        PartDefinition root_ra1 = mesh.getRoot().getChild("right_arm");
        PartDefinition root_rfa = mesh.getRoot().getChild("right_arm").getChild("right_forearm");
        root_ra1.addOrReplaceChild("main_rightarm1", CubeListBuilder.create().texOffs(0, 83).addBox(-14.5f, -33.5f, -3.5f, 6.0f, 10.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)31.0f, (float)0.0f));
        root_rfa.addOrReplaceChild("main_rightforearm", CubeListBuilder.create().texOffs(89, 104).addBox(-13.0f, -29.5f, -6.5f, 4.01f, 7.0f, 7.0f, new CubeDeformation(0.0f)).texOffs(0, 111).addBox(-17.0f, -32.75f, -3.5f, 5.0f, 12.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)31.0f, (float)0.0f));
        root_ra1.addOrReplaceChild("main_rightarm2", CubeListBuilder.create().texOffs(90, 65).addBox(27.75f, 8.75f, -5.0f, 7.0f, 3.0f, 8.0f, new CubeDeformation(0.0f)).texOffs(76, 52).addBox(27.0f, 4.75f, -5.5f, 7.0f, 4.0f, 9.0f, new CubeDeformation(0.0f)).texOffs(65, 67).addBox(26.25f, 2.75f, -6.5f, 7.0f, 3.0f, 11.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-11.75f, (float)-31.75f, (float)1.0f, (float)0.0f, (float)0.0f, (float)1.3526f));
        PartDefinition root_la1 = mesh.getRoot().getChild("left_arm");
        PartDefinition root_lfa = mesh.getRoot().getChild("left_arm").getChild("left_forearm");
        root_la1.addOrReplaceChild("main_leftarm1", CubeListBuilder.create().texOffs(86, 18).addBox(8.75f, -33.5f, -3.5f, 6.0f, 10.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)31.0f, (float)0.0f));
        root_la1.addOrReplaceChild("main_leftarm2", CubeListBuilder.create().texOffs(96, 82).addBox(-34.5f, 8.75f, -5.0f, 7.0f, 3.0f, 8.0f, new CubeDeformation(0.0f)).texOffs(47, 81).addBox(-33.75f, 4.75f, -5.5f, 7.0f, 4.0f, 9.0f, new CubeDeformation(0.0f)).texOffs(0, 69).addBox(-33.0f, 2.75f, -6.5f, 7.0f, 3.0f, 11.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)11.75f, (float)-31.75f, (float)1.0f, (float)0.0f, (float)0.0f, (float)-1.3526f));
        root_lfa.addOrReplaceChild("main_leftforearm", CubeListBuilder.create().texOffs(105, 0).addBox(8.98f, -29.5f, -6.5f, 4.01f, 7.0f, 7.0f, new CubeDeformation(0.0f)).texOffs(68, 111).addBox(11.75f, -32.75f, -3.5f, 5.0f, 12.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)31.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)mesh, (int)128, (int)128);
    }

    public static LayerDefinition createShinGuard() {
        MeshDefinition mesh = GolemEquipmentModels.buildGolemBaseLayers();
        PartDefinition root1 = mesh.getRoot().getChild("body");
        root1.addOrReplaceChild("main_shinguard", CubeListBuilder.create().texOffs(70, 81).addBox(-5.0f, 19.0f, -3.5f, 10.0f, 2.0f, 7.0f, new CubeDeformation(0.5f)), PartPose.offset((float)0.0f, (float)-7.0f, (float)0.0f));
        PartDefinition root2 = mesh.getRoot().getChild("right_leg");
        root2.addOrReplaceChild("shinguard1", CubeListBuilder.create().texOffs(48, 94).addBox(0.0f, -9.0f, -3.5f, 7.0f, 5.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-4.0f, (float)11.0f, (float)0.0f));
        PartDefinition root3 = mesh.getRoot().getChild("left_leg");
        root3.addOrReplaceChild("shinguard2", CubeListBuilder.create().texOffs(0, 100).addBox(-9.0f, -9.0f, -3.5f, 7.0f, 5.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)5.0f, (float)11.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)mesh, (int)128, (int)128);
    }

    public static LayerDefinition createGolemLayer() {
        MeshDefinition mesh = GolemEquipmentModels.buildGolemBaseLayers();
        return LayerDefinition.create((MeshDefinition)mesh, (int)128, (int)128);
    }

    public static MeshDefinition createPlayerMesh(CubeDeformation p_170826_, boolean p_170827_) {
        MeshDefinition meshdefinition = HumanoidModel.createMesh((CubeDeformation)p_170826_, (float)0.0f);
        PartDefinition partdefinition = meshdefinition.getRoot();
        partdefinition.addOrReplaceChild("ear", CubeListBuilder.create().texOffs(24, 0).addBox(-3.0f, -6.0f, -1.0f, 6.0f, 6.0f, 1.0f, p_170826_), PartPose.ZERO);
        partdefinition.addOrReplaceChild("cloak", CubeListBuilder.create().texOffs(0, 0).addBox(-5.0f, 0.0f, -1.0f, 10.0f, 16.0f, 1.0f, p_170826_, 1.0f, 0.5f), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        float f = 0.25f;
        if (p_170827_) {
            partdefinition.addOrReplaceChild("left_arm", CubeListBuilder.create().texOffs(32, 48).addBox(-1.0f, -2.0f, -2.0f, 3.0f, 12.0f, 4.0f, p_170826_), PartPose.offset((float)5.0f, (float)2.5f, (float)0.0f));
            partdefinition.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(40, 16).addBox(-2.0f, -2.0f, -2.0f, 3.0f, 12.0f, 4.0f, p_170826_), PartPose.offset((float)-5.0f, (float)2.5f, (float)0.0f));
            partdefinition.addOrReplaceChild("left_sleeve", CubeListBuilder.create().texOffs(48, 48).addBox(-1.0f, -2.0f, -2.0f, 3.0f, 12.0f, 4.0f, p_170826_.extend(0.25f)), PartPose.offset((float)5.0f, (float)2.5f, (float)0.0f));
            partdefinition.addOrReplaceChild("right_sleeve", CubeListBuilder.create().texOffs(40, 32).addBox(-2.0f, -2.0f, -2.0f, 3.0f, 12.0f, 4.0f, p_170826_.extend(0.25f)), PartPose.offset((float)-5.0f, (float)2.5f, (float)0.0f));
        } else {
            partdefinition.addOrReplaceChild("left_arm", CubeListBuilder.create().texOffs(32, 48).addBox(-1.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, p_170826_), PartPose.offset((float)5.0f, (float)2.0f, (float)0.0f));
            partdefinition.addOrReplaceChild("left_sleeve", CubeListBuilder.create().texOffs(48, 48).addBox(-1.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, p_170826_.extend(0.25f)), PartPose.offset((float)5.0f, (float)2.0f, (float)0.0f));
            partdefinition.addOrReplaceChild("right_sleeve", CubeListBuilder.create().texOffs(40, 32).addBox(-3.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, p_170826_.extend(0.25f)), PartPose.offset((float)-5.0f, (float)2.0f, (float)0.0f));
        }
        partdefinition.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(16, 48).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, p_170826_), PartPose.offset((float)1.9f, (float)12.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("left_pants", CubeListBuilder.create().texOffs(0, 48).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, p_170826_.extend(0.25f)), PartPose.offset((float)1.9f, (float)12.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("right_pants", CubeListBuilder.create().texOffs(0, 32).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, p_170826_.extend(0.25f)), PartPose.offset((float)-1.9f, (float)12.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("jacket", CubeListBuilder.create().texOffs(16, 32).addBox(-4.0f, 0.0f, -2.0f, 8.0f, 12.0f, 4.0f, p_170826_.extend(0.25f)), PartPose.ZERO);
        return meshdefinition;
    }

    public static LayerDefinition createHumanoidLayer() {
        return LayerDefinition.create((MeshDefinition)GolemEquipmentModels.createPlayerMesh(CubeDeformation.NONE, false), (int)64, (int)64);
    }

    public static LayerDefinition createDogLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        float f = 13.5f;
        PartDefinition partdefinition1 = partdefinition.addOrReplaceChild("head", CubeListBuilder.create(), PartPose.offset((float)-1.0f, (float)13.5f, (float)-7.0f));
        partdefinition1.addOrReplaceChild("real_head", CubeListBuilder.create().texOffs(0, 0).addBox(-2.0f, -3.0f, -2.0f, 6.0f, 6.0f, 4.0f).texOffs(16, 14).addBox(-2.0f, -5.0f, 0.0f, 2.0f, 2.0f, 1.0f).texOffs(16, 14).addBox(2.0f, -5.0f, 0.0f, 2.0f, 2.0f, 1.0f).texOffs(0, 10).addBox(-0.5f, -0.001f, -5.0f, 3.0f, 3.0f, 4.0f), PartPose.ZERO);
        partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(18, 14).addBox(-3.0f, -2.0f, -3.0f, 6.0f, 9.0f, 6.0f), PartPose.offsetAndRotation((float)0.0f, (float)14.0f, (float)2.0f, (float)1.5707964f, (float)0.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("upper_body", CubeListBuilder.create().texOffs(21, 0).addBox(-3.0f, -3.0f, -3.0f, 8.0f, 6.0f, 7.0f), PartPose.offsetAndRotation((float)-1.0f, (float)14.0f, (float)-3.0f, (float)1.5707964f, (float)0.0f, (float)0.0f));
        CubeListBuilder cubelistbuilder = CubeListBuilder.create().texOffs(0, 18).addBox(0.0f, 0.0f, -1.0f, 2.0f, 8.0f, 2.0f);
        partdefinition.addOrReplaceChild("right_hind_leg", cubelistbuilder, PartPose.offset((float)-2.5f, (float)16.0f, (float)7.0f));
        partdefinition.addOrReplaceChild("left_hind_leg", cubelistbuilder, PartPose.offset((float)0.5f, (float)16.0f, (float)7.0f));
        partdefinition.addOrReplaceChild("right_front_leg", cubelistbuilder, PartPose.offset((float)-2.5f, (float)16.0f, (float)-4.0f));
        partdefinition.addOrReplaceChild("left_front_leg", cubelistbuilder, PartPose.offset((float)0.5f, (float)16.0f, (float)-4.0f));
        PartDefinition partdefinition2 = partdefinition.addOrReplaceChild("tail", CubeListBuilder.create(), PartPose.offsetAndRotation((float)-1.0f, (float)12.0f, (float)8.0f, (float)0.62831855f, (float)0.0f, (float)0.0f));
        partdefinition2.addOrReplaceChild("real_tail", CubeListBuilder.create().texOffs(9, 18).addBox(0.0f, 0.0f, -1.0f, 2.0f, 8.0f, 2.0f), PartPose.ZERO);
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)32);
    }

    public static void registerArmorLayer(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(METALGOLEM, GolemEquipmentModels::createGolemLayer);
        event.registerLayerDefinition(HUMANOID, GolemEquipmentModels::createHumanoidLayer);
        event.registerLayerDefinition(DOGGOLEM, GolemEquipmentModels::createDogLayer);
        GolemEquipmentModels.regAndAdd(event, HELMET_LAYER, GolemEquipmentModels::createHelmetLayer);
        GolemEquipmentModels.regAndAdd(event, CHESTPLATE_LAYER, GolemEquipmentModels::createChestplateLayer);
        GolemEquipmentModels.regAndAdd(event, SHINGUARD_LAYER, GolemEquipmentModels::createShinGuard);
        GolemEquipmentModels.regAndAdd(event, GolemBoots.DIAMOND_BOOTS_LAYER, GolemBoots::createDiamondBoots);
        GolemEquipmentModels.regAndAdd(event, GolemBoots.NETHERITE_BOOTS_LAYER, GolemBoots::createNetheriteBoots);
        GolemEquipmentModels.regAndAdd(event, HarbingerArmors.HELMET_LAYER, HarbingerArmors::createHelmet);
        GolemEquipmentModels.regAndAdd(event, HarbingerArmors.CHESTPLATE_LAYER, HarbingerArmors::createChestplate);
        GolemEquipmentModels.regAndAdd(event, HarbingerArmors.SHINGUARD_LAYER, HarbingerArmors::createLeggings);
        GolemEquipmentModels.regAndAdd(event, MonstrosityArmors.HELMET_LAYER, MonstrosityArmors::createHelmet);
        GolemEquipmentModels.regAndAdd(event, MonstrosityArmors.CHESTPLATE_LAYER, MonstrosityArmors::createChestplate);
        GolemEquipmentModels.regAndAdd(event, MonstrosityArmors.SHINGUARD_LAYER, MonstrosityArmors::createLeggings);
    }

    public static synchronized void regAndAdd(EntityRenderersEvent.RegisterLayerDefinitions event, ModelLayerLocation layer, Supplier<LayerDefinition> factory) {
        event.registerLayerDefinition(layer, factory);
        LIST.add(layer);
    }
}

