/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.content.capability;

import dev.xkmc.l2serial.serialization.marker.SerialClass;
import dev.xkmc.l2serial.serialization.marker.SerialField;
import dev.xkmc.modulargolems.content.item.card.ClickEntityFilterCard;
import dev.xkmc.modulargolems.content.item.card.NameFilterCard;
import dev.xkmc.modulargolems.content.item.card.TargetFilterCard;
import dev.xkmc.modulargolems.content.item.card.UuidFilterCard;
import dev.xkmc.modulargolems.init.registrate.GolemItems;
import java.util.ArrayList;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

@SerialClass
public class TargetFilterConfig {
    public static final int LINE = 18;
    @SerialField
    protected final ArrayList<ItemStack> hostileTo = new ArrayList();
    @SerialField
    protected final ArrayList<ItemStack> friendlyTo = new ArrayList();

    public boolean internalMatch(ArrayList<ItemStack> list, ItemStack stack) {
        for (ItemStack filter : list) {
            if (stack.getItem() != filter.getItem() || !ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)filter)) continue;
            return true;
        }
        return false;
    }

    public boolean aggressiveToward(LivingEntity le) {
        TargetFilterCard card;
        Item item;
        for (ItemStack e : this.friendlyTo) {
            item = e.getItem();
            if (!(item instanceof UuidFilterCard) || !((ClickEntityFilterCard)(card = (UuidFilterCard)item)).mayTarget(e).test(le)) continue;
            return false;
        }
        for (ItemStack e : this.hostileTo) {
            item = e.getItem();
            if (!(item instanceof TargetFilterCard) || !(card = (TargetFilterCard)item).mayTarget(e).test(le)) continue;
            return true;
        }
        return false;
    }

    public boolean friendlyToward(LivingEntity le) {
        TargetFilterCard card;
        Item item;
        for (ItemStack e : this.hostileTo) {
            item = e.getItem();
            if (!(item instanceof UuidFilterCard) || !((ClickEntityFilterCard)(card = (UuidFilterCard)item)).mayTarget(e).test(le)) continue;
            return false;
        }
        for (ItemStack e : this.friendlyTo) {
            item = e.getItem();
            if (!(item instanceof TargetFilterCard) || !(card = (TargetFilterCard)item).mayTarget(e).test(le)) continue;
            return true;
        }
        return false;
    }

    public void initDefault() {
        this.resetHostile();
        this.resetFriendly();
    }

    public void resetHostile() {
        this.hostileTo.clear();
        this.hostileTo.add(GolemItems.CARD_DEF.asStack());
    }

    public void resetFriendly() {
        this.friendlyTo.clear();
        this.friendlyTo.add(NameFilterCard.getFriendly());
    }
}

