/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.content.capability;

import dev.xkmc.l2serial.serialization.marker.SerialClass;
import dev.xkmc.l2serial.serialization.marker.SerialField;
import dev.xkmc.modulargolems.content.config.GolemMaterial;
import dev.xkmc.modulargolems.content.core.GolemType;
import dev.xkmc.modulargolems.content.entity.common.AbstractGolemEntity;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.Nullable;

@SerialClass
public class GolemTracker {
    @SerialField
    public final LinkedHashMap<UUID, TrackedData> data = new LinkedHashMap();

    public void track(AbstractGolemEntity<?, ?> e) {
        if (!e.isAddedToLevel()) {
            return;
        }
        if (e.isDeadOrDying()) {
            return;
        }
        this.data.computeIfAbsent(e.getUUID(), k -> new TrackedData()).update(e);
    }

    public void trackPos(UUID id, double x, double y, double z) {
        TrackedData rec = this.data.get(id);
        if (rec != null) {
            rec.updatePos(x, y, z);
        }
    }

    public boolean isUntracked(AbstractGolemEntity<?, ?> e) {
        TrackedData rec = this.data.get(e.getUUID());
        if (rec == null) {
            return true;
        }
        return rec.status != Status.ALIVE;
    }

    public void untrack(AbstractGolemEntity<?, ?> e, Status type, @Nullable Entity cause) {
        this.data.computeIfAbsent(e.getUUID(), k -> new TrackedData()).untrack(e, type, cause);
    }

    @SerialClass
    public static class TrackedData {
        @SerialField
        public Status status = Status.ALIVE;
        @SerialField
        public ResourceLocation lastDim;
        @SerialField
        public BlockPos lastPos;
        @SerialField
        public long timestamp;
        @SerialField
        public Component name;
        @SerialField
        public Component cause;
        @SerialField
        public float mhp;
        @SerialField
        public float hp;
        @SerialField
        public GolemType<?, ?> golemType;
        @SerialField
        public List<ResourceLocation> materials = new ArrayList<ResourceLocation>();

        public void update(AbstractGolemEntity<?, ?> e) {
            this.status = Status.ALIVE;
            this.lastDim = e.level().dimension().location();
            this.lastPos = e.blockPosition();
            this.timestamp = e.level().getGameTime();
            this.cause = null;
            this.mhp = e.getMaxHealth();
            this.hp = e.getHealth();
            if (this.name == null || e.tickCount % 20 == 10) {
                this.name = e.getName();
                this.golemType = GolemType.getGolemType(e.getType());
                this.materials.clear();
                for (GolemMaterial m : e.getMaterials()) {
                    this.materials.add(m.id());
                }
            }
        }

        public void updatePos(double x, double y, double z) {
            this.lastPos = BlockPos.containing((double)x, (double)y, (double)z);
        }

        public void untrack(AbstractGolemEntity<?, ?> e, Status type, @Nullable Entity cause) {
            if (this.lastDim == null) {
                this.update(e);
            }
            this.status = type;
            this.hp = e.getHealth();
            if (cause != null) {
                this.cause = cause.getName();
            }
        }
    }

    public static enum Status {
        ALIVE,
        RETRIEVED,
        OTHER_RETRIEVED,
        DEATH,
        DEATH_RECYCLE;


        public boolean isDeath() {
            return this == DEATH || this == DEATH_RECYCLE;
        }
    }
}

