/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.content.capability;

import dev.xkmc.l2core.capability.level.BaseSavedData;
import dev.xkmc.l2serial.serialization.codec.TagCodec;
import dev.xkmc.l2serial.serialization.marker.SerialClass;
import dev.xkmc.l2serial.serialization.marker.SerialField;
import dev.xkmc.modulargolems.content.capability.GolemConfigEntry;
import dev.xkmc.modulargolems.content.capability.GolemTracker;
import java.util.HashMap;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;

@SerialClass
public class GolemConfigStorage
extends BaseSavedData<GolemConfigStorage> {
    private static final String ID = "modulargolem_configcards";
    private static final SavedData.Factory<GolemConfigStorage> FACTORY = new SavedData.Factory(GolemConfigStorage::new, GolemConfigStorage::new);
    private static GolemConfigStorage CLIENT;
    private Level level;
    @SerialField
    private final HashMap<UUID, GolemConfigEntry[]> storage = new HashMap();
    @SerialField
    private final HashMap<UUID, GolemTracker> tracker = new HashMap();

    public static GolemConfigStorage get(Level level) {
        if (level instanceof ServerLevel) {
            ServerLevel sl = (ServerLevel)level;
            GolemConfigStorage ans = (GolemConfigStorage)sl.getDataStorage().computeIfAbsent(FACTORY, ID);
            ans.level = sl;
            return ans;
        }
        if (CLIENT == null || GolemConfigStorage.CLIENT.level != level) {
            CLIENT = new GolemConfigStorage();
            GolemConfigStorage.CLIENT.level = level;
        }
        return CLIENT;
    }

    public GolemConfigStorage() {
        super(GolemConfigStorage.class);
    }

    public GolemConfigStorage(CompoundTag tag, HolderLookup.Provider pvd) {
        this();
        new TagCodec(pvd).fromTag(tag, GolemConfigStorage.class, (Object)this);
    }

    public GolemConfigEntry getOrCreateStorage(UUID id, int color, Component comp) {
        GolemConfigEntry[] entries = this.storage.computeIfAbsent(id, k -> new GolemConfigEntry[16]);
        if (entries[color &= 0xF] == null) {
            entries[color] = GolemConfigEntry.getDefault(id, color, comp);
        }
        return entries[color].init(id, color);
    }

    public GolemTracker getTracker(UUID id) {
        return this.tracker.computeIfAbsent(id, k -> new GolemTracker());
    }

    @Nullable
    public GolemConfigEntry getStorage(UUID id, int color) {
        if (color < 0 || color > 15) {
            return null;
        }
        GolemConfigEntry[] entries = this.storage.computeIfAbsent(id, k -> new GolemConfigEntry[16]);
        GolemConfigEntry ans = entries[color];
        if (ans == null) {
            return null;
        }
        ans.init(id, color);
        return ans;
    }

    public void replaceStorage(GolemConfigEntry entry) {
        GolemConfigEntry[] entries = this.storage.computeIfAbsent(entry.getID(), k -> new GolemConfigEntry[16]);
        entries[entry.getColor()] = entry.copyFrom(entries[entry.getColor()]);
    }

    public void replaceTracker(UUID id, GolemTracker data) {
        this.tracker.put(id, data);
    }

    public void init() {
    }
}

