/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.content.capability;

import dev.xkmc.l2serial.network.SimplePacketBase;
import dev.xkmc.l2serial.serialization.marker.SerialClass;
import dev.xkmc.l2serial.serialization.marker.SerialField;
import dev.xkmc.modulargolems.content.capability.ConfigSyncToClient;
import dev.xkmc.modulargolems.content.capability.ConfigUpdateToServer;
import dev.xkmc.modulargolems.content.capability.PathConfig;
import dev.xkmc.modulargolems.content.capability.PickupFilterConfig;
import dev.xkmc.modulargolems.content.capability.SquadConfig;
import dev.xkmc.modulargolems.content.capability.SyncContainer;
import dev.xkmc.modulargolems.content.capability.TargetFilterConfig;
import dev.xkmc.modulargolems.init.ModularGolems;
import java.util.UUID;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

@SerialClass
public class GolemConfigEntry {
    public final SyncContainer sync = new SyncContainer();
    private UUID id;
    private int color;
    @SerialField
    private Component name;
    @SerialField
    public int defaultMode;
    @SerialField
    public boolean summonToPosition;
    @SerialField
    public boolean locked;
    @SerialField
    public PickupFilterConfig pickupFilter = new PickupFilterConfig();
    @SerialField
    public TargetFilterConfig targetFilter = new TargetFilterConfig();
    @SerialField
    public SquadConfig squadConfig = new SquadConfig();
    @SerialField
    public PathConfig pathConfig = new PathConfig();

    public static GolemConfigEntry getDefault(UUID id, int color, Component name) {
        return new GolemConfigEntry(name).init(id, color);
    }

    @Deprecated
    public GolemConfigEntry() {
    }

    private GolemConfigEntry(Component comp) {
        this.name = comp;
        this.targetFilter.initDefault();
    }

    public Component getDisplayName() {
        if (this.name == null) {
            this.name = Component.literal((String)"Unnamed");
        }
        return this.name;
    }

    public GolemConfigEntry init(UUID id, int color) {
        this.id = id;
        this.color = color;
        return this;
    }

    public void heartBeat(ServerLevel level, ServerPlayer player) {
        if (this.sync.heartBeat(level, player.getUUID())) {
            ModularGolems.HANDLER.toClientPlayer((SimplePacketBase)ConfigSyncToClient.of(this), player);
        }
    }

    public UUID getID() {
        return this.id;
    }

    public int getColor() {
        return this.color;
    }

    public void clientTick(Level level, boolean updated) {
        this.sync.clientTick(this, level, updated);
    }

    public void sync(Level level) {
        if (level instanceof ServerLevel) {
            ServerLevel sl = (ServerLevel)level;
            this.sync.sendToAllTracking(sl, ConfigSyncToClient.of(this));
        } else {
            ModularGolems.HANDLER.toServer((SimplePacketBase)ConfigUpdateToServer.of(level, this));
        }
    }

    public GolemConfigEntry copyFrom(@Nullable GolemConfigEntry entry) {
        if (entry != null) {
            this.sync.clientReplace(entry.sync);
        }
        return this;
    }

    public void setName(Component hoverName, ServerLevel level) {
        this.name = hoverName;
        this.sync((Level)level);
    }
}

