/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.content.capability;

import dev.xkmc.l2core.util.Proxy;
import dev.xkmc.modulargolems.content.capability.GolemConfigEntry;
import dev.xkmc.modulargolems.content.capability.GolemConfigStorage;
import dev.xkmc.modulargolems.content.capability.PathEditor;
import dev.xkmc.modulargolems.content.capability.PickupFilterEditor;
import dev.xkmc.modulargolems.content.capability.SquadEditor;
import dev.xkmc.modulargolems.content.capability.TargetFilterEditor;
import dev.xkmc.modulargolems.content.entity.mode.GolemMode;
import dev.xkmc.modulargolems.content.entity.mode.GolemModes;
import dev.xkmc.modulargolems.init.data.MGLangData;
import java.util.UUID;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.Level;

public interface GolemConfigEditor {
    public static GolemConfigEditor readable(UUID id, int color) {
        return new Readable(Proxy.getLevel(), id, color);
    }

    public Level level();

    public GolemConfigEntry entry();

    default public Component getDisplayName() {
        return this.entry().getDisplayName();
    }

    default public GolemMode getDefaultMode() {
        return GolemModes.get(this.entry().defaultMode);
    }

    default public void setDefaultMode(GolemMode mode) {
        this.entry().defaultMode = mode.getID();
        this.sync();
    }

    default public boolean summonToPosition() {
        return this.entry().summonToPosition;
    }

    default public void setSummonToPosition(boolean bool) {
        this.entry().summonToPosition = bool;
        this.sync();
    }

    default public boolean locked() {
        return this.entry().locked;
    }

    default public void setLocked(boolean lock) {
        this.entry().locked = lock;
        this.sync();
    }

    default public void sync() {
        this.entry().sync(this.level());
    }

    default public PickupFilterEditor getFilter() {
        return new PickupFilterEditor(this);
    }

    default public TargetFilterEditor target() {
        return new TargetFilterEditor(this);
    }

    default public SquadEditor getSquad() {
        return new SquadEditor(this);
    }

    default public PathEditor getPath() {
        return new PathEditor(this);
    }

    public record Readable(Level level, UUID id, int color) implements GolemConfigEditor
    {
        @Override
        public GolemConfigEntry entry() {
            return GolemConfigStorage.get(this.level).getOrCreateStorage(this.id, this.color, (Component)MGLangData.LOADING.get(new Object[0]));
        }
    }

    public record Writable(Level level, GolemConfigEntry entry) implements GolemConfigEditor
    {
    }
}

