/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.compat.musket;

import dev.xkmc.mob_weapon_api.api.goals.IWeaponGoal;
import dev.xkmc.modulargolems.compat.musket.RangedGunAttackGoal;
import dev.xkmc.modulargolems.content.entity.humanoid.HumanoidGolemEntity;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.ItemStack;

public class GolemMusketGoal
extends RangedGunAttackGoal<HumanoidGolemEntity>
implements IWeaponGoal<HumanoidGolemEntity> {
    private static final double speedModifier = 1.0;
    private static final float attackRadius = 15.0f;
    private int seeTime;
    private int attackDelay;
    private boolean strafingClockwise;
    private boolean strafingBackwards;
    private int strafingTime = -1;

    public GolemMusketGoal(HumanoidGolemEntity mob) {
        super(mob);
    }

    public boolean canContinueToUse() {
        return (this.isTargetValid() || !((HumanoidGolemEntity)this.mob).getNavigation().isDone()) && this.canUseGun();
    }

    public double range(ItemStack stack) {
        return 15.0;
    }

    public void start() {
        super.start();
        ((HumanoidGolemEntity)this.mob).setAggressive(true);
        ((HumanoidGolemEntity)this.mob).setInRangeAttack(true);
    }

    @Override
    public void stop() {
        super.stop();
        this.seeTime = 0;
        this.attackDelay = 0;
        ((HumanoidGolemEntity)this.mob).setInRangeAttack(false);
    }

    @Override
    public void tick() {
        super.tick();
        LivingEntity target = ((HumanoidGolemEntity)this.mob).getTarget();
        if (target != null) {
            boolean wasSeeing;
            boolean canSee = ((HumanoidGolemEntity)this.mob).getSensing().hasLineOfSight((Entity)target);
            boolean bl = wasSeeing = this.seeTime > 0;
            if (canSee != wasSeeing) {
                this.seeTime = 0;
            }
            this.seeTime = canSee ? ++this.seeTime : --this.seeTime;
            float dist = ((HumanoidGolemEntity)this.mob).distanceTo((Entity)target);
            if (dist < 15.0f && this.seeTime >= 20) {
                ((HumanoidGolemEntity)this.mob).getNavigation().stop();
                ++this.strafingTime;
            } else {
                ((HumanoidGolemEntity)this.mob).getNavigation().moveTo((Entity)target, 1.0);
                this.strafingTime = -1;
            }
            if (this.strafingTime >= 20) {
                if (((HumanoidGolemEntity)this.mob).getRandom().nextFloat() < 0.3f) {
                    boolean bl2 = this.strafingClockwise = !this.strafingClockwise;
                }
                if (((HumanoidGolemEntity)this.mob).getRandom().nextFloat() < 0.3f) {
                    this.strafingBackwards = !this.strafingBackwards;
                }
                this.strafingTime = 0;
            }
            if (this.strafingTime > -1) {
                if ((double)dist > 11.25) {
                    this.strafingBackwards = false;
                } else if ((double)dist < 3.75) {
                    this.strafingBackwards = true;
                }
                ((HumanoidGolemEntity)this.mob).getMoveControl().strafe(this.strafingBackwards ? -0.5f : 0.5f, this.strafingClockwise ? 0.5f : -0.5f);
                Entity var6 = ((HumanoidGolemEntity)this.mob).getControlledVehicle();
                if (var6 instanceof Mob) {
                    Mob vehicle = (Mob)var6;
                    vehicle.lookAt((Entity)target, 30.0f, 30.0f);
                }
                ((HumanoidGolemEntity)this.mob).lookAt((Entity)target, 30.0f, 30.0f);
            } else {
                ((HumanoidGolemEntity)this.mob).getLookControl().setLookAt((Entity)target, 30.0f, 30.0f);
            }
            if (this.seeTime < -60) {
                this.attackDelay = Math.max(20, this.attackDelay);
            }
            if (this.attackDelay > 0) {
                --this.attackDelay;
            } else if (this.isReady()) {
                if (canSee) {
                    this.fire(0.0f);
                    this.attackDelay = 10;
                }
            } else {
                this.reload();
            }
        }
    }

    @Override
    public void onReady() {
        this.attackDelay = Math.max(20, this.attackDelay);
    }
}

