/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.compat.materials.twilightforest;

import dev.xkmc.l2damagetracker.contents.attack.DamageData;
import dev.xkmc.modulargolems.content.core.StatFilterType;
import dev.xkmc.modulargolems.content.entity.common.AbstractGolemEntity;
import dev.xkmc.modulargolems.content.modifier.base.GolemModifier;
import dev.xkmc.modulargolems.init.data.MGConfig;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;

public class CarminiteModifier
extends GolemModifier {
    public CarminiteModifier() {
        super(StatFilterType.MASS, 5);
    }

    @Override
    public void onDamaged(AbstractGolemEntity<?, ?> entity, DamageData.Defence event, int level) {
        int time = (Integer)MGConfig.COMMON.carminiteTime.get() * level;
        entity.addEffect(new MobEffectInstance(MobEffects.DAMAGE_RESISTANCE, time, 4), (Entity)entity);
        entity.addEffect(new MobEffectInstance(MobEffects.INVISIBILITY, time), (Entity)entity);
    }

    @Override
    public List<MutableComponent> getDetail(int level) {
        double time = (double)((Integer)MGConfig.COMMON.carminiteTime.get() * level) / 20.0;
        return List.of(Component.translatable((String)(this.getDescriptionId() + ".desc"), (Object[])new Object[]{time}).withStyle(ChatFormatting.GREEN));
    }

    @Override
    public boolean onAttacked(AbstractGolemEntity<?, ?> entity, DamageData.Attack event, int level) {
        if (event.getSource().is(DamageTypeTags.BYPASSES_INVULNERABILITY) || event.getSource().is(DamageTypeTags.BYPASSES_EFFECTS)) {
            return false;
        }
        MobEffectInstance eff = entity.getEffect(MobEffects.DAMAGE_RESISTANCE);
        return eff != null && eff.getAmplifier() >= 4;
    }
}

