/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.compat.materials.l2hostility;

import dev.xkmc.l2damagetracker.contents.attack.DamageData;
import dev.xkmc.l2damagetracker.contents.attack.DamageModifier;
import dev.xkmc.l2hostility.content.capability.mob.CapStorageData;
import dev.xkmc.l2hostility.content.traits.common.AdaptingTrait;
import dev.xkmc.l2hostility.init.data.LHConfig;
import dev.xkmc.l2hostility.init.registrate.LHTraits;
import dev.xkmc.l2serial.serialization.codec.TagCodec;
import dev.xkmc.l2serial.serialization.marker.SerialClass;
import dev.xkmc.l2serial.serialization.marker.SerialField;
import dev.xkmc.modulargolems.content.core.StatFilterType;
import dev.xkmc.modulargolems.content.entity.common.AbstractGolemEntity;
import dev.xkmc.modulargolems.content.modifier.base.GolemModifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.DamageTypeTags;

public class AdaptiveModifier
extends GolemModifier {
    private static final String KEY = "LHGolemAdaptiveData";

    public AdaptiveModifier() {
        super(StatFilterType.HEALTH, 4);
    }

    @Override
    public void onDamaged(AbstractGolemEntity<?, ?> entity, DamageData.Defence event, int level) {
        String id;
        if (event.getSource().is(DamageTypeTags.BYPASSES_INVULNERABILITY) || event.getSource().is(DamageTypeTags.BYPASSES_EFFECTS)) {
            return;
        }
        CompoundTag root = entity.getPersistentData();
        Data data = new Data();
        TagCodec codec = new TagCodec((HolderLookup.Provider)entity.registryAccess());
        if (root.contains(KEY, 10) && (data = (Data)((Object)codec.fromTag(root.getCompound(KEY), Data.class))) == null) {
            data = new Data();
        }
        if (data.memory.contains(id = event.getSource().getMsgId())) {
            data.memory.remove(id);
            data.memory.addFirst(id);
            int val = data.adaption.compute(id, (k, oldx) -> oldx == null ? 1 : oldx + 1);
            double factor = Math.pow((Double)LHConfig.SERVER.adaptFactor.get(), val - 1);
            event.addDealtModifier(DamageModifier.multTotal((float)((float)factor), (ResourceLocation)this.getRegistryName()));
        } else {
            data.memory.addFirst(id);
            data.adaption.put(id, 1);
            if (data.memory.size() > level) {
                String old = data.memory.removeLast();
                data.adaption.remove(old);
            }
        }
        CompoundTag ans = codec.toTag(new CompoundTag(), (Object)data);
        if (ans != null) {
            root.put(KEY, (Tag)ans);
        }
    }

    @Override
    public List<MutableComponent> getDetail(int v) {
        ArrayList<MutableComponent> ans = new ArrayList<MutableComponent>();
        ans.add(Component.translatable((String)(((AdaptingTrait)LHTraits.ADAPTIVE.get()).getDescriptionId() + ".desc"), (Object[])new Object[]{Component.literal((String)("" + (int)Math.round(100.0 * (1.0 - (Double)LHConfig.SERVER.adaptFactor.get())))).withStyle(ChatFormatting.AQUA), Component.literal((String)("" + v)).withStyle(ChatFormatting.AQUA)}).withStyle(ChatFormatting.GREEN));
        return ans;
    }

    @SerialClass
    public static class Data
    extends CapStorageData {
        @SerialField
        public final ArrayList<String> memory = new ArrayList();
        @SerialField
        public final HashMap<String, Integer> adaption = new HashMap();
    }
}

