/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.compat.materials.l2complements;

import com.tterrag.registrate.util.entry.ItemEntry;
import dev.xkmc.l2complements.init.registrate.LCEffects;
import dev.xkmc.l2core.init.reg.simple.Val;
import dev.xkmc.modulargolems.compat.materials.l2complements.CleanseModifier;
import dev.xkmc.modulargolems.compat.materials.l2complements.ConduitModifier;
import dev.xkmc.modulargolems.compat.materials.l2complements.EnderTeleportModifier;
import dev.xkmc.modulargolems.compat.materials.l2complements.FreezingModifier;
import dev.xkmc.modulargolems.compat.materials.l2complements.SoulFlameModifier;
import dev.xkmc.modulargolems.content.core.StatFilterType;
import dev.xkmc.modulargolems.content.item.upgrade.SimpleUpgradeItem;
import dev.xkmc.modulargolems.content.modifier.base.PotionAttackModifier;
import dev.xkmc.modulargolems.content.modifier.base.TargetBonusModifier;
import dev.xkmc.modulargolems.init.data.MGTagGen;
import dev.xkmc.modulargolems.init.registrate.GolemItems;
import dev.xkmc.modulargolems.init.registrate.GolemModifiers;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.world.effect.MobEffectInstance;

public class LCCompatRegistry {
    public static final Val<ConduitModifier> CONDUIT = GolemModifiers.reg("conduit", ConduitModifier::new, "When in water: Reduce damage taken to %s%%. Every %s seconds, deal %s conduit damage to target in water/rain remotely. Boost following stats:");
    public static final Val<FreezingModifier> FREEZE = GolemModifiers.reg("freezing", FreezingModifier::new, "Potion Upgrade: Freezing", "Get Ice Blade and Ice Thorn enchantment effects. Immune to freezing damage.");
    public static final Val<SoulFlameModifier> FLAME = GolemModifiers.reg("soul_flame", SoulFlameModifier::new, "Potion Upgrade: Soul Flame", "Get Soul Flame Blade and Soul Flame Thorn enchantment effects. Immune to soul flame damage.");
    public static final Val<EnderTeleportModifier> TELEPORT = GolemModifiers.reg("teleport", EnderTeleportModifier::new, "Teleport randomly to avoid physical damage. Teleport toward target when attacking. Teleport has %ss cool down.");
    public static final Val<PotionAttackModifier> CURSE = GolemModifiers.reg("curse", () -> new PotionAttackModifier(StatFilterType.MASS, 3, i -> new MobEffectInstance(LCEffects.CURSE.holder(), 60 * i)), "Potion Upgrade: Curse", null);
    public static final Val<PotionAttackModifier> INCARCERATE = GolemModifiers.reg("incarcerate", () -> new PotionAttackModifier(StatFilterType.MASS, 3, i -> new MobEffectInstance(LCEffects.INCARCERATE.holder(), 20 * i)), "Potion Upgrade: Incarceration", null);
    public static final Val<CleanseModifier> CLEANSE;
    public static final Val<TargetBonusModifier> POSEIDITE;
    public static final Val<TargetBonusModifier> TOTEMIC_GOLD;
    public static final ItemEntry<SimpleUpgradeItem> FORCE_FIELD;
    public static final ItemEntry<SimpleUpgradeItem> FREEZE_UP;
    public static final ItemEntry<SimpleUpgradeItem> FLAME_UP;
    public static final ItemEntry<SimpleUpgradeItem> TELEPORT_UP;
    public static final ItemEntry<SimpleUpgradeItem> ATK_UP;
    public static final ItemEntry<SimpleUpgradeItem> SPEED_UP;
    public static final ItemEntry<SimpleUpgradeItem> UPGRADE_CURSE;
    public static final ItemEntry<SimpleUpgradeItem> UPGRADE_INCARCERATE;
    public static final ItemEntry<SimpleUpgradeItem> UPGRADE_CLEANSE;

    public static void register() {
        MGTagGen.OPTIONAL_ITEM.add(e -> e.addTag(MGTagGen.POTION_UPGRADES).addOptional(FLAME_UP.getId()).addOptional(FREEZE_UP.getId()).addOptional(UPGRADE_CURSE.getId()).addOptional(UPGRADE_INCARCERATE.getId()));
        MGTagGen.OPTIONAL_ITEM.add(e -> e.addTag(MGTagGen.BLUE_UPGRADES).addOptional(UPGRADE_CLEANSE.getId()));
    }

    static {
        POSEIDITE = GolemModifiers.reg("poseidite", () -> new TargetBonusModifier(e -> e.isSensitiveToWater() || e.getType().is(EntityTypeTags.SENSITIVE_TO_IMPALING)), "Deal %s%% more damage to mobs sensitive to water or water based mobs");
        TOTEMIC_GOLD = GolemModifiers.reg("totemic_gold", () -> new TargetBonusModifier(e -> e.getType().is(EntityTypeTags.SENSITIVE_TO_SMITE)), "Deal %s%% more damage to undead mobs");
        CLEANSE = GolemModifiers.reg("cleanse", CleanseModifier::new, "Potion Upgrade: Cleanse", null);
        FORCE_FIELD = GolemItems.regModUpgrade("force_field", () -> GolemModifiers.PROJECTILE_REJECT, "l2complements").lang("Wither Armor Upgrade").register();
        FREEZE_UP = GolemItems.regModUpgrade("freezing", () -> FREEZE, "l2complements").lang("Potion Upgrade: Freezing").register();
        FLAME_UP = GolemItems.regModUpgrade("soul_flame", () -> FLAME, "l2complements").lang("Potion Upgrade: Soul Flame").register();
        TELEPORT_UP = GolemItems.regModUpgrade("teleport", () -> TELEPORT, "l2complements").lang("Teleport Upgrade").register();
        ATK_UP = GolemItems.regModUpgrade("attack_high", () -> GolemModifiers.DAMAGE, 5, true, "l2complements").lang("Attack Upgrade V").register();
        SPEED_UP = GolemItems.regModUpgrade("speed_high", () -> GolemModifiers.SPEED, 5, true, "l2complements").lang("Speed Upgrade V").register();
        UPGRADE_CURSE = GolemItems.regModUpgrade("curse", () -> CURSE, "l2complements").lang("Potion Upgrade: Curse").register();
        UPGRADE_INCARCERATE = GolemItems.regModUpgrade("incarcerate", () -> INCARCERATE, "l2complements").lang("Potion Upgrade: Incarceration").register();
        UPGRADE_CLEANSE = GolemItems.regModUpgrade("cleanse", () -> CLEANSE, "l2complements").lang("Potion Upgrade: Cleanse").register();
    }
}

