/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.compat.materials.l2complements;

import dev.xkmc.l2damagetracker.contents.attack.DamageData;
import dev.xkmc.modulargolems.compat.materials.l2complements.EnderTeleportGoal;
import dev.xkmc.modulargolems.content.core.StatFilterType;
import dev.xkmc.modulargolems.content.entity.common.AbstractGolemEntity;
import dev.xkmc.modulargolems.content.modifier.base.GolemModifier;
import dev.xkmc.modulargolems.init.data.MGConfig;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.event.entity.EntityTeleportEvent;

public class EnderTeleportModifier
extends GolemModifier {
    private static final String KEY = "modulargolems:teleport";

    public EnderTeleportModifier() {
        super(StatFilterType.HEALTH, 1);
    }

    @Override
    public List<MutableComponent> getDetail(int v) {
        int seconds = (Integer)MGConfig.COMMON.teleportCooldown.get() / 20;
        return List.of(Component.translatable((String)(this.getDescriptionId() + ".desc"), (Object[])new Object[]{seconds}).withStyle(ChatFormatting.GREEN));
    }

    @Override
    public void onRegisterGoals(AbstractGolemEntity<?, ?> entity, int lv, BiConsumer<Integer, Goal> addGoal) {
        addGoal.accept(10, new EnderTeleportGoal(entity));
    }

    @Override
    public boolean onAttacked(AbstractGolemEntity<?, ?> entity, DamageData.Attack event, int level) {
        if (event.getSource().is(Tags.DamageTypes.IS_MAGIC)) {
            return false;
        }
        if (event.getSource().is(DamageTypeTags.IS_PROJECTILE)) {
            for (int i = 0; i < 16; ++i) {
                if (!EnderTeleportModifier.teleport(entity)) continue;
                EnderTeleportModifier.resetCooldown(entity);
                return true;
            }
            return true;
        }
        if (!EnderTeleportModifier.mayTeleport(entity)) {
            return false;
        }
        for (int i = 0; i < 16; ++i) {
            if (!EnderTeleportModifier.teleport(entity)) continue;
            EnderTeleportModifier.resetCooldown(entity);
            return true;
        }
        return false;
    }

    public static boolean mayTeleport(AbstractGolemEntity<?, ?> entity) {
        long time = entity.getPersistentData().getLong(KEY);
        long current = entity.level().getGameTime();
        return current < time || current >= time + (long)((Integer)MGConfig.COMMON.teleportCooldown.get()).intValue();
    }

    public static void resetCooldown(AbstractGolemEntity<?, ?> entity) {
        entity.getPersistentData().putLong(KEY, entity.level().getGameTime());
    }

    public static boolean teleportTowards(AbstractGolemEntity<?, ?> entity, Entity pTarget) {
        return EnderTeleportModifier.teleport(entity, pTarget.getX(), pTarget.getY(), pTarget.getZ());
    }

    private static boolean teleport(AbstractGolemEntity<?, ?> entity) {
        int r = (Integer)MGConfig.COMMON.teleportRadius.get();
        if (!entity.level().isClientSide() && entity.isAlive()) {
            double d0 = entity.getX() + (entity.getRandom().nextDouble() - 0.5) * (double)r * 2.0;
            double d1 = entity.getY() + (double)(entity.getRandom().nextInt(r * 2) - r);
            double d2 = entity.getZ() + (entity.getRandom().nextDouble() - 0.5) * (double)r * 2.0;
            return EnderTeleportModifier.teleport(entity, d0, d1, d2);
        }
        return false;
    }

    public static boolean teleport(AbstractGolemEntity<?, ?> entity, double pX, double pY, double pZ) {
        BlockPos.MutableBlockPos ipos = new BlockPos.MutableBlockPos(pX, pY, pZ);
        while (ipos.getY() > entity.level().getMinBuildHeight() && !entity.level().getBlockState((BlockPos)ipos).blocksMotion()) {
            ipos.move(Direction.DOWN);
        }
        BlockState blockstate = entity.level().getBlockState((BlockPos)ipos);
        boolean flag = blockstate.blocksMotion();
        boolean flag1 = blockstate.getFluidState().is(FluidTags.WATER);
        if (flag && !flag1) {
            EntityTeleportEvent.EnderEntity event = EventHooks.onEnderTeleport(entity, (double)pX, (double)pY, (double)pZ);
            if (event.isCanceled()) {
                return false;
            }
            Vec3 vec3 = entity.position();
            boolean flag2 = entity.randomTeleport(event.getTargetX(), event.getTargetY(), event.getTargetZ(), true);
            if (flag2) {
                entity.level().gameEvent((Holder)GameEvent.TELEPORT, vec3, GameEvent.Context.of(entity));
                if (!entity.isSilent()) {
                    entity.level().playSound(null, entity.xo, entity.yo, entity.zo, SoundEvents.ENDERMAN_TELEPORT, entity.getSoundSource(), 1.0f, 1.0f);
                    entity.playSound(SoundEvents.ENDERMAN_TELEPORT, 1.0f, 1.0f);
                }
            }
            return flag2;
        }
        return false;
    }
}

