/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.compat.materials.l2complements;

import dev.xkmc.modulargolems.compat.materials.l2complements.EnderTeleportModifier;
import dev.xkmc.modulargolems.content.entity.common.AbstractGolemEntity;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;

public class EnderTeleportGoal
extends Goal {
    private static final int INIT_CD = 20;
    private static final int SUCCESS_CD = 100;
    private static final int FAIL_CD = 20;
    private static final int DIST = 6;
    private final AbstractGolemEntity<?, ?> entity;
    private int coolDown = 0;

    public EnderTeleportGoal(AbstractGolemEntity<?, ?> entity) {
        this.entity = entity;
    }

    public boolean canUse() {
        return this.entity.getTarget() != null && !this.entity.getNavigation().isDone() && (this.entity.getNavigation().isStuck() || this.entity.distanceToSqr((Entity)this.entity.getTarget()) > 36.0);
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    public void start() {
        this.coolDown = 20;
    }

    public void stop() {
        this.coolDown = 0;
    }

    public void tick() {
        LivingEntity target;
        if (this.coolDown > 0) {
            --this.coolDown;
        }
        if ((target = this.entity.getTarget()) == null) {
            return;
        }
        if (!EnderTeleportModifier.mayTeleport(this.entity)) {
            return;
        }
        if (this.coolDown <= 0) {
            if (EnderTeleportModifier.teleportTowards(this.entity, (Entity)target)) {
                EnderTeleportModifier.resetCooldown(this.entity);
                this.coolDown = 100;
            } else {
                this.coolDown = 20;
            }
        }
    }
}

