/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.compat.materials.iceandfire.proxy;

import com.iafenvoy.iceandfire.config.IafCommonConfig;
import com.iafenvoy.iceandfire.data.component.IafEntityData;
import com.iafenvoy.iceandfire.entity.EntityFireDragon;
import com.iafenvoy.iceandfire.entity.EntityIceDragon;
import com.iafenvoy.iceandfire.registry.IafItems;
import dev.xkmc.modulargolems.compat.materials.iceandfire.proxy.IAFProxy;
import java.util.function.Supplier;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;

public class IAFProxyCE
implements IAFProxy {
    @Override
    public void fireHit(LivingEntity target, LivingEntity user, int level) {
        if (((Boolean)IafCommonConfig.INSTANCE.tools.dragonFireAbility.getValue()).booleanValue()) {
            if (target instanceof EntityIceDragon) {
                target.hurt(user.level().damageSources().inFire(), 3.5f + (float)(5 * level));
            }
            target.setRemainingFireTicks(100 * level);
            target.knockback(1.0, user.getX() - target.getX(), user.getZ() - target.getZ());
        }
    }

    @Override
    public void iceHit(LivingEntity target, LivingEntity user, int level) {
        if (((Boolean)IafCommonConfig.INSTANCE.tools.dragonIceAbility.getValue()).booleanValue()) {
            if (target instanceof EntityFireDragon) {
                target.hurt(user.level().damageSources().drown(), 3.5f + (float)(5 * level));
            }
            IafEntityData data = IafEntityData.get((LivingEntity)target);
            data.frozenData.setFrozen(target, 100 * level);
            target.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 100, level));
            target.addEffect(new MobEffectInstance(MobEffects.DIG_SLOWDOWN, 100, level));
            target.knockback(1.0, user.getX() - target.getX(), user.getZ() - target.getZ());
        }
    }

    @Override
    public void lightningHit(LivingEntity target, LivingEntity user, int level) {
        if (((Boolean)IafCommonConfig.INSTANCE.tools.dragonLightningAbility.getValue()).booleanValue()) {
            boolean flag;
            boolean bl = flag = !(user instanceof Player) || !((double)user.attackAnim > 0.2);
            if (!user.level().isClientSide && flag) {
                LightningBolt lightningboltentity = (LightningBolt)EntityType.LIGHTNING_BOLT.create(target.level());
                assert (lightningboltentity != null);
                lightningboltentity.getTags().add("iceandfire.bolt_skip_loot");
                lightningboltentity.getTags().add(user.getStringUUID());
                lightningboltentity.addTag("l2library:safe_lightning");
                lightningboltentity.setDamage((float)(3 + 2 * level));
                lightningboltentity.moveTo(target.position());
                if (!target.level().isClientSide) {
                    target.level().addFreshEntity((Entity)lightningboltentity);
                }
            }
            if (target instanceof EntityFireDragon || target instanceof EntityIceDragon) {
                target.hurt(user.level().damageSources().lightningBolt(), 1.5f + (float)(4 * level));
            }
            target.knockback(1.0, user.getX() - target.getX(), user.getZ() - target.getZ());
        }
    }

    @Override
    public String modid() {
        return "iceandfire";
    }

    @Override
    public Supplier<Item> ingotIceSteel() {
        return IafItems.DRAGONSTEEL_ICE_INGOT;
    }

    @Override
    public Supplier<Item> ingotFireSteel() {
        return IafItems.DRAGONSTEEL_FIRE_INGOT;
    }

    @Override
    public Supplier<Item> ingotLightningSteel() {
        return IafItems.DRAGONSTEEL_LIGHTNING_INGOT;
    }
}

