/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.compat.materials.create.automation;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllItems;
import com.simibubi.create.AllTags;
import com.simibubi.create.content.kinetics.deployer.DeployerApplicationRecipe;
import com.simibubi.create.content.kinetics.press.PressingRecipe;
import com.tterrag.registrate.providers.RegistrateRecipeProvider;
import dev.xkmc.modulargolems.compat.materials.common.CompatManager;
import dev.xkmc.modulargolems.compat.materials.create.automation.ConditionalSARecipeBuilder;
import dev.xkmc.modulargolems.content.item.golem.GolemPart;
import dev.xkmc.modulargolems.init.ModularGolems;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.conditions.ModLoadedCondition;

public class CreateGolemRecipeGen {
    private static final Set<String> SPECIAL = Set.of("andesite_alloy", "brass", "railway");

    public static void genAllUpgradeRecipes(RegistrateRecipeProvider pvd) {
        Map<ResourceLocation, Ingredient> ing = CompatManager.gatherConfig();
        for (GolemPart<?, ?> part : GolemPart.LIST) {
            for (Map.Entry<ResourceLocation, Ingredient> ent : ing.entrySet()) {
                if (SPECIAL.contains(ent.getKey().getPath())) continue;
                CreateGolemRecipeGen.genAssembly(pvd, part, ent.getKey(), ent.getValue(), new ItemLike[0]);
            }
        }
        CreateGolemRecipeGen.genSpecialRecipes(pvd);
    }

    public static void genSpecialRecipes(RegistrateRecipeProvider pvd) {
        for (GolemPart<?, ?> part : GolemPart.LIST) {
            CreateGolemRecipeGen.genAssembly(pvd, part, ResourceLocation.fromNamespaceAndPath((String)"create", (String)"andesite_alloy"), (ItemLike)AllItems.ANDESITE_ALLOY, new ItemLike[]{AllBlocks.COGWHEEL});
            CreateGolemRecipeGen.genAssembly(pvd, part, ResourceLocation.fromNamespaceAndPath((String)"create", (String)"brass"), Ingredient.of((TagKey)AllTags.commonItemTag((String)"ingots/brass")), new ItemLike[]{AllItems.PRECISION_MECHANISM});
            CreateGolemRecipeGen.genAssembly(pvd, part, ResourceLocation.fromNamespaceAndPath((String)"create", (String)"railway"), Ingredient.of((TagKey)AllTags.commonItemTag((String)"plates/brass")), new ItemLike[]{AllItems.PRECISION_MECHANISM, AllItems.ELECTRON_TUBE, AllItems.STURDY_SHEET});
        }
    }

    private static void genAssembly(RegistrateRecipeProvider pvd, GolemPart<?, ?> part, ResourceLocation id, ItemLike ingredient, ItemLike ... parts) {
        CreateGolemRecipeGen.genAssembly(pvd, part, id, Ingredient.of((ItemLike[])new ItemLike[]{ingredient}), parts);
    }

    private static void genAssembly(RegistrateRecipeProvider pvd, GolemPart<?, ?> part, ResourceLocation id, Ingredient ingredient, ItemLike ... parts) {
        ResourceLocation part_rl = BuiltInRegistries.ITEM.getKey(part);
        String item_name = part_rl.getPath();
        ConditionalSARecipeBuilder recipe = new ConditionalSARecipeBuilder(ModularGolems.loc(id.getPath() + "_assemble_" + item_name));
        Item incomplete = (Item)BuiltInRegistries.ITEM.get(part_rl.withPrefix("incomplete_"));
        recipe.require((ItemLike)part).transitionTo((ItemLike)incomplete);
        recipe.addStep(DeployerApplicationRecipe::new, e -> e.require(ingredient));
        if (parts.length == 0) {
            for (int i = 0; i < 3; ++i) {
                recipe.addStep(PressingRecipe::new, e -> e);
            }
        } else {
            recipe.addStep(PressingRecipe::new, e -> e);
            for (ItemLike p : parts) {
                recipe.addStep(DeployerApplicationRecipe::new, e -> e.require(p));
            }
            recipe.addStep(DeployerApplicationRecipe::new, e -> e.require((ItemLike)AllItems.WRENCH).toolNotConsumed());
        }
        recipe.loops(part.count);
        String modid = id.getNamespace();
        recipe.withCondition((ICondition)new ModLoadedCondition("create"));
        if (!modid.equals("modulargolems") && !modid.equals("create")) {
            recipe.withCondition((ICondition)new ModLoadedCondition(modid));
        }
        recipe.addOutput(GolemPart.setMaterial(part.getDefaultInstance(), id), 1.0f);
        recipe.build((RecipeOutput)pvd);
    }
}

