/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.compat.materials.create;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllItems;
import com.tterrag.registrate.builders.NoConfigBuilder;
import com.tterrag.registrate.util.entry.ItemEntry;
import com.tterrag.registrate.util.nullness.NonNullSupplier;
import dev.xkmc.l2complements.init.data.LCTagGen;
import dev.xkmc.l2core.init.reg.registrate.SimpleEntry;
import dev.xkmc.l2core.init.reg.simple.Val;
import dev.xkmc.modulargolems.compat.materials.create.automation.DummyFurnace;
import dev.xkmc.modulargolems.compat.materials.create.modifier.CoatingModifier;
import dev.xkmc.modulargolems.compat.materials.create.modifier.MechBodyModifier;
import dev.xkmc.modulargolems.compat.materials.create.modifier.MechForceEffect;
import dev.xkmc.modulargolems.compat.materials.create.modifier.MechForceModifier;
import dev.xkmc.modulargolems.compat.materials.create.modifier.MechMobileEffect;
import dev.xkmc.modulargolems.compat.materials.create.modifier.MechMobileModifier;
import dev.xkmc.modulargolems.content.core.GolemStatType;
import dev.xkmc.modulargolems.content.item.upgrade.SimpleUpgradeItem;
import dev.xkmc.modulargolems.content.modifier.base.AttributeGolemModifier;
import dev.xkmc.modulargolems.init.ModularGolems;
import dev.xkmc.modulargolems.init.data.MGTagGen;
import dev.xkmc.modulargolems.init.registrate.GolemItems;
import dev.xkmc.modulargolems.init.registrate.GolemModifiers;
import dev.xkmc.modulargolems.init.registrate.GolemTypes;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.neoforged.fml.ModList;

public class CreateCompatRegistry {
    public static final Val<CoatingModifier> COATING = GolemModifiers.reg("coating", CoatingModifier::new, "Reduce damage taken by %s");
    public static final Val<AttributeGolemModifier> PUSH = GolemModifiers.reg("push", () -> new AttributeGolemModifier(1, new AttributeGolemModifier.AttrEntry((Supplier<GolemStatType>)GolemTypes.STAT_ATKKB, () -> 1.0)));
    public static final Val<MechBodyModifier> BODY = GolemModifiers.reg("mechanical_engine", MechBodyModifier::new, "Consumes fuels to power the golem up.");
    public static final Val<MechMobileModifier> MOBILE = GolemModifiers.reg("mechanical_mobility", MechMobileModifier::new, "When burning fuels, increase speed by %s%%");
    public static final Val<MechForceModifier> FORCE = GolemModifiers.reg("mechanical_force", MechForceModifier::new, "When burning fuels, increase attack damage by %s%%");
    public static final SimpleEntry<MobEffect> EFF_MOBILE;
    public static final SimpleEntry<MobEffect> EFF_FORCE;
    public static final ItemEntry<SimpleUpgradeItem> UP_COATING;
    public static final ItemEntry<SimpleUpgradeItem> UP_PUSH;
    public static final ItemEntry<DummyFurnace> DUMMY;

    private static <T extends MobEffect> SimpleEntry<MobEffect> genEffect(String name, NonNullSupplier<T> sup, String desc) {
        return new SimpleEntry(((NoConfigBuilder)ModularGolems.REGISTRATE.effect(name, sup, desc).lang(MobEffect::getDescriptionId)).register());
    }

    public static void register() {
        MGTagGen.OPTIONAL_ITEM.add(e -> e.addTag(MGTagGen.SPECIAL_CRAFT).addOptional(AllItems.CARDBOARD.getId()).addOptional(AllItems.ANDESITE_ALLOY.getId()).addOptionalTag(ResourceLocation.fromNamespaceAndPath((String)"c", (String)"ingots/brass")).addOptional(AllBlocks.RAILWAY_CASING.getId()));
        if (ModList.get().isLoaded("l2complements")) {
            MGTagGen.OPTIONAL_EFF.add(e -> e.addTag(LCTagGen.SKILL_EFFECT).addOptional(EFF_MOBILE.val().getId()).addOptional(EFF_FORCE.val().getId()));
        }
    }

    static {
        UP_COATING = GolemItems.regModUpgrade("coating", () -> COATING, "create").lang("Zinc Upgrade").register();
        UP_PUSH = GolemItems.regModUpgrade("push", () -> PUSH, "create").lang("Extendo Upgrade").register();
        EFF_MOBILE = CreateCompatRegistry.genEffect("mechanical_mobility", () -> new MechMobileEffect(MobEffectCategory.BENEFICIAL, -1), "Increase golem movement speed");
        EFF_FORCE = CreateCompatRegistry.genEffect("mechanical_force", () -> new MechForceEffect(MobEffectCategory.BENEFICIAL, -1), "Increase golem attack damage");
        DUMMY = ModularGolems.REGISTRATE.item("dummy_furnace", p -> new DummyFurnace()).model((ctx, pvd) -> pvd.withExistingParent("item/" + ctx.getName(), "block/air")).removeTab(GolemItems.ITEMS.key()).register();
    }
}

