/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.compat.materials.common;

import com.tterrag.registrate.providers.RegistrateLangProvider;
import com.tterrag.registrate.providers.RegistrateRecipeProvider;
import dev.xkmc.l2core.serial.config.BaseConfig;
import dev.xkmc.l2core.serial.config.ConfigDataProvider;
import dev.xkmc.modulargolems.compat.maid.MaidRegistry;
import dev.xkmc.modulargolems.compat.materials.allthemodium.ATMDispatch;
import dev.xkmc.modulargolems.compat.materials.cataclysm.CataDispatch;
import dev.xkmc.modulargolems.compat.materials.common.ModDispatch;
import dev.xkmc.modulargolems.compat.materials.create.CreateDispatch;
import dev.xkmc.modulargolems.compat.materials.iceandfire.IAFDispatch;
import dev.xkmc.modulargolems.compat.materials.l2complements.LCDispatch;
import dev.xkmc.modulargolems.compat.materials.l2hostility.LHDispatch;
import dev.xkmc.modulargolems.compat.materials.mowziesmobs.MowzieDispatch;
import dev.xkmc.modulargolems.compat.materials.twilightforest.TFDispatch;
import dev.xkmc.modulargolems.compat.misc.CEICompat;
import dev.xkmc.modulargolems.compat.musket.GolemMusketCompat;
import dev.xkmc.modulargolems.content.config.GolemMaterialConfig;
import dev.xkmc.modulargolems.init.data.MGConfigGen;
import dev.xkmc.modulargolems.init.loot.MGGLMGen;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.data.event.GatherDataEvent;

public abstract class CompatManager {
    public static final List<ModDispatch> LIST = new ArrayList<ModDispatch>();
    private static Map<ResourceLocation, Ingredient> ALL_CONFIGS;

    public static void register() {
        if (ModList.get().isLoaded("twilightforest")) {
            LIST.add(new TFDispatch());
        }
        if (ModList.get().isLoaded("create")) {
            LIST.add(new CreateDispatch());
        }
        if (ModList.get().isLoaded("l2complements")) {
            LIST.add(new LCDispatch());
        }
        if (ModList.get().isLoaded("l2hostility")) {
            LIST.add(new LHDispatch());
        }
        if (ModList.get().isLoaded("cataclysm")) {
            LIST.add(new CataDispatch());
        }
        if (ModList.get().isLoaded("iceandfire")) {
            LIST.add(new IAFDispatch());
        }
        if (ModList.get().isLoaded("allthemodium")) {
            LIST.add(new ATMDispatch());
        }
        if (ModList.get().isLoaded("mowziesmobs")) {
            LIST.add(new MowzieDispatch());
        }
        if (ModList.get().isLoaded("create_enchantment_industry")) {
            CEICompat.register();
        }
        if (ModList.get().isLoaded("touhou_little_maid")) {
            MaidRegistry.register();
        }
    }

    public static void commonSetup() {
        for (ModDispatch dispatch : LIST) {
            dispatch.commonSetup();
        }
        if (ModList.get().isLoaded("musketmod")) {
            GolemMusketCompat.init();
        }
    }

    public static void dispatchGenLang(RegistrateLangProvider pvd) {
        for (ModDispatch dispatch : LIST) {
            dispatch.genLang(pvd);
        }
    }

    public static void gatherData(GatherDataEvent event) {
        for (ModDispatch dispatch : LIST) {
            ConfigDataProvider gen = dispatch.getDataGen(event.getGenerator(), event.getLookupProvider());
            if (gen == null) continue;
            event.getGenerator().addProvider(event.includeServer(), (DataProvider)gen);
        }
    }

    public static void dispatchGenRecipe(RegistrateRecipeProvider pvd) {
        for (ModDispatch dispatch : LIST) {
            dispatch.genRecipe(pvd);
        }
    }

    public static void dispatchClientSetup() {
        for (ModDispatch dispatch : LIST) {
            dispatch.dispatchClientSetup();
        }
    }

    public static void lateRegister() {
        for (ModDispatch dispatch : LIST) {
            dispatch.lateRegister();
        }
    }

    public static void onGLMGen(MGGLMGen pvd) {
        for (ModDispatch dispatch : LIST) {
            dispatch.genLootModifier(pvd);
        }
    }

    public static Map<ResourceLocation, Ingredient> gatherConfig() {
        if (ALL_CONFIGS != null) {
            return ALL_CONFIGS;
        }
        ConfigDataProvider.Collector map = new ConfigDataProvider.Collector(new HashMap());
        for (ModDispatch dispatch : LIST) {
            ConfigDataProvider gen = dispatch.getDataGen(null, null);
            gen.add(map);
        }
        new MGConfigGen(null, null).add(map);
        HashMap<ResourceLocation, Ingredient> ing = new HashMap<ResourceLocation, Ingredient>();
        for (ConfigDataProvider.ConfigEntry config : map.map().values()) {
            BaseConfig baseConfig = config.config();
            if (!(baseConfig instanceof GolemMaterialConfig)) continue;
            GolemMaterialConfig mat = (GolemMaterialConfig)baseConfig;
            ing.putAll(mat.ingredients);
        }
        ALL_CONFIGS = ing;
        return ing;
    }
}

