/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.compat.materials.cataclysm.modifiers;

import dev.xkmc.modulargolems.compat.materials.cataclysm.CataCompatRegistry;
import dev.xkmc.modulargolems.compat.materials.cataclysm.CataclysmProxy;
import dev.xkmc.modulargolems.content.core.GolemStatType;
import dev.xkmc.modulargolems.content.entity.common.AbstractGolemEntity;
import dev.xkmc.modulargolems.content.entity.common.GolemFlags;
import dev.xkmc.modulargolems.content.modifier.base.AttributeGolemModifier;
import dev.xkmc.modulargolems.content.modifier.special.EarthquakeHelper;
import dev.xkmc.modulargolems.init.data.MGConfig;
import dev.xkmc.modulargolems.init.registrate.GolemTypes;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;

public class NetheriteMonstrosityEarthquakeModifier
extends AttributeGolemModifier
implements EarthquakeHelper.Modifier {
    public NetheriteMonstrosityEarthquakeModifier() {
        super(1, new AttributeGolemModifier.AttrEntry((Supplier<GolemStatType>)GolemTypes.STAT_ATTACK, () -> 5.0), new AttributeGolemModifier.AttrEntry((Supplier<GolemStatType>)GolemTypes.STAT_ARMOR, () -> 5.0), new AttributeGolemModifier.AttrEntry((Supplier<GolemStatType>)GolemTypes.STAT_TOUGH, () -> 5.0));
    }

    @Override
    public void onRegisterFlag(Consumer<GolemFlags> cons) {
        cons.accept(GolemFlags.EARTH_QUAKE);
    }

    @Override
    public void handleEvent(AbstractGolemEntity<?, ?> golem, int value, byte event) {
        if (event == 83) {
            EarthquakeHelper.makeParticles(golem, 0.0f, 0.0f);
        }
    }

    @Override
    public void performEarthQuake(AbstractGolemEntity<?, ?> golem, int level) {
        golem.playSound((SoundEvent)SoundEvents.GENERIC_EXPLODE.value(), 1.5f, 1.0f + golem.getRandom().nextFloat() * 0.1f);
        for (LivingEntity entity : golem.level().getEntitiesOfClass(LivingEntity.class, golem.getBoundingBox().inflate(7.0))) {
            boolean flag;
            if (golem.isAlliedTo((Entity)entity) || entity == golem) continue;
            float damage = (float)(golem.getAttributeValue(Attributes.ATTACK_DAMAGE) + (double)(entity.getMaxHealth() * CataclysmProxy.monstrosityEarthquakeDamage()));
            float factor = 0.0f;
            if (golem.getItemBySlot(EquipmentSlot.HEAD).is((Item)CataCompatRegistry.MONSTROSITY_HELMET.get())) {
                factor += 1.0f;
            }
            if (golem.getItemBySlot(EquipmentSlot.CHEST).is((Item)CataCompatRegistry.MONSTROSITY_CHESTPLATE.get())) {
                factor += 1.0f;
            }
            if (golem.getItemBySlot(EquipmentSlot.LEGS).is((Item)CataCompatRegistry.MONSTROSITY_SHINGUARD.get())) {
                factor += 1.0f;
            }
            if (!(flag = entity.hurt(golem.damageSources().mobAttack(golem), damage * (1.0f + ((Double)MGConfig.COMMON.earthquakeArmorBonus.get()).floatValue() * factor)))) continue;
            EarthquakeHelper.launch(golem, (Entity)entity, 2.0f);
        }
    }
}

