/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.compat.materials.cataclysm.modifiers;

import dev.xkmc.modulargolems.compat.materials.cataclysm.CataclysmProxy;
import dev.xkmc.modulargolems.compat.materials.cataclysm.modifiers.LeviathanBlastPortalAttackGoal;
import dev.xkmc.modulargolems.content.core.StatFilterType;
import dev.xkmc.modulargolems.content.entity.common.AbstractGolemEntity;
import dev.xkmc.modulargolems.content.modifier.base.GolemModifier;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.VoxelShape;

public class LeviathanBlastPortalModifier
extends GolemModifier {
    public static void addBeam(LivingEntity user, LivingEntity target) {
        double tx = target.getX();
        double ty = target.getY();
        double tz = target.getZ();
        float f = (float)Mth.atan2((double)(tz - user.getZ()), (double)(tx - user.getX()));
        LeviathanBlastPortalModifier.spawnFangs(user, user.level(), tx, tz, ty - 50.0, ty + 3.0, f, 0);
    }

    private static void spawnFangs(LivingEntity user, Level level, double x, double z, double minY, double maxY, float rotation, int delay) {
        BlockPos pos = BlockPos.containing((double)x, (double)maxY, (double)z);
        boolean flag = false;
        double dy = 0.0;
        do {
            VoxelShape shape;
            BlockPos next;
            BlockState state;
            if (!(state = level.getBlockState(next = pos.below())).isFaceSturdy((BlockGetter)level, next, Direction.UP)) continue;
            if (!level.isEmptyBlock(pos) && !(shape = level.getBlockState(pos).getCollisionShape((BlockGetter)level, pos)).isEmpty()) {
                dy = shape.max(Direction.Axis.Y);
            }
            flag = true;
            break;
        } while ((pos = pos.below()).getY() >= Mth.floor((double)minY) - 1);
        if (flag) {
            CataclysmProxy.spawnBlastPortal(user, x, (double)pos.getY() + dy, z, rotation, delay);
        }
    }

    public LeviathanBlastPortalModifier() {
        super(StatFilterType.MASS, 3);
    }

    @Override
    public void onRegisterGoals(AbstractGolemEntity<?, ?> entity, int lv, BiConsumer<Integer, Goal> addGoal) {
        addGoal.accept(5, new LeviathanBlastPortalAttackGoal(entity, lv));
    }
}

