/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.compat.materials.cataclysm;

import com.google.common.collect.ImmutableMultimap;
import dev.xkmc.l2damagetracker.init.L2DamageTracker;
import dev.xkmc.modulargolems.content.item.equipments.MetalGolemArmorItem;
import dev.xkmc.modulargolems.init.ModularGolems;
import dev.xkmc.modulargolems.init.data.MGConfig;
import dev.xkmc.modulargolems.init.data.MGLangData;
import dev.xkmc.modulargolems.init.registrate.GolemTypes;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;

public class HarbingerArmorItem
extends MetalGolemArmorItem {
    public HarbingerArmorItem(Item.Properties properties, ArmorItem.Type type, int defense, float toughness, ResourceLocation model) {
        super(properties, type, defense, toughness, model);
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext level, List<Component> list, TooltipFlag flag) {
        super.appendHoverText(stack, level, list, flag);
        switch (this.getSlot()) {
            case HEAD: {
                list.add((Component)MGLangData.HARBINGER_BOOST_LASER.get(Math.round((Double)MGConfig.COMMON.laserArmorBonus.get() * 100.0) + "%").withStyle(ChatFormatting.GOLD));
                break;
            }
            case CHEST: {
                list.add((Component)MGLangData.HARBINGER_BOOST_MISSILE.get(Math.round((Double)MGConfig.COMMON.missileArmorBonus.get() * 100.0) + "%").withStyle(ChatFormatting.GOLD));
            }
        }
    }

    @Override
    public boolean emissive() {
        return true;
    }

    @Override
    protected String namespace(String def) {
        return "cataclysm";
    }

    @Override
    protected void additionalAttributes(ImmutableMultimap.Builder<Holder<Attribute>, AttributeModifier> builder) {
        super.additionalAttributes(builder);
        ResourceLocation id = ModularGolems.loc("harbinger_armor");
        builder.put((Object)L2DamageTracker.ABSORB, (Object)new AttributeModifier(id, 1.0, AttributeModifier.Operation.ADD_VALUE));
        switch (this.getSlot()) {
            case HEAD: {
                builder.put(GolemTypes.GOLEM_REGEN, (Object)new AttributeModifier(id, 1.0, AttributeModifier.Operation.ADD_VALUE));
                break;
            }
            case CHEST: {
                builder.put(GolemTypes.GOLEM_SWEEP, (Object)new AttributeModifier(id, 1.0, AttributeModifier.Operation.ADD_VALUE));
                break;
            }
            case LEGS: {
                builder.put((Object)Attributes.MOVEMENT_SPEED, (Object)new AttributeModifier(id, 0.5, AttributeModifier.Operation.ADD_MULTIPLIED_BASE));
            }
        }
    }
}

