/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.compat.materials.cataclysm;

import com.github.L_Ender.cataclysm.config.CMConfig;
import com.github.L_Ender.cataclysm.entity.AnimationMonster.BossMonsters.The_Leviathan.Abyss_Blast_Portal_Entity;
import com.github.L_Ender.cataclysm.entity.effect.Sandstorm_Entity;
import com.github.L_Ender.cataclysm.entity.projectile.Death_Laser_Beam_Entity;
import com.github.L_Ender.cataclysm.entity.projectile.Ignis_Abyss_Fireball_Entity;
import com.github.L_Ender.cataclysm.entity.projectile.Ignis_Fireball_Entity;
import com.github.L_Ender.cataclysm.entity.projectile.ThrownCoral_Spear_Entity;
import com.github.L_Ender.cataclysm.entity.projectile.Void_Rune_Entity;
import com.github.L_Ender.cataclysm.entity.projectile.Wither_Homing_Missile_Entity;
import com.github.L_Ender.cataclysm.init.ModEffect;
import com.github.L_Ender.cataclysm.init.ModEntities;
import dev.xkmc.modulargolems.content.entity.common.AbstractGolemEntity;
import dev.xkmc.modulargolems.init.ModularGolems;
import net.minecraft.core.Holder;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.registries.DeferredHolder;
import org.jetbrains.annotations.Nullable;

public class CataclysmProxy {
    public static void sandstormAttack(LivingEntity golem, LivingEntity target, int life) {
        try {
            Vec3 diff = target.position().subtract(golem.position()).normalize();
            float angle = (float)Math.atan2(diff.z, diff.x);
            double sx = target.getX();
            double sy = target.getY();
            double sz = target.getZ();
            Sandstorm_Entity projectile = new Sandstorm_Entity(golem.level(), sx, sy, sz, life, angle, golem);
            golem.level().addFreshEntity((Entity)projectile);
        }
        catch (Throwable e) {
            ModularGolems.LOGGER.error((Object)e);
        }
    }

    public static boolean isLaser(DamageSource source) {
        try {
            return source.getDirectEntity() instanceof Death_Laser_Beam_Entity;
        }
        catch (Throwable e) {
            return false;
        }
    }

    public static boolean isMissile(DamageSource source) {
        try {
            return source.getDirectEntity() instanceof Wither_Homing_Missile_Entity;
        }
        catch (Throwable e) {
            return false;
        }
    }

    @Nullable
    public static Entity addLaserBeam(LivingEntity user, int dur) {
        try {
            Death_Laser_Beam_Entity beam = new Death_Laser_Beam_Entity((EntityType)ModEntities.DEATH_LASER_BEAM.get(), user.level(), user, user.getX(), user.getEyeY(), user.getZ(), (user.yHeadRot + 90.0f) * ((float)Math.PI / 180), -user.getXRot() * ((float)Math.PI / 180), dur, (float)CMConfig.DeathLaserdamage, (float)CMConfig.DeathLaserHpdamage);
            user.level().addFreshEntity((Entity)beam);
            return beam;
        }
        catch (Throwable e) {
            ModularGolems.LOGGER.error((Object)e);
            return null;
        }
    }

    public static void addMissile(LivingEntity user, LivingEntity target, Vec3 pos) {
        try {
            Vec3 diff = target.getEyePosition().subtract(pos).normalize();
            Wither_Homing_Missile_Entity laserBeam = new Wither_Homing_Missile_Entity(user, diff, user.level(), (float)CMConfig.HarbingerWitherMissiledamage, target);
            laserBeam.setPosRaw(pos.x(), pos.y(), pos.z());
            user.level().addFreshEntity((Entity)laserBeam);
        }
        catch (Throwable e) {
            ModularGolems.LOGGER.error((Object)e);
        }
    }

    public static void spawnFangs(LivingEntity user, double x, double y, double z, float rotation, int delay) {
        try {
            user.level().addFreshEntity((Entity)new Void_Rune_Entity(user.level(), x, y, z, rotation, delay, (float)CMConfig.Voidrunedamage, user));
        }
        catch (Throwable e) {
            ModularGolems.LOGGER.error((Object)e);
        }
    }

    public static void spawnBlastPortal(LivingEntity user, double x, double y, double z, float rotation, int delay) {
        try {
            user.level().addFreshEntity((Entity)new Abyss_Blast_Portal_Entity(user.level(), x, y, z, rotation, delay, (float)CMConfig.AbyssBlastdamage, (float)CMConfig.AbyssBlastHpdamage, user));
        }
        catch (Throwable e) {
            ModularGolems.LOGGER.error((Object)e);
        }
    }

    public static void stackBlazingBrand(LivingEntity golem, LivingEntity target, int factor) {
        try {
            DeferredHolder eff = ModEffect.EFFECTBLAZING_BRAND;
            MobEffectInstance old = target.getEffect((Holder)eff);
            int i = old == null ? 0 : Math.min(4, old.getAmplifier() + 1);
            MobEffectInstance ins = new MobEffectInstance((Holder)eff, 240, i, false, true, true);
            target.addEffect(ins);
            golem.heal((float)factor * (float)CMConfig.IgnisHealingMultiplier * (float)(i + 1));
        }
        catch (Throwable e) {
            ModularGolems.LOGGER.error((Object)e);
        }
    }

    public static void shootFireball(LivingEntity user, Vec3 shotAt, int timer, boolean abyss) {
        try {
            Ignis_Abyss_Fireball_Entity shot;
            shotAt = shotAt.yRot(-user.getYRot() * ((float)Math.PI / 180));
            if (abyss) {
                bullet = new Ignis_Abyss_Fireball_Entity(user.level(), user);
                bullet.setUp(timer);
                shot = bullet;
            } else {
                bullet = new Ignis_Fireball_Entity(user.level(), user);
                bullet.setUp(timer);
                if (user.getHealth() < user.getMaxHealth() / 2.0f) {
                    bullet.setSoul(true);
                }
                shot = bullet;
            }
            float rot = user.yBodyRot * ((float)Math.PI / 180);
            double width = (double)(user.getBbWidth() + 1.0f) * 0.15;
            shot.setPos(user.getX() - width * (double)Mth.sin((float)rot), user.getY() + 1.0, user.getZ() + width * (double)Mth.cos((float)rot));
            double d0 = shotAt.x;
            double d1 = shotAt.y;
            double d2 = shotAt.z;
            float f = Mth.sqrt((float)((float)(d0 * d0 + d2 * d2))) * 0.35f;
            shot.shoot(d0, d1 + (double)f, d2, 0.25f, 3.0f);
            user.level().addFreshEntity((Entity)shot);
        }
        catch (Throwable e) {
            ModularGolems.LOGGER.error((Object)e);
        }
    }

    public static float monstrosityEarthquakeDamage() {
        try {
            return (float)CMConfig.MonstrositysHpdamage;
        }
        catch (Throwable e) {
            ModularGolems.LOGGER.error((Object)e);
            return 0.0f;
        }
    }

    public static float maledictusEarthquakeDamage() {
        try {
            return (float)CMConfig.MaledictusAOEHpDamage;
        }
        catch (Throwable e) {
            ModularGolems.LOGGER.error((Object)e);
            return 0.0f;
        }
    }

    public static void updateLaser(AbstractGolemEntity<?, ?> golem, Entity e) {
        try {
            if (e instanceof Death_Laser_Beam_Entity) {
                Death_Laser_Beam_Entity beam = (Death_Laser_Beam_Entity)e;
                beam.setYaw((float)((double)(golem.yHeadRot + 90.0f) * Math.PI / 180.0));
                beam.setPitch((float)((double)(-golem.getXRot()) * Math.PI / 180.0));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static Projectile coralSpear(LivingEntity user, Level level, ItemStack stack) {
        ThrownCoral_Spear_Entity throwntrident = new ThrownCoral_Spear_Entity(level, user, stack);
        throwntrident.pickup = AbstractArrow.Pickup.CREATIVE_ONLY;
        throwntrident.setPos(user.getEyePosition().add(user.getForward()));
        return throwntrident;
    }
}

