/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.compat.maid;

import com.github.tartaricacid.touhoulittlemaid.api.task.IAttackTask;
import com.github.tartaricacid.touhoulittlemaid.api.task.IRangedAttackTask;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitSounds;
import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import dev.xkmc.modulargolems.compat.maid.GolemSummonUtils;
import dev.xkmc.modulargolems.compat.maid.MaidManageGolemBehavior;
import dev.xkmc.modulargolems.compat.maid.MaidSummonerStrafingBehavior;
import dev.xkmc.modulargolems.init.ModularGolems;
import dev.xkmc.modulargolems.init.data.MGTagGen;
import dev.xkmc.modulargolems.init.registrate.GolemItems;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.EntityTracker;
import net.minecraft.world.entity.ai.behavior.PositionTracker;
import net.minecraft.world.entity.ai.behavior.StartAttacking;
import net.minecraft.world.entity.ai.behavior.StopAttackingIfTargetInvalid;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.NearestVisibleLivingEntities;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.item.ItemStack;

public class MaidSummonerTask
implements IRangedAttackTask {
    public static final ResourceLocation UID = ModularGolems.loc("summon_golems");
    public static final int STOP_MOVING_DIST = 24;
    public static final int STOP_ATTACK_DIST = 35;

    public ResourceLocation getUid() {
        return UID;
    }

    public ItemStack getIcon() {
        return GolemItems.HOLDER_GOLEM.asStack();
    }

    @Nullable
    public SoundEvent getAmbientSound(EntityMaid maid) {
        return (SoundEvent)InitSounds.MAID_FIND_TARGET.get();
    }

    public List<Pair<Integer, BehaviorControl<? super EntityMaid>>> createBrainTasks(EntityMaid maid) {
        return Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)5, this.createStartAttack()), Pair.of((Object)5, this.createStopAttack(maid)), Pair.of((Object)5, this.createMoveToTarget(0.6f)), Pair.of((Object)5, (Object)((Object)new MaidSummonerStrafingBehavior(20, 24))), Pair.of((Object)5, (Object)((Object)new MaidManageGolemBehavior()))});
    }

    public List<Pair<Integer, BehaviorControl<? super EntityMaid>>> createRideBrainTasks(EntityMaid maid) {
        return Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)5, this.createStartAttack()), Pair.of((Object)5, this.createStopAttack(maid)), Pair.of((Object)5, (Object)((Object)new MaidManageGolemBehavior()))});
    }

    private void stopAttack(EntityMaid self, LivingEntity target) {
        GolemSummonUtils.collectAll(self);
    }

    public List<Pair<String, Predicate<EntityMaid>>> getConditionDescription(EntityMaid maid) {
        return Collections.singletonList(Pair.of((Object)"has_golem_wand", MaidSummonerTask::hasGolemWand));
    }

    public void performRangedAttack(EntityMaid maid, LivingEntity target, float v) {
    }

    public float searchRadius(EntityMaid maid) {
        return 35.0f;
    }

    public static boolean hasGolemWand(EntityMaid maid) {
        return maid.getMainHandItem().is(MGTagGen.GOLEM_OMNI_WAND);
    }

    private boolean farAway(LivingEntity target, EntityMaid maid) {
        return maid.distanceTo((Entity)target) > 35.0f;
    }

    private BehaviorControl<EntityMaid> createStartAttack() {
        return StartAttacking.create(MaidSummonerTask::hasGolemWand, IAttackTask::findFirstValidAttackTarget);
    }

    private BehaviorControl<EntityMaid> createStopAttack(EntityMaid maid) {
        return StopAttackingIfTargetInvalid.create(target -> !MaidSummonerTask.hasGolemWand(maid) || this.farAway((LivingEntity)target, maid), this::stopAttack, (boolean)true);
    }

    private BehaviorControl<EntityMaid> createMoveToTarget(float speed) {
        return BehaviorBuilder.create(ins -> ins.group((App)ins.registered(MemoryModuleType.WALK_TARGET), (App)ins.registered(MemoryModuleType.LOOK_TARGET), (App)ins.registered(MemoryModuleType.INTERACTION_TARGET), (App)ins.present(MemoryModuleType.ATTACK_TARGET), (App)ins.registered(MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES)).apply((Applicative)ins, (toNavigate, toLook, interactTarget, attackTarget, targetList) -> (level, self, time) -> {
            Optional fix = ins.tryGet(interactTarget);
            if (fix.isPresent()) {
                toLook.set((Object)new EntityTracker((Entity)fix.get(), true));
                if (self.closerThan((Entity)fix.get(), 1.5)) {
                    toNavigate.erase();
                } else {
                    toNavigate.set((Object)new WalkTarget((PositionTracker)new EntityTracker((Entity)fix.get(), false), speed, 0));
                }
            } else {
                LivingEntity atk = (LivingEntity)ins.get(attackTarget);
                Optional optList = ins.tryGet(targetList);
                if (optList.isPresent() && ((NearestVisibleLivingEntities)optList.get()).contains(atk) && self.closerThan((Entity)atk, 24.0)) {
                    toNavigate.erase();
                } else {
                    toLook.set((Object)new EntityTracker((Entity)atk, true));
                    toNavigate.set((Object)new WalkTarget((PositionTracker)new EntityTracker((Entity)atk, false), speed, 0));
                }
            }
            return true;
        }));
    }
}

