/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.compat.maid;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.google.common.collect.ImmutableMap;
import dev.xkmc.modulargolems.compat.maid.MaidSummonerTask;
import java.util.Map;
import java.util.Optional;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;

public class MaidSummonerStrafingBehavior
extends Behavior<EntityMaid> {
    private boolean strafingClockwise;
    private boolean strafingBackwards;
    private int strafingTime = -1;
    private final int startDist;
    private final int endDist;

    public MaidSummonerStrafingBehavior(int startDist, int endDist) {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.WALK_TARGET, (Object)MemoryStatus.VALUE_ABSENT, (Object)MemoryModuleType.LOOK_TARGET, (Object)MemoryStatus.REGISTERED, (Object)MemoryModuleType.ATTACK_TARGET, (Object)MemoryStatus.VALUE_PRESENT, (Object)MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES, (Object)MemoryStatus.VALUE_PRESENT), 1200);
        this.startDist = startDist;
        this.endDist = endDist;
    }

    protected boolean checkExtraStartConditions(ServerLevel worldIn, EntityMaid owner) {
        return MaidSummonerTask.hasGolemWand(owner) && owner.getBrain().getMemory(MemoryModuleType.ATTACK_TARGET).filter(Entity::isAlive).isPresent();
    }

    protected void tick(ServerLevel worldIn, EntityMaid owner, long gameTime) {
        Optional opt = owner.getBrain().getMemory(MemoryModuleType.ATTACK_TARGET);
        if (opt.isEmpty()) {
            return;
        }
        LivingEntity target = (LivingEntity)opt.get();
        double distance = owner.distanceTo((Entity)target);
        this.strafingTime = distance < (double)owner.searchRadius() ? ++this.strafingTime : -1;
        if (this.strafingTime >= 20) {
            if ((double)owner.getRandom().nextFloat() < 0.3) {
                boolean bl = this.strafingClockwise = !this.strafingClockwise;
            }
            if ((double)owner.getRandom().nextFloat() < 0.3) {
                this.strafingBackwards = !this.strafingBackwards;
            }
            this.strafingTime = 0;
        }
        if (this.strafingTime > -1) {
            if (distance > (double)this.endDist) {
                this.strafingBackwards = false;
            } else if (distance < (double)this.startDist) {
                this.strafingBackwards = true;
            }
            owner.getMoveControl().strafe(this.strafingBackwards ? -0.5f : 0.5f, this.strafingClockwise ? 0.5f : -0.5f);
            owner.setYRot(Mth.rotateIfNecessary((float)owner.getYRot(), (float)owner.yHeadRot, (float)0.0f));
            BehaviorUtils.lookAtEntity((LivingEntity)owner, (LivingEntity)target);
        } else {
            BehaviorUtils.lookAtEntity((LivingEntity)owner, (LivingEntity)target);
        }
    }

    protected void start(ServerLevel worldIn, EntityMaid entityIn, long gameTimeIn) {
        entityIn.setSwingingArms(true);
    }

    protected void stop(ServerLevel worldIn, EntityMaid entityIn, long gameTimeIn) {
        entityIn.setSwingingArms(false);
        entityIn.getMoveControl().strafe(0.0f, 0.0f);
    }

    protected boolean canStillUse(ServerLevel worldIn, EntityMaid entityIn, long gameTimeIn) {
        return this.checkExtraStartConditions(worldIn, entityIn);
    }
}

