/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.compat.maid;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import dev.xkmc.l2core.init.reg.simple.Val;
import dev.xkmc.modulargolems.compat.maid.GolemSummonUtils;
import dev.xkmc.modulargolems.events.event.GolemToOwnerEvent;
import dev.xkmc.modulargolems.init.ModularGolems;
import dev.xkmc.modulargolems.init.data.MGTagGen;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.tick.EntityTickEvent;
import net.neoforged.neoforge.items.wrapper.CombinedInvWrapper;

public class MaidRegistry {
    public static final Val<MemoryModuleType<List<UUID>>> GOLEMS = new Val.Registrate(ModularGolems.REGISTRATE.simple("golem_ids", Registries.MEMORY_MODULE_TYPE, () -> new MemoryModuleType(Optional.of(UUIDUtil.CODEC.listOf()))));

    @SubscribeEvent
    public static void onGolemReturn(GolemToOwnerEvent event) {
        EntityMaid maid;
        LivingEntity livingEntity = event.getOwner();
        if (livingEntity instanceof EntityMaid && GolemSummonUtils.returnToInv(maid = (EntityMaid)livingEntity, event.getStack())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void maidTick(EntityTickEvent.Post event) {
        Entity entity = event.getEntity();
        if (entity instanceof EntityMaid) {
            EntityMaid maid = (EntityMaid)entity;
            CombinedInvWrapper inv = maid.getAvailableInv(false);
            for (int i = 0; i < inv.getSlots(); ++i) {
                ItemStack stack = inv.getStackInSlot(i);
                if (!stack.is(MGTagGen.GOLEM_HOLDERS)) continue;
                stack.inventoryTick(maid.level(), (Entity)maid, i, false);
                inv.setStackInSlot(i, stack);
            }
        }
    }

    public static void register() {
        NeoForge.EVENT_BUS.register(MaidRegistry.class);
    }
}

